/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqProcessDefinition;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqApplicationType;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;

/**
 * Creates a {@link WmqProcessDefinition} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqProcessDefinitionStep extends BaseWmqStep {

	public WmqProcessDefinition wmqProcessDefinition;

	@Override
	protected void init() {

		this.mqCommand = MQConstants.MQCMD_CREATE_PROCESS;
	}

	public CreateWmqProcessDefinitionStep(WmqProcessDefinition wmqProcessDefinition, WmqQueueManager wmqQmanager) {

		this.wmqProcessDefinition = wmqProcessDefinition;
		this.wmqQmanager = wmqQmanager;

	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {

		// Name of the Process - Mandatory.ProcessName is the name of the process definition to be changed or created.

		pcfCmd.addParameter(MQConstants.MQCA_PROCESS_NAME, wmqProcessDefinition.getProcessName());

		// Description of the Process Definition.

		if (wmqProcessDefinition.getDescription() != null && !"".equals(wmqProcessDefinition.getDescription())) {
			pcfCmd.addParameter(MQConstants.MQCA_PROCESS_DESC, wmqProcessDefinition.getDescription());
		}

		// Application Type of Process Definition.If no value is selected,the default value is taken.

		if (wmqProcessDefinition.getApplicationType() != null && wmqProcessDefinition.getApplicationTypeInt() >= 65536
		        && wmqProcessDefinition.getApplicationTypeInt() < 999999999) {
			throw new MQPluginException("ApplicationType and ApplicationTypeInt both should not be given at a time in CI");
		}

		if (wmqProcessDefinition.getApplicationTypeInt() >= 65536 && wmqProcessDefinition.getApplicationTypeInt() < 999999999) {
			pcfCmd.addParameter(MQConstants.MQIA_APPL_TYPE, wmqProcessDefinition.getApplicationTypeInt());
		}

		if (WmqApplicationType.WINDOWS_NT == wmqProcessDefinition.getApplicationType()) {
			pcfCmd.addParameter(MQConstants.MQIA_APPL_TYPE, MQConstants.MQAT_WINDOWS_NT);
		} else if (WmqApplicationType.WINDOWS == wmqProcessDefinition.getApplicationType()) {
			pcfCmd.addParameter(MQConstants.MQIA_APPL_TYPE, MQConstants.MQAT_WINDOWS);
		} else if (WmqApplicationType.DEFAULT == wmqProcessDefinition.getApplicationType()) {
			pcfCmd.addParameter(MQConstants.MQIA_APPL_TYPE, MQConstants.MQAT_DEFAULT);
		} else if (WmqApplicationType.UNIX == wmqProcessDefinition.getApplicationType()) {
			pcfCmd.addParameter(MQConstants.MQIA_APPL_TYPE, MQConstants.MQAT_UNIX);
		} else if (WmqApplicationType.DOS == wmqProcessDefinition.getApplicationType()) {
			pcfCmd.addParameter(MQConstants.MQIA_APPL_TYPE, MQConstants.MQAT_DOS);
		} else if (WmqApplicationType.CICS == wmqProcessDefinition.getApplicationType()) {
			pcfCmd.addParameter(MQConstants.MQIA_APPL_TYPE, MQConstants.MQAT_CICS);
		} else if (WmqApplicationType.OS400 == wmqProcessDefinition.getApplicationType()) {
			pcfCmd.addParameter(MQConstants.MQIA_APPL_TYPE, MQConstants.MQAT_OS400);
		}

		// Application ID of process definition.

		pcfCmd.addParameter(MQConstants.MQCA_APPL_ID, wmqProcessDefinition.getApplicationId());

		// Environment data is a character string that contains environment information pertaining to the application to be started.
		if (wmqProcessDefinition.getEnvironmentData() != null && !"".equals(wmqProcessDefinition.getEnvironmentData())) {
			pcfCmd.addParameter(MQConstants.MQCA_ENV_DATA, wmqProcessDefinition.getEnvironmentData());
		}

		// Userdata is a character string that contains user information pertaining to the application (defined by ApplId) that is to be started.

		if (wmqProcessDefinition.getUserData() != null && !"".equals(wmqProcessDefinition.getUserData())) {
			pcfCmd.addParameter(MQConstants.MQCA_USER_DATA, wmqProcessDefinition.getUserData());
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating ProcessDefinition \"" + wmqProcessDefinition.getProcessName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName()
			        + "\"";
		}
		return "Creating ProcessDefinition Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The ProcessDefinition \"" + wmqProcessDefinition.getProcessName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName()
		        + "\"";

	}

}
