/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqServerChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDataConversion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqServerChannel} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqServerChannelStep extends BaseWmqStep {

	public WmqServerChannel wmqServerChannel;
	private int[] messageCompressionList = new int[1];

	public CreateWmqServerChannelStep(WmqServerChannel wmqServerChannel, WmqQueueManager wmqQmanager) {

		this.wmqServerChannel = wmqServerChannel;
		this.wmqQmanager = wmqQmanager;
	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_CHANNEL;

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Setting MQ ServerChannelName
		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, wmqServerChannel.getChannelName());

		// Setting MQ ServerChannelType
		pcfCmd.addParameter(MQConstants.MQIACH_CHANNEL_TYPE, MQConstants.MQCHT_SERVER);

		// Setting MQ ServerChannel Description
		if (StringUtils.isNotBlank(wmqServerChannel.getDescription())) {

			pcfCmd.addParameter(MQConstants.MQCACH_DESC, wmqServerChannel.getDescription());
		}

		// Setting MQ ServerChannel Transport Type
		if (WmqTransmissionProtocolTypes.LU6 == wmqServerChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_LU62);

		} else if (WmqTransmissionProtocolTypes.NET_BIOS == wmqServerChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_NETBIOS);

		} else if (WmqTransmissionProtocolTypes.SPX == wmqServerChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_SPX);
		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_TCP);
		}

		// Setting MQ ServerChannel Connection name
		if (StringUtils.isNotBlank(wmqServerChannel.getConnectionName())) {

			pcfCmd.addParameter(MQConstants.MQCACH_CONNECTION_NAME, wmqServerChannel.getConnectionName());
		}

		// Setting MQ ServerChannel TransmissinQueue
		pcfCmd.addParameter(MQConstants.MQCACH_XMIT_Q_NAME, wmqServerChannel.getTransmissionQueue());

		// Setting MQ ServerChannel Local communications address
		if (StringUtils.isNotBlank(wmqServerChannel.getLocalCommunicationAddress())) {

			pcfCmd.addParameter(MQConstants.MQCACH_LOCAL_ADDRESS, wmqServerChannel.getLocalCommunicationAddress());
		}

		// Setting MQ ServerChannel HeaderCompression value
		if (WmqHeaderCompression.SYSTEM == wmqServerChannel.getHeaderCompression()) {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_SYSTEM;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		} else {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_NONE;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		}

		// Setting MQ ServerChannel HeartbeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_HB_INTERVAL, wmqServerChannel.getHeartBeatInterval());

		// Setting MQ ServerChannel KeepaliveInterval
		if (wmqServerChannel.getKeepAliveInterval() > -1 && wmqServerChannel.getKeepAliveInterval() <= 99999) {
			pcfCmd.addParameter(MQConstants.MQIACH_KEEP_ALIVE_INTERVAL, wmqServerChannel.getKeepAliveInterval());
		}

		// Setting MQ ServerChannel MaximumMessageLength
		pcfCmd.addParameter(MQConstants.MQIACH_MAX_MSG_LENGTH, wmqServerChannel.getMaximumMessageLength());

		// Setting MQ ServerChannel maximum message sequence number
		if (wmqServerChannel.getSequenceNumberWrap() < 100) {
			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, 999999999);
		} else if (wmqServerChannel.getSequenceNumberWrap() != 0) {

			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, wmqServerChannel.getSequenceNumberWrap());
		}

		// Setting MQ ServerChannel MessageCompression Value
		if (WmqMessageCompression.RLE == wmqServerChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_RLE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqMessageCompression.ZLIBFAST == wmqServerChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBFAST;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqMessageCompression.ZLIBHIGH == wmqServerChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBHIGH;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else {
			messageCompressionList[0] = MQConstants.MQCOMPRESS_NONE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		}

		// Setting MQ ServerChannel NonPersistentMessageSpeed
		if (WmqNonpersistentMessageSpeed.NORMAL == wmqServerChannel.getNonPersistentMessageSpeed()) {

			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_NORMAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_FAST);
		}

		// Setting MQ ServerChannel BatchSize
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_SIZE, wmqServerChannel.getBatchSize());

		// Setting MQ ServerChannel BatchInterval
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_INTERVAL, wmqServerChannel.getBatchInterval());

		// Setting MQ ServerChannel DisconnectInterval
		pcfCmd.addParameter(MQConstants.MQIACH_DISC_INTERVAL, wmqServerChannel.getDisconnectInterval());

		// Setting MQ ServerChannel DataConversion value
		if (WmqDataConversion.CONVERSION == wmqServerChannel.getDataConversion()) {

			pcfCmd.addParameter(MQConstants.MQIACH_DATA_CONVERSION, MQConstants.MQCDC_SENDER_CONVERSION);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_DATA_CONVERSION, MQConstants.MQCDC_NO_SENDER_CONVERSION);
		}

		// Setting MQ ServerChannel BatchHeartBeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_HB, wmqServerChannel.getBatchHeartBeatInterval());

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
			// Setting MQ ServerChannel PropertyControl
			if (WmqChannelPropertyControl.ALL == wmqServerChannel.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_ALL);

			} else if (WmqChannelPropertyControl.NONE == wmqServerChannel.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_NONE);

			} else {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_COMPATIBILITY);
			}
		}

		// Setting MQ ServerChannel MCAUserID
		if (StringUtils.isNotBlank(wmqServerChannel.getMcaUserID())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MCA_USER_ID, wmqServerChannel.getMcaUserID());

		}

		// Setting MQ ServerChannel MCAType
		if (WmqChannelMCAType.THREAD == wmqServerChannel.getMcaType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_THREAD);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_PROCESS);
		}

		// Setting MQ ServerChannel SendExitname
		if (StringUtils.isNotBlank(wmqServerChannel.getSendExit())) {

			String[] sendExitList = StringUtils.split(wmqServerChannel.getSendExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_NAME, sendExitList);

		}

		// Setting MQ ServerChannel SendUserData
		if (StringUtils.isNotBlank(wmqServerChannel.getSendExitUserData())) {

			String[] sendExitUserDataList = StringUtils.split(wmqServerChannel.getSendExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_USER_DATA, sendExitUserDataList);
		}

		// Setting MQ ServerChannel ReceiveExit
		if (StringUtils.isNotBlank(wmqServerChannel.getReceiveExit())) {

			String[] receiveExitList = StringUtils.split(wmqServerChannel.getReceiveExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_NAME, receiveExitList);
		}

		// Setting MQ ServerChannel ReceiveUserData
		if (StringUtils.isNotBlank(wmqServerChannel.getReceiveExitUserData())) {

			String[] receiveExitUserDataList = StringUtils.split(wmqServerChannel.getReceiveExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_USER_DATA, receiveExitUserDataList);
		}

		// Setting MQ ServerChannel SecurityExit
		if (StringUtils.isNotBlank(wmqServerChannel.getSecurityExit())) {
			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_NAME, wmqServerChannel.getSecurityExit());
		}

		// Setting MQ ServerChannel SecurityUserData
		if (StringUtils.isNotBlank(wmqServerChannel.getSecurityExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_USER_DATA, wmqServerChannel.getSecurityExitUserData());
		}

		// Setting MQ ServerChannel MsgExit
		if (StringUtils.isNotBlank(wmqServerChannel.getMessageExitName())) {

			String[] messageExitList = StringUtils.split(wmqServerChannel.getMessageExitName(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_NAME, messageExitList);
		}

		// Setting MQ ServerChannel .MsgUserData
		if (StringUtils.isNotBlank(wmqServerChannel.getMessageExitUserData())) {

			String[] messageExitUserList = StringUtils.split(wmqServerChannel.getMessageExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_USER_DATA, messageExitUserList);
		}

		// Setting MQ ServerChannel ShortRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_SHORT_RETRY, wmqServerChannel.getShortRetryCount());

		// Setting MQ ServerChannel ShortRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_SHORT_TIMER, wmqServerChannel.getShortRetryInterval());

		// Setting MQ ServerChannel LongRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_LONG_RETRY, wmqServerChannel.getLongRetryCount());

		// Setting MQ ServerChannel LongRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_LONG_TIMER, wmqServerChannel.getLongRetryInterval());

		// Setting MQ ServerChannel Monitoring
		if (WmqChannelMonitoring.HIGH == wmqServerChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelMonitoring.LOW == wmqServerChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelMonitoring.MEDIUM == wmqServerChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelMonitoring.OFF == wmqServerChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ ServerChannel Statistics
		if (WmqChannelStatisticTypes.HIGH == wmqServerChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelStatisticTypes.LOW == wmqServerChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelStatisticTypes.MEDIUM == wmqServerChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelStatisticTypes.OFF == wmqServerChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ ServerChannel SSLCipherSpec
		if (wmqServerChannel.getSslCipherSpecification() != null) {

			pcfCmd.addParameter(MQConstants.MQCACH_SSL_CIPHER_SPEC, wmqServerChannel.getSslCipherSpecification().toString());
		}

		// Setting MQ ServerChannel Client authentication
		if (WmqSSLClientAuthentication.OPTIONAL == wmqServerChannel.getSslClientAuth()) {

			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_OPTIONAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_REQUIRED);
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating ServerChannel \"" + wmqServerChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating ServerChannel Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The ServerChannel \"" + wmqServerChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
