/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqServerConnectionChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqServerConnectionChannel} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqServerConnectionChannelStep extends BaseWmqStep {

	public WmqServerConnectionChannel wmqServerConnectionChannel;

	public CreateWmqServerConnectionChannelStep(WmqServerConnectionChannel wmqServerConnectionChannel, WmqQueueManager wmqQmanager)

	{

		this.wmqServerConnectionChannel = wmqServerConnectionChannel;
		this.wmqQmanager = wmqQmanager;
	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_CHANNEL;

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Setting ServerConnectionChannel ChannelName
		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, wmqServerConnectionChannel.getChannelName());

		// Setting ServerConnectionChannel ChannelType
		pcfCmd.addParameter(MQConstants.MQIACH_CHANNEL_TYPE, MQConstants.MQCHT_SVRCONN);

		// Setting ServerConnectionChannel Channel Description
		if (StringUtils.isNotBlank(wmqServerConnectionChannel.getDescription())) {

			pcfCmd.addParameter(MQConstants.MQCACH_DESC, wmqServerConnectionChannel.getDescription());
		}

		// Setting ServerConnectionChannel Channel Transport Type
		if (WmqTransmissionProtocolTypes.LU6 == wmqServerConnectionChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_LU62);

		} else if (WmqTransmissionProtocolTypes.NET_BIOS == wmqServerConnectionChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_NETBIOS);

		} else if (WmqTransmissionProtocolTypes.SPX == wmqServerConnectionChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_SPX);
		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_TCP);
		}

		// Setting ServerConnectionChannel Channel HeaderCompression value
		if (WmqHeaderCompression.SYSTEM == wmqServerConnectionChannel.getHeaderCompression()) {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_SYSTEM;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		} else {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_NONE;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		}

		// Setting ServerConnectionChannel HeartbeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_HB_INTERVAL, wmqServerConnectionChannel.getHeartBeatInterval());

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
			// Setting ServerConnectionChannel MaxInstances
			pcfCmd.addParameter(MQConstants.MQIACH_MAX_INSTANCES, wmqServerConnectionChannel.getMaximumInstances());

			// Setting ServerConnectionChannel MaxInstancesPerClient
			pcfCmd.addParameter(MQConstants.MQIACH_MAX_INSTS_PER_CLIENT, wmqServerConnectionChannel.getMaximumInstancesPerClient());

			// Setting ServerConnectionChannel SharingConversations
			pcfCmd.addParameter(MQConstants.MQIACH_SHARING_CONVERSATIONS, wmqServerConnectionChannel.getSharingConversations());
		}

		// Setting ServerConnectionChannel KeepaliveInterval
		if (wmqServerConnectionChannel.getKeepAliveInterval() > -1 && wmqServerConnectionChannel.getKeepAliveInterval() <= 99999) {
			pcfCmd.addParameter(MQConstants.MQIACH_KEEP_ALIVE_INTERVAL, wmqServerConnectionChannel.getKeepAliveInterval());
		}

		// Setting ServerConnectionChannel Channel MaximumMessageLength
		pcfCmd.addParameter(MQConstants.MQIACH_MAX_MSG_LENGTH, wmqServerConnectionChannel.getMaximumMessageLength());

		// Setting ServerConnectionChannel Channel MessageCompression Value
		int[] messageCompressionList = new int[1];
		if (WmqChannelMessageCompression.ANY == wmqServerConnectionChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ANY;

			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else if (WmqChannelMessageCompression.RLE == wmqServerConnectionChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_RLE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqChannelMessageCompression.ZLIBFAST == wmqServerConnectionChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBFAST;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqChannelMessageCompression.ZLIBHIGH == wmqServerConnectionChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBHIGH;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else {
			messageCompressionList[0] = MQConstants.MQCOMPRESS_NONE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		}

		// Setting ServerConnectionChannel Channel MCAUserID
		if (StringUtils.isNotBlank(wmqServerConnectionChannel.getMcaUserID())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MCA_USER_ID, wmqServerConnectionChannel.getMcaUserID());

		}

		// Setting ServerConnectionChannel Channel SendExitname
		if (StringUtils.isNotBlank(wmqServerConnectionChannel.getSendExit())) {

			String[] sendExitList = StringUtils.split(wmqServerConnectionChannel.getSendExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_NAME, sendExitList);

		}

		// Setting ServerConnectionChannel Channel SendUserData
		if (StringUtils.isNotBlank(wmqServerConnectionChannel.getSendExitUserData())) {

			String[] sendExitUserDataList = StringUtils.split(wmqServerConnectionChannel.getSendExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_USER_DATA, sendExitUserDataList);
		}

		// Setting ServerConnectionChannel Channel ReceiveExit
		if (StringUtils.isNotBlank(wmqServerConnectionChannel.getReceiveExit())) {

			String[] receiveExitList = StringUtils.split(wmqServerConnectionChannel.getReceiveExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_NAME, receiveExitList);
		}

		// Setting ServerConnectionChannel Channel ReceiveUserData
		if (StringUtils.isNotBlank(wmqServerConnectionChannel.getReceiveExitUserData())) {

			String[] receiveExitUserDataList = StringUtils.split(wmqServerConnectionChannel.getReceiveExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_USER_DATA, receiveExitUserDataList);
		}

		// Setting ServerConnectionChannel Channel SecurityExit
		if (StringUtils.isNotBlank(wmqServerConnectionChannel.getSecurityExit())) {
			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_NAME, wmqServerConnectionChannel.getSecurityExit());
		}

		// Setting ServerConnectionChannel Channel SecurityUserData
		if (StringUtils.isNotBlank(wmqServerConnectionChannel.getSecurityExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_USER_DATA, wmqServerConnectionChannel.getSecurityExitUserData());
		}

		// Setting ServerConnectionChannel Channel Monitoring
		if (WmqChannelMonitoring.HIGH == wmqServerConnectionChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelMonitoring.LOW == wmqServerConnectionChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelMonitoring.MEDIUM == wmqServerConnectionChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelMonitoring.OFF == wmqServerConnectionChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting ServerConnectionChannel Channel SSLCipherSpec
		if (wmqServerConnectionChannel.getSslCipherSpecification() != null) {

			pcfCmd.addParameter(MQConstants.MQCACH_SSL_CIPHER_SPEC, wmqServerConnectionChannel.getSslCipherSpecification().toString());
		}

		// Setting ServerConnectionChannel Channel Client authentication
		if (WmqSSLClientAuthentication.OPTIONAL == wmqServerConnectionChannel.getSslClientAuth()) {

			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_OPTIONAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_REQUIRED);
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating ServerConnectionChannel \"" + wmqServerConnectionChannel.getChannelName() + "\" on QueueManager \""
			        + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating ServerConnectionChannel Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The ServerConnectionChannel \"" + wmqServerConnectionChannel.getChannelName() + "\" is created on QueueManager \""
		        + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
