/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import static org.apache.commons.lang.StringUtils.join;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;

/**
 * Display the status of the CommandServer of a QueueManager {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class DisplayWmqCmdServerStatusStep implements Step {

	private WmqQueueManager wmqQueueManager;

	private boolean isDeployment = false;

	public DisplayWmqCmdServerStatusStep(WmqQueueManager wmqQueueManager) {
		this.wmqQueueManager = wmqQueueManager;
	}

	public DisplayWmqCmdServerStatusStep(WmqQueueManager wmqQueueManager, boolean isDeployment) {
		this.wmqQueueManager = wmqQueueManager;
		this.isDeployment = isDeployment;
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hostSession = wmqQueueManager.getHostName().getHostSession();

		try {
			CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
			List<String> cmd = new ArrayList<String>();
			cmd.add("dspmqcsv");
			cmd.add(wmqQueueManager.getQueueManagerName());
			String[] cmdArray = cmd.toArray(new String[cmd.size()]);
			int res = hostSession.execute(capturedOutput, cmdArray);
			if (res != 0) {
				if (isDeployment) {
					ctx.logOutput("Warning: Non-zero exitcode from " + join(cmdArray, " ") + ": " + res);
					ctx.logOutput("Warning: Check for Command server  running failed , Host might not support MQSC Commands");
					ctx.logOutput("Warning: Step returning as success as Deployment will succeed with PCF commands if Queue Manager , Command Server and Listeners are running ");

					return true;
				}
				ctx.logError("Non-zero exitcode from " + join(cmdArray, " ") + ": " + res);
				return false;
			}

			for (String eachLine : capturedOutput.getOutputLines()) {
				if (eachLine.startsWith("WebSphere")) {
					String[] matches = RegexUtils.regexMatch(eachLine, "[\\s\\S]*(Running)");
					if (matches == null || matches.length == 0) {
						ctx.logOutput("starting command server for \"" + wmqQueueManager.getQueueManagerName() + "\"");
						CapturingCommandExecutionCallbackHandler capturedOutput1 = new CapturingCommandExecutionCallbackHandler();
						res = hostSession.execute(capturedOutput1, "strmqcsv", wmqQueueManager.getQueueManagerName());
						if (res != 0) {
							ctx.logError("Non-zero exitcode while starting CommandServer from " + join(cmdArray, " ") + ": " + res);
							return false;
						}
					}

				}
			}
		} finally {
			hostSession.close();
		}
		ctx.logOutput("CommandServer on QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\" is Running");
		return true;
	}

	public String getDescription() {
		if (this.wmqQueueManager.getQueueManagerName() != null) {
			return "Displaying the CommandServer status of QueueManager\"" + this.wmqQueueManager.getQueueManagerName() + "\"";
		}
		return "CommandServer Status Step";
	}
}