/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener;
import com.xebialabs.deployit.plugin.wmq.enums.WmqListenerControl;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;

/**
 * Inqires the {@link WmqTCPListener} that exists on a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class InquireWmqTCPListenerStep extends BaseWmqStep {

	private WmqTCPListener wmqTCPListener;

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_INQUIRE_LISTENER;

	}

	public InquireWmqTCPListenerStep(WmqTCPListener wmqTCPListener, WmqQueueManager wmqQmanager) {

		this.wmqTCPListener = wmqTCPListener;
		this.wmqQmanager = wmqQmanager;
	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {

		pcfCmd.addParameter(MQConstants.MQCACH_LISTENER_NAME, wmqTCPListener.getListenerName());
		pcfCmd.addFilterParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQCFOP_EQUAL, MQConstants.MQXPT_TCP);
		int parameters[] = new int[1];
		parameters[0] = MQConstants.MQIACF_ALL;
		pcfCmd.addParameter(MQConstants.MQIACF_LISTENER_ATTRS, parameters);
	}

	@Override
	protected void readPCFMessageResponse(StepExecutionContext ctx, PCFMessage pcfMessage) {
		if (pcfMessage != null) {

			wmqTCPListener.setBacklog((Integer) pcfMessage.getParameterValue(MQConstants.MQIACH_BACKLOG));
			if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIACH_LISTENER_CONTROL) == MQConstants.MQSVC_CONTROL_MANUAL) {
				wmqTCPListener.setControl(WmqListenerControl.MANUAL);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIACH_LISTENER_CONTROL) == MQConstants.MQSVC_CONTROL_Q_MGR) {
				wmqTCPListener.setControl(WmqListenerControl.QUEUE_MANAGER);
			} else if ((Integer) pcfMessage.getParameterValue(MQConstants.MQIACH_LISTENER_CONTROL) == MQConstants.MQSVC_CONTROL_Q_MGR_START) {
				wmqTCPListener.setControl(WmqListenerControl.QUEUE_MANAGER_START);
			}
			wmqTCPListener.setIpAddress(((String) pcfMessage.getParameterValue(MQConstants.MQCACH_IP_ADDRESS)).trim());
			wmqTCPListener.setDescription(((String) pcfMessage.getParameterValue(MQConstants.MQCACH_LISTENER_DESC)).trim());
			wmqTCPListener.setPort((Integer) pcfMessage.getParameterValue(MQConstants.MQIACH_PORT));

			ctx.logOutput("Operation Successfull");
			ctx.logOutput("The Listener \"" + wmqTCPListener.getListenerName() + "\" is inquired successfully");
		} else {

			ctx.logOutput("Response is null");
		}

	}

	public String getDescription() {

		return "Inquiring the TCP Listener \"" + wmqTCPListener.getListenerName() + "\" for Queue Manager \"" + wmqQmanager.getQueueManagerName() + "\"";
	}

	@Override
	protected String getSuccessMessage() {

		return null;

	}

}
