/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqChannel;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.PCF_CommonMethods;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

/**
 * Stops the {@link WmqChannel}(WmqClusterSenderChannel,WmqRequesterChannel,WmqSenderChannel) on a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class StopWmqChannelStep extends BaseWmqStep {
	private WmqChannel channel;

	public StopWmqChannelStep(WmqChannel channel, WmqQueueManager wmqQmanager)

	{

		this.channel = channel;
		this.wmqQmanager = wmqQmanager;

	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_STOP_CHANNEL;

	}

	public boolean execute(StepExecutionContext ctx) {
		init();
		PCF_CommonMethods pcfCM = new PCF_CommonMethods();

		try {
			WmqHelper.createAgent(wmqQmanager, pcfCM, ctx);
			PCFMessage pcfCmd = new PCFMessage(mqCommand);
			setPCFMessageParameters(pcfCmd);
			PCFMessage pcfMessage = WmqHelper.sendPcfcmCommand(pcfCM, pcfCmd);
			readPCFMessageResponse(ctx, pcfMessage);
			pcfCM.destroyAgent();
		} catch (Exception e) {
			if (e.getClass().equals(PCFException.class)) {
				PCFException pcfe = (PCFException) e;

				if (pcfe.reasonCode == MQConstants.MQRCCF_COMMAND_FAILED || pcfe.reasonCode == MQConstants.MQRCCF_CHANNEL_NOT_ACTIVE
				        || pcfe.reasonCode == MQConstants.MQRCCF_MQPUT_FAILED) {
					ctx.logOutput("Warning: Command Failed to stop the channel but continue step with delete");
					return true;
				}
			}

			pcfCM.displayException(e, ctx);
			return false;
		}
		return true;
	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, channel.getChannelName());

	}

	public String getDescription() {

		return "Stopping the Channel \"" + channel.getChannelName() + "\" on QueueManager \"" + wmqQmanager.getQueueManagerName() + "\"";
	}

	@Override
	protected String getSuccessMessage() {

		return "The Channel  \"" + channel.getChannelName() + "\" stopped successfully on QueueManager \"" + wmqQmanager.getQueueManagerName() + "\"";

	}

}
