/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqRequesterChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPutAuthority;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqRequesterChannelStep
extends BaseWmqStep {
    public WmqRequesterChannel wmqRequesterChannel;
    private int[] messageCompressionList = new int[1];

    public CreateWmqRequesterChannelStep(WmqRequesterChannel wmqRequesterChannel, WmqQueueManager wmqQmanager) {
        this.wmqRequesterChannel = wmqRequesterChannel;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 23;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        int[] list;
        pcfCmd.addParameter(3501, this.wmqRequesterChannel.getChannelName());
        pcfCmd.addParameter(1511, 4);
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getDescription())) {
            pcfCmd.addParameter(3502, this.wmqRequesterChannel.getDescription());
        }
        if (WmqTransmissionProtocolTypes.LU6 == this.wmqRequesterChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 1);
        } else if (WmqTransmissionProtocolTypes.NET_BIOS == this.wmqRequesterChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 3);
        } else if (WmqTransmissionProtocolTypes.SPX == this.wmqRequesterChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 4);
        } else {
            pcfCmd.addParameter(1501, 2);
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getConnectionName())) {
            pcfCmd.addParameter(3506, this.wmqRequesterChannel.getConnectionName());
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getLocalCommunicationAddress())) {
            pcfCmd.addParameter(3520, this.wmqRequesterChannel.getLocalCommunicationAddress());
        }
        if (WmqHeaderCompression.SYSTEM == this.wmqRequesterChannel.getHeaderCompression()) {
            list = new int[]{8};
            pcfCmd.addParameter(1575, list);
        } else {
            list = new int[]{0};
            pcfCmd.addParameter(1575, list);
        }
        if (this.wmqRequesterChannel.getKeepAliveInterval() > -1 && this.wmqRequesterChannel.getKeepAliveInterval() <= 99999) {
            pcfCmd.addParameter(1566, this.wmqRequesterChannel.getKeepAliveInterval());
        }
        pcfCmd.addParameter(1563, this.wmqRequesterChannel.getHeartBeatInterval());
        pcfCmd.addParameter(1510, this.wmqRequesterChannel.getMaximumMessageLength());
        if (this.wmqRequesterChannel.getSequenceNumberWrap() < 100) {
            pcfCmd.addParameter(1509, 999999999);
        } else if (this.wmqRequesterChannel.getSequenceNumberWrap() != 0) {
            pcfCmd.addParameter(1509, this.wmqRequesterChannel.getSequenceNumberWrap());
        }
        if (WmqChannelMessageCompression.ANY == this.wmqRequesterChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 0xFFFFFFF;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else if (WmqChannelMessageCompression.RLE == this.wmqRequesterChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 1;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else if (WmqChannelMessageCompression.ZLIBFAST == this.wmqRequesterChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 2;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else if (WmqChannelMessageCompression.ZLIBHIGH == this.wmqRequesterChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 4;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else {
            this.messageCompressionList[0] = 0;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        }
        if (WmqNonpersistentMessageSpeed.NORMAL == this.wmqRequesterChannel.getNonPersistentMessageSpeed()) {
            pcfCmd.addParameter(1562, 1);
        } else {
            pcfCmd.addParameter(1562, 2);
        }
        pcfCmd.addParameter(1502, this.wmqRequesterChannel.getBatchSize());
        if (WmqChannelPutAuthority.CONTEXT == this.wmqRequesterChannel.getPutAuthority()) {
            pcfCmd.addParameter(1508, 2);
        } else {
            pcfCmd.addParameter(1508, 1);
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getMessageExitName())) {
            String[] messageExitList = StringUtils.split(this.wmqRequesterChannel.getMessageExitName(), ",");
            pcfCmd.addParameter(3509, messageExitList);
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getMessageExitUserData())) {
            String[] messageExitUserList = StringUtils.split(this.wmqRequesterChannel.getMessageExitUserData(), ",");
            pcfCmd.addParameter(3514, messageExitUserList);
        }
        pcfCmd.addParameter(1544, this.wmqRequesterChannel.getMessageRetryCount());
        pcfCmd.addParameter(1545, this.wmqRequesterChannel.getMessageRetryInterval());
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getMessageRetryExitname())) {
            pcfCmd.addParameter(3534, this.wmqRequesterChannel.getMessageRetryExitname());
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getMessageRetryExitUserData())) {
            pcfCmd.addParameter(3535, this.wmqRequesterChannel.getMessageRetryExitUserData());
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getMcaUserID())) {
            pcfCmd.addParameter(3527, this.wmqRequesterChannel.getMcaUserID());
        }
        if (WmqChannelMCAType.THREAD == this.wmqRequesterChannel.getMcaType()) {
            pcfCmd.addParameter(1517, 2);
        } else {
            pcfCmd.addParameter(1517, 1);
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getSendExit())) {
            String[] sendExitList = StringUtils.split(this.wmqRequesterChannel.getSendExit(), ",");
            pcfCmd.addParameter(3510, sendExitList);
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getSendExitUserData())) {
            String[] sendExitUserDataList = StringUtils.split(this.wmqRequesterChannel.getSendExitUserData(), ",");
            pcfCmd.addParameter(3515, sendExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getReceiveExit())) {
            String[] receiveExitList = StringUtils.split(this.wmqRequesterChannel.getReceiveExit(), ",");
            pcfCmd.addParameter(3511, receiveExitList);
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getReceiveExitUserData())) {
            String[] receiveExitUserDataList = StringUtils.split(this.wmqRequesterChannel.getReceiveExitUserData(), ",");
            pcfCmd.addParameter(3516, receiveExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getSecurityExit())) {
            pcfCmd.addParameter(3508, this.wmqRequesterChannel.getSecurityExit());
        }
        if (StringUtils.isNotBlank(this.wmqRequesterChannel.getSecurityExitUserData())) {
            pcfCmd.addParameter(3513, this.wmqRequesterChannel.getSecurityExitUserData());
        }
        if (WmqChannelMonitoring.HIGH == this.wmqRequesterChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 65);
        } else if (WmqChannelMonitoring.LOW == this.wmqRequesterChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 17);
        } else if (WmqChannelMonitoring.MEDIUM == this.wmqRequesterChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 33);
        } else if (WmqChannelMonitoring.OFF == this.wmqRequesterChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 0);
        } else {
            pcfCmd.addParameter(122, -3);
        }
        if (WmqChannelStatisticTypes.HIGH == this.wmqRequesterChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 65);
        } else if (WmqChannelStatisticTypes.LOW == this.wmqRequesterChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 17);
        } else if (WmqChannelStatisticTypes.MEDIUM == this.wmqRequesterChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 33);
        } else if (WmqChannelStatisticTypes.OFF == this.wmqRequesterChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 0);
        } else {
            pcfCmd.addParameter(129, -3);
        }
        if (this.wmqRequesterChannel.getSslCipherSpecification() != null) {
            pcfCmd.addParameter(3544, this.wmqRequesterChannel.getSslCipherSpecification().toString());
        }
        if (WmqSSLClientAuthentication.OPTIONAL == this.wmqRequesterChannel.getSslClientAuth()) {
            pcfCmd.addParameter(1568, 1);
        } else {
            pcfCmd.addParameter(1568, 0);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating RequesterChannel \"" + this.wmqRequesterChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating RequesterChannel Step";
    }

    protected String getSuccessMessage() {
        return "The RequesterChannel \"" + this.wmqRequesterChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

