/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;

public class WmqHelper {

	public static Map priorityMap = new HashMap();
	static {

		priorityMap.put(WMQConstants.SUB_ASPUBLISHED, MQConstants.MQPRI_PRIORITY_AS_Q_DEF);
		priorityMap.put(WMQConstants.SUB_AS_QUEUE_DEFINED, MQConstants.MQPRI_PRIORITY_AS_PUBLISHED);
		priorityMap.put(WMQConstants.WMQ_ZERO, 0);
		priorityMap.put(WMQConstants.WMQ_ONE, 1);
		priorityMap.put(WMQConstants.WMQ_TWO, 2);
		priorityMap.put(WMQConstants.WMQ_THREE, 3);
		priorityMap.put(WMQConstants.WMQ_FOUR, 4);
		priorityMap.put(WMQConstants.WMQ_FIVE, 5);
		priorityMap.put(WMQConstants.WMQ_SIX, 6);
		priorityMap.put(WMQConstants.WMQ_SEVEN, 7);
		priorityMap.put(WMQConstants.WMQ_EIGHT, 8);
		priorityMap.put(WMQConstants.WMQ_NINE, 9);

	}

	public static final void createAgent(WmqQueueManager wmqQManager, PCF_CommonMethods pcfCommonMethods, StepExecutionContext ctx) throws MQDataException {

		pcfCommonMethods.setQueueManager(wmqQManager.getQueueManagerName());
		if (wmqQManager.getHostName().getAddress() != null) {
			pcfCommonMethods.setHost(wmqQManager.getHostName().getAddress());
		}
		if (wmqQManager.getPortNumber() != 0) {
			pcfCommonMethods.setPort(wmqQManager.getPortNumber());
		}
		if (wmqQManager.getChannelName() != null) {
			pcfCommonMethods.setChannel(wmqQManager.getChannelName());
		}
		pcfCommonMethods.createAgent(4);
	}

	public static final PCFMessage sendPcfcmCommand(PCF_CommonMethods pcfCM, PCFMessage pcfCmd) throws PCFException, MQDataException, IOException {
		PCFMessage[] pcfResponse = sendPcfcmCommandToAgent(pcfCM, pcfCmd);
		PCFMessage pcfMessage = pcfResponse[0];
		return pcfMessage;
	}

	public static final PCFMessage[] sendPcfcmCommandToAgent(PCF_CommonMethods pcfCM, PCFMessage pcfCmd) throws PCFException, MQDataException, IOException {
		PCFMessage[] pcfResponse = pcfCM.agent.send(pcfCmd);
		return pcfResponse;
	}

	public static int getSubscriptionPriority(String priority) {

		int priorityValue = MQConstants.MQPRI_PRIORITY_AS_PUBLISHED;

		Integer priValue = (Integer) priorityMap.get(priority);
		if (priValue != null) {
			priorityValue = priValue.intValue();
		}

		return priorityValue;
	}

	public static String convertArrayToString(Object obj) {
		if (obj instanceof String) {
			return obj.toString().trim();
		}
		String[] arrayData = null;
		if (obj instanceof String[]) {
			arrayData = (String[]) obj;
		}

		String responseData = "";
		boolean firstTime = true;
		if (arrayData != null) {
			for (String string : arrayData) {
				if (firstTime) {
					responseData = string.trim();
				} else {
					responseData = responseData + "," + string.trim();
				}
				firstTime = false;
			}
		}
		return responseData;
	}

}
