/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterHeartbeatReceiver$;
import akka.cluster.ClusterHeartbeatSender;
import akka.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import akka.cluster.ClusterSettings;
import akka.cluster.CrossDcHeartbeatingState;
import akka.cluster.CrossDcHeartbeatingState$;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.UniqueAddress;
import akka.event.LoggingAdapter;
import akka.remote.FailureDetectorRegistry;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\ruc!\u00024h\u0001\u001d\\\u0007\"B>\u0001\t\u0003i\b\u0002\u00035\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0001\u0004%\t!!\u0004\t\u0013\u0005e\u0001\u00011A\u0005\u0002\u0005m\u0001\u0002CA\u0014\u0001\u0001\u0006K!a\u0004\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005-\u0002\u0002CA\u001d\u0001\u0001\u0006I!!\f\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005u\u0002\u0002CA*\u0001\u0001\u0006I!a\u0010\t\u0013\u0005U\u0003A1A\u0005\u0002\u0005]\u0003\u0002CA6\u0001\u0001\u0006I!!\u0017\t\u0013\u00055\u0004\u00011A\u0005\u0002\u0005=\u0004\"CA<\u0001\u0001\u0007I\u0011AA=\u0011!\ti\b\u0001Q!\n\u0005E\u0004bBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0005\n\u0003#\u0003\u0001\u0019!C\u0001\u0003'C\u0011\"a'\u0001\u0001\u0004%\t!!(\t\u0011\u0005\u0005\u0006\u0001)Q\u0005\u0003+C\u0011\"a)\u0001\u0005\u0004%\t!!*\t\u0011\u00055\u0006\u0001)A\u0005\u0003OCq!a,\u0001\t\u0003\n\t\fC\u0004\u00024\u0002!\t%!-\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAk\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003/\u0004A\u0011AAc\u0011\u001d\tI\u000e\u0001C\u0001\u0003\u000bDq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!9!Q\u0002\u0001\u0005\u0002\u0005E\u0006b\u0002B\b\u0001\u0011\u0005!\u0011\u0003\u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005KAqAa\n\u0001\t\u0013\t\tl\u0002\u0005\u00038\u001dD\t!\u001bB\u001d\r\u001d1w\r#\u0001j\u0005wAaa\u001f\u0015\u0005\u0002\tub!\u0003B QA\u0005\u0019\u0013\u0005B!\r\u0019\u0011I\u0005\u000b\"\u0003L!11p\u000bC\u0001\u00053B\u0011Ba\u0018,\u0003\u0003%\tA!\u0017\t\u0013\t\u00054&!A\u0005B\t\r\u0004\"\u0003B;W\u0005\u0005I\u0011\u0001B<\u0011%\u0011yhKA\u0001\n\u0003\u0011\t\tC\u0005\u0003\f.\n\t\u0011\"\u0011\u0003\u000e\"I!1T\u0016\u0002\u0002\u0013\u0005!Q\u0014\u0005\n\u0005C[\u0013\u0011!C!\u0005GC\u0011B!*,\u0003\u0003%\tEa*\t\u0013\t%6&!A\u0005B\t-v!\u0003BXQ\u0005\u0005\t\u0012\u0001BY\r%\u0011I\u0005KA\u0001\u0012\u0003\u0011\u0019\f\u0003\u0004|o\u0011\u0005!\u0011\u0019\u0005\n\u0005K;\u0014\u0011!C#\u0005OC\u0011Ba18\u0003\u0003%\tI!\u0017\t\u0013\t\u0015w'!A\u0005\u0002\n\u001d\u0007\"\u0003Bgo\u0005\u0005I\u0011\u0002Bh\r%\u00119\u000e\u000bI\u0001$C\u0011INB\u0005\u0003^\"\u0002\n1%\t\u0003`\u001a1!Q\u001d\u0015C\u0005OD!Ba;@\u0005+\u0007I\u0011AAJ\u0011)\u0011io\u0010B\tB\u0003%\u0011Q\u0013\u0005\u0007w~\"\tAa<\t\u0013\t}s(!A\u0005\u0002\tU\b\"\u0003B}\u007fE\u0005I\u0011\u0001B~\u0011%\u0011\tgPA\u0001\n\u0003\u0012\u0019\u0007C\u0005\u0003v}\n\t\u0011\"\u0001\u0003x!I!qP \u0002\u0002\u0013\u00051q\u0002\u0005\n\u0005\u0017{\u0014\u0011!C!\u0005\u001bC\u0011Ba'@\u0003\u0003%\taa\u0005\t\u0013\t\u0005v(!A\u0005B\t\r\u0006\"\u0003BS\u007f\u0005\u0005I\u0011\tBT\u0011%\u0011IkPA\u0001\n\u0003\u001a9bB\u0005\u00040!\n\t\u0011#\u0001\u00042\u0019I!Q\u001d\u0015\u0002\u0002#\u000511\u0007\u0005\u0007w:#\taa\u000f\t\u0013\t\u0015f*!A\u0005F\t\u001d\u0006\"\u0003Bb\u001d\u0006\u0005I\u0011QB\u001f\u0011%\u0011)MTA\u0001\n\u0003\u001b\t\u0005C\u0005\u0003N:\u000b\t\u0011\"\u0003\u0003P\u001a111\u0004\u0015C\u0007;Aaa\u001f+\u0005\u0002\r}\u0001\"\u0003B0)\u0006\u0005I\u0011AB\u0010\u0011%\u0011\t\u0007VA\u0001\n\u0003\u0012\u0019\u0007C\u0005\u0003vQ\u000b\t\u0011\"\u0001\u0003x!I!q\u0010+\u0002\u0002\u0013\u000511\u0005\u0005\n\u0005\u0017#\u0016\u0011!C!\u0005\u001bC\u0011Ba'U\u0003\u0003%\taa\n\t\u0013\t\u0005F+!A\u0005B\t\r\u0006\"\u0003BS)\u0006\u0005I\u0011\tBT\u0011%\u0011I\u000bVA\u0001\n\u0003\u001aYcB\u0005\u0004L!\n\t\u0011#\u0001\u0004N\u0019I11\u0004\u0015\u0002\u0002#\u00051q\n\u0005\u0007w\u0002$\taa\u0015\t\u0013\t\u0015\u0006-!A\u0005F\t\u001d\u0006\"\u0003BbA\u0006\u0005I\u0011QB\u0010\u0011%\u0011)\rYA\u0001\n\u0003\u001b)\u0006C\u0005\u0003N\u0002\f\t\u0011\"\u0003\u0003P\n12I]8tg\u0012\u001b\u0007*Z1si\n,\u0017\r^*f]\u0012,'O\u0003\u0002iS\u000691\r\\;ti\u0016\u0014(\"\u00016\u0002\t\u0005\\7.Y\n\u0005\u00011\u0014\b\u0010\u0005\u0002na6\taNC\u0001p\u0003\u0015\u00198-\u00197b\u0013\t\thN\u0001\u0004B]f\u0014VM\u001a\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k&\fQ!Y2u_JL!a\u001e;\u0003\u000b\u0005\u001bGo\u001c:\u0011\u0005ML\u0018B\u0001>u\u00051\t5\r^8s\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001@\u0011\u0005}\u0004Q\"A4\u0016\u0005\u0005\r\u0001cA@\u0002\u0006%\u0019\u0011qA4\u0003\u000f\rcWo\u001d;fe\u0006A1\r\\;ti\u0016\u0014\b%\u0001\twKJ\u0014wn]3IK\u0006\u0014HOY3biV\u0011\u0011q\u0002\t\u0004[\u0006E\u0011bAA\n]\n9!i\\8mK\u0006t\u0017!\u0005<fe\n|7/\u001a%fCJ$(-Z1uA\u0005\u0011\u0012m\u0019;jm\u0016d\u00170T8oSR|'/\u001b8h\u0003Y\t7\r^5wK2LXj\u001c8ji>\u0014\u0018N\\4`I\u0015\fH\u0003BA\u000f\u0003G\u00012!\\A\u0010\u0013\r\t\tC\u001c\u0002\u0005+:LG\u000fC\u0005\u0002&\u001d\t\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010J\u0019\u0002'\u0005\u001cG/\u001b<fYfluN\\5u_JLgn\u001a\u0011\u0002/%\u001cX\t\u001f;fe:\fGn\u00117vgR,'/T3nE\u0016\u0014XCAA\u0017!\u001di\u0017qFA\u001a\u0003\u001fI1!!\ro\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u0000\u0003kI1!a\u000eh\u0005\u0019iU-\u001c2fe\u0006A\u0012n]#yi\u0016\u0014h.\u00197DYV\u001cH/\u001a:NK6\u0014WM\u001d\u0011\u0002\u001f\r\u0014xn]:EGN+G\u000f^5oON,\"!a\u0010\u0011\t\u0005\u0005\u00131\n\b\u0005\u0003\u0007\n9ED\u0002\u0002F\ti\u0011\u0001A\u0005\u0005\u0003\u0013\n)!\u0001\u0005tKR$\u0018N\\4t\u0013\u0011\ti%a\u0014\u0003=\r\u0013xn]:EG\u001a\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u001cV\r\u001e;j]\u001e\u001c\u0018bAA)O\ny1\t\\;ti\u0016\u00148+\u001a;uS:<7/\u0001\tde>\u001c8\u000fR2TKR$\u0018N\\4tA\u000512M]8tg\u0012\u001bg)Y5mkJ,G)\u001a;fGR|'/\u0006\u0002\u0002ZA1\u00111LA1\u0003Kj!!!\u0018\u000b\u0007\u0005}\u0013.\u0001\u0004sK6|G/Z\u0005\u0005\u0003G\niFA\fGC&dWO]3EKR,7\r^8s%\u0016<\u0017n\u001d;ssB\u00191/a\u001a\n\u0007\u0005%DOA\u0004BI\u0012\u0014Xm]:\u0002/\r\u0014xn]:EG\u001a\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u0004\u0013AC:fcV,gnY3OeV\u0011\u0011\u0011\u000f\t\u0004[\u0006M\u0014bAA;]\n!Aj\u001c8h\u00039\u0019X-];f]\u000e,gJ]0%KF$B!!\b\u0002|!I\u0011Q\u0005\t\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\fg\u0016\fX/\u001a8dK:\u0013\b%A\u0007oKb$\b*Z1si\n+\u0017\r\u001e\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\f:\u0019q0a\"\n\u0007\u0005%u-\u0001\fDYV\u001cH/\u001a:IK\u0006\u0014HOY3biN+g\u000eZ3s\u0013\u0011\ti)a$\u0003\u0013!+\u0017M\u001d;cK\u0006$(bAAEO\u0006\u0001B-\u0019;b\u0007\u0016tG/\u001a:t'R\fG/Z\u000b\u0003\u0003+\u00032a`AL\u0013\r\tIj\u001a\u0002\u0019\u0007J|7o\u001d#d\u0011\u0016\f'\u000f\u001e2fCRLgnZ*uCR,\u0017\u0001\u00063bi\u0006\u001cUM\u001c;feN\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005}\u0005\"CA\u0013)\u0005\u0005\t\u0019AAK\u0003E!\u0017\r^1DK:$XM]:Ti\u0006$X\rI\u0001\u000eQ\u0016\f'\u000f\u001e2fCR$\u0016m]6\u0016\u0005\u0005\u001d\u0006cA:\u0002*&\u0019\u00111\u0016;\u0003\u0017\r\u000bgnY3mY\u0006\u0014G.Z\u0001\u000fQ\u0016\f'\u000f\u001e2fCR$\u0016m]6!\u0003!\u0001(/Z*uCJ$HCAA\u000f\u0003!\u0001xn\u001d;Ti>\u0004\u0018!\u00055fCJ$(-Z1u%\u0016\u001cW-\u001b<feR!\u0011\u0011XA`!\r\u0019\u00181X\u0005\u0004\u0003{#(AD!di>\u00148+\u001a7fGRLwN\u001c\u0005\b\u0003\u0003T\u0002\u0019AA3\u0003\u001d\tG\r\u001a:fgN\fqA]3dK&4X-\u0006\u0002\u0002HB!\u0011\u0011ZAh\u001d\r\u0019\u00181Z\u0005\u0004\u0003\u001b$\u0018!B!di>\u0014\u0018\u0002BAi\u0003'\u0014qAU3dK&4XMC\u0002\u0002NR\fq\u0001Z8s[\u0006tG/\u0001\u0004bGRLg/Z\u0001\u000eS:$(o\\:qK\u000e$\u0018N\\4\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0003;\ty\u000eC\u0004\u0002b~\u0001\r!a9\u0002\u0011Mt\u0017\r]:i_R\u0004B!!:\u0002z:!\u0011q]A{\u001d\u0011\tI/a=\u000f\t\u0005-\u0018\u0011_\u0007\u0003\u0003[T1!a<}\u0003\u0019a$o\\8u}%\t!.\u0003\u0002iS&\u0019\u0011q_4\u0002\u0019\rcWo\u001d;fe\u00163XM\u001c;\n\t\u0005m\u0018Q \u0002\u0014\u0007V\u0014(/\u001a8u\u00072,8\u000f^3s'R\fG/\u001a\u0006\u0004\u0003o<\u0017!C1eI6+WNY3s)\u0011\tiBa\u0001\t\u000f\t\u0015\u0001\u00051\u0001\u00024\u0005\tQ.\u0001\u0007sK6|g/Z'f[\n,'\u000f\u0006\u0003\u0002\u001e\t-\u0001b\u0002B\u0003C\u0001\u0007\u00111G\u0001\nQ\u0016\f'\u000f\u001e2fCR\fA\u0002[3beR\u0014W-\u0019;SgB$B!!\b\u0003\u0014!9!QC\u0012A\u0002\t]\u0011\u0001\u00024s_6\u00042a B\r\u0013\r\u0011Yb\u001a\u0002\u000e+:L\u0017/^3BI\u0012\u0014Xm]:\u0002+Q\u0014\u0018nZ4fe\u001aK'o\u001d;IK\u0006\u0014HOY3biR!\u0011Q\u0004B\u0011\u0011\u001d\u0011)\u0002\na\u0001\u0005/\tAe]3mM&\u001b(+Z:q_:\u001c\u0018N\u00197f\r>\u00148I]8tg\u0012\u001b\u0007*Z1si\n,\u0017\r\u001e\u000b\u0003\u0003\u001f\tQEY3d_6,\u0017i\u0019;jm\u0016LeMU3ta>t7/\u001b2mK\u001a{'\u000fS3beR\u0014W-\u0019;)\u0007\u0001\u0011Y\u0003\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\r\u0011\t$[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u001b\u0005_\u00111\"\u00138uKJt\u0017\r\\!qS\u000612I]8tg\u0012\u001b\u0007*Z1si\n,\u0017\r^*f]\u0012,'\u000f\u0005\u0002\u0000QM\u0011\u0001\u0006\u001c\u000b\u0003\u0005s\u0011\u0011#\u00138ta\u0016\u001cG/[8o\u0007>lW.\u00198e'\u0011QCNa\u0011\u0011\u0007M\u0014)%C\u0002\u0003HQ\u0014\u0011ET8TKJL\u0017\r\\5{CRLwN\u001c,fe&4\u0017nY1uS>tg*Z3eK\u0012\u0014ABU3q_J$8\u000b^1ukN\u001cba\u000b7\u0003N\tM\u0003cA7\u0003P%\u0019!\u0011\u000b8\u0003\u000fA\u0013x\u000eZ;diB\u0019QN!\u0016\n\u0007\t]cN\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\\A\u0019!QL\u0016\u000e\u0003!\nAaY8qs\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u001a\u0011\t\t\u001d$\u0011O\u0007\u0003\u0005SRAAa\u001b\u0003n\u0005!A.\u00198h\u0015\t\u0011y'\u0001\u0003kCZ\f\u0017\u0002\u0002B:\u0005S\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B=!\ri'1P\u0005\u0004\u0005{r'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BB\u0005\u0013\u00032!\u001cBC\u0013\r\u00119I\u001c\u0002\u0004\u0003:L\b\"CA\u0013a\u0005\u0005\t\u0019\u0001B=\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BH!\u0019\u0011\tJa&\u0003\u00046\u0011!1\u0013\u0006\u0004\u0005+s\u0017AC2pY2,7\r^5p]&!!\u0011\u0014BJ\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=!q\u0014\u0005\n\u0003K\u0011\u0014\u0011!a\u0001\u0005\u0007\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005s\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005K\na!Z9vC2\u001cH\u0003BA\b\u0005[C\u0011\"!\n6\u0003\u0003\u0005\rAa!\u0002\u0019I+\u0007o\u001c:u'R\fG/^:\u0011\u0007\tusgE\u00038\u0005k\u0013\u0019\u0006\u0005\u0004\u00038\nu&1L\u0007\u0003\u0005sS1Aa/o\u0003\u001d\u0011XO\u001c;j[\u0016LAAa0\u0003:\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u0019\u0015\u0005\tE\u0016!B1qa2L\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001f\u0011I\rC\u0005\u0003Ln\n\t\u00111\u0001\u0003\\\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005#\u0004BAa\u001a\u0003T&!!Q\u001bB5\u0005\u0019y%M[3di\na1\u000b^1ukN\u0014V\r]8siN!Q\b\u001cB\"S\tidHA\u000bN_:LGo\u001c:j]\u001e\u001cF/\u0019;f%\u0016\u0004xN\u001d;\u0014\tyb'\u0011\u001d\t\u0004\u0005;j\u0014f\u0001 @)\n\u0001Rj\u001c8ji>\u0014\u0018N\\4BGRLg/Z\n\t\u007f1\u0014IO!\u0014\u0003TA\u0019!Q\f \u0002\u000bM$\u0018\r^3\u0002\rM$\u0018\r^3!)\u0011\u0011\tPa=\u0011\u0007\tus\bC\u0004\u0003l\n\u0003\r!!&\u0015\t\tE(q\u001f\u0005\n\u0005W\u001c\u0005\u0013!a\u0001\u0003+\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003~*\"\u0011Q\u0013B\u0000W\t\u0019\t\u0001\u0005\u0003\u0004\u0004\r-QBAB\u0003\u0015\u0011\u00199a!\u0003\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0019]&!1QBB\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\u0005\u0005\u0007\u001b\t\u0002C\u0005\u0002&\u001d\u000b\t\u00111\u0001\u0003zQ!\u0011qBB\u000b\u0011%\t)#SA\u0001\u0002\u0004\u0011\u0019\t\u0006\u0003\u0002\u0010\re\u0001\"CA\u0013\u0019\u0006\u0005\t\u0019\u0001BB\u0005EiuN\\5u_JLgn\u001a#pe6\fg\u000e^\n\t)2\u0014IO!\u0014\u0003TQ\u00111\u0011\u0005\t\u0004\u0005;\"F\u0003\u0002BB\u0007KA\u0011\"!\nZ\u0003\u0003\u0005\rA!\u001f\u0015\t\u0005=1\u0011\u0006\u0005\n\u0003KY\u0016\u0011!a\u0001\u0005\u0007#B!a\u0004\u0004.!I\u0011Q\u00050\u0002\u0002\u0003\u0007!1Q\u0001\u0011\u001b>t\u0017\u000e^8sS:<\u0017i\u0019;jm\u0016\u00042A!\u0018O'\u0015q5Q\u0007B*!!\u00119la\u000e\u0002\u0016\nE\u0018\u0002BB\u001d\u0005s\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0019\t\u0004\u0006\u0003\u0003r\u000e}\u0002b\u0002Bv#\u0002\u0007\u0011Q\u0013\u000b\u0005\u0007\u0007\u001aI\u0005E\u0003n\u0007\u000b\n)*C\u0002\u0004H9\u0014aa\u00149uS>t\u0007\"\u0003Bf%\u0006\u0005\t\u0019\u0001By\u0003EiuN\\5u_JLgn\u001a#pe6\fg\u000e\u001e\t\u0004\u0005;\u00027#\u00021\u0004R\tM\u0003C\u0002B\\\u0005{\u001b\t\u0003\u0006\u0002\u0004NQ!\u0011qBB,\u0011%\u0011Y\rZA\u0001\u0002\u0004\u0019\t\u0003K\u0002)\u0005WA3a\nB\u0016\u0001")
@InternalApi
public class CrossDcHeartbeatSender
implements Actor,
ActorLogging {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private boolean activelyMonitoring;
    private final Function1<Member, Object> isExternalClusterMember;
    private final ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private long sequenceNr;
    private CrossDcHeartbeatingState dataCentersState;
    private final Cancellable heartbeatTask;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public boolean activelyMonitoring() {
        return this.activelyMonitoring;
    }

    public void activelyMonitoring_$eq(boolean x$1) {
        this.activelyMonitoring = x$1;
    }

    public Function1<Member, Object> isExternalClusterMember() {
        return this.isExternalClusterMember;
    }

    public ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings() {
        return this.crossDcSettings;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public long sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(long x$1) {
        this.sequenceNr = x$1;
    }

    public ClusterHeartbeatSender.Heartbeat nextHeartBeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1L);
        return new ClusterHeartbeatSender.Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public CrossDcHeartbeatingState dataCentersState() {
        return this.dataCentersState;
    }

    public void dataCentersState_$eq(CrossDcHeartbeatingState x$1) {
        this.dataCentersState = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public void preStart() {
        block0: {
            this.cluster().subscribe(this.self(), (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
            if (!this.verboseHeartbeat()) break block0;
            this.log().debug("Initialized cross-dc heartbeat sender as DORMANT in DC: [{}]", (Object)this.cluster().selfDataCenter());
        }
    }

    public void postStop() {
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)a -> {
            CrossDcHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.dormant().orElse(this.introspecting());
    }

    public PartialFunction<Object, BoxedUnit> dormant() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else {
                    object = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1) ? BoxedUnit.UNIT : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ClusterEvent.CurrentClusterState ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = (ClusterHeartbeatSender.HeartbeatRsp)A1;
                    UniqueAddress from = heartbeatRsp.from();
                    this.$outer.heartbeatRsp(from);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat) {
                    ClusterHeartbeatSender.ExpectedFirstHeartbeat expectedFirstHeartbeat = (ClusterHeartbeatSender.ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object) ? true : (object instanceof ClusterHeartbeatSender.HeartbeatRsp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberEvent ? true : object instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> introspecting() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ReportStatus) {
                    package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang((Object)(this.$outer.activelyMonitoring() ? new MonitoringActive(this.$outer.dataCentersState()) : new MonitoringDormant()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof ReportStatus;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet<Member> nodes2 = snapshot.members();
        int nrOfMonitoredNodes = this.crossDcSettings().NrOfMonitoringActors();
        this.dataCentersState_$eq(CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), nrOfMonitoredNodes, nodes2));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void addMember(Member m) {
        block2: {
            if (!CrossDcHeartbeatingState$.MODULE$.atLeastInUpState(m)) break block2;
            this.dataCentersState_$eq(this.dataCentersState().addMember(m));
            if (this.verboseHeartbeat()) {
                String string = m.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.log().debug("Register member {} for cross DC heartbeat (will only heartbeat if oldest)", (Object)m);
                }
            }
            this.becomeActiveIfResponsibleForHeartbeat();
        }
    }

    public void removeMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.context().stop(this.self());
        } else {
            this.dataCentersState_$eq(this.dataCentersState().removeMember(m));
            this.becomeActiveIfResponsibleForHeartbeat();
        }
    }

    public void heartbeat() {
        ClusterHeartbeatSender.Heartbeat nextHB = this.nextHeartBeat();
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)to -> {
            CrossDcHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
    }

    public void heartbeatRsp(UniqueAddress from) {
        if (this.verboseHeartbeat()) {
            this.cluster().ClusterLogger().logDebug("(Cross) Heartbeat response from [{}]", from.address());
        }
        this.dataCentersState_$eq(this.dataCentersState().heartbeatRsp(from));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        block1: {
            if (!this.dataCentersState().activeReceivers().contains((Object)from) || this.crossDcFailureDetector().isMonitoring((Object)from.address())) break block1;
            if (this.verboseHeartbeat()) {
                this.cluster().ClusterLogger().logDebug("Trigger extra expected (cross) heartbeat from [{}]", from.address());
            }
            this.crossDcFailureDetector().heartbeat((Object)from.address());
        }
    }

    private boolean selfIsResponsibleForCrossDcHeartbeat() {
        int activeDcs = this.dataCentersState().dataCenters().size();
        return activeDcs > 1 ? this.dataCentersState().shouldActivelyMonitorNodes(this.cluster().selfDataCenter(), this.cluster().selfUniqueAddress()) : false;
    }

    private void becomeActiveIfResponsibleForHeartbeat() {
        block1: {
            block0: {
                if (this.activelyMonitoring() || !this.selfIsResponsibleForCrossDcHeartbeat()) break block0;
                this.log().info("Cross DC heartbeat becoming ACTIVE on this node (for DC: {}), monitoring other DCs oldest nodes", (Object)this.cluster().selfDataCenter());
                this.activelyMonitoring_$eq(true);
                this.context().become(this.active().orElse(this.introspecting()));
                break block1;
            }
            if (this.activelyMonitoring() || !this.verboseHeartbeat()) break block1;
            this.log().info("Remaining DORMANT; others in {} handle heartbeating other DCs", (Object)this.cluster().selfDataCenter());
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExternalClusterMember$1(CrossDcHeartbeatSender $this, Member member) {
        String string = member.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(CrossDcHeartbeatSender $this, UniqueAddress a) {
        $this.crossDcFailureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(CrossDcHeartbeatSender $this, ClusterHeartbeatSender.Heartbeat nextHB$1, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.crossDcFailureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("(Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.cluster().ClusterLogger().logDebug("First (Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ClusterHeartbeatSender.ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)nextHB$1, $this.self());
    }

    public CrossDcHeartbeatSender() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.activelyMonitoring = false;
        this.isExternalClusterMember = (Function1 & Serializable & scala.Serializable)member -> BoxesRunTime.boxToBoolean((boolean)CrossDcHeartbeatSender.$anonfun$isExternalClusterMember$1(this, member));
        this.crossDcSettings = this.cluster().settings().MultiDataCenter().CrossDcFailureDetectorSettings();
        this.crossDcFailureDetector = this.cluster().crossDcFailureDetector();
        this.sequenceNr = 0L;
        this.dataCentersState = CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), this.crossDcSettings().NrOfMonitoringActors(), (SortedSet<Member>)SortedSet$.MODULE$.empty(Member$.MODULE$.ordering()));
        this.heartbeatTask = this.cluster().scheduler().schedule(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
    }

    public static interface InspectionCommand
    extends NoSerializationVerificationNeeded {
    }

    public static final class MonitoringActive
    implements MonitoringStateReport,
    Product,
    scala.Serializable {
        private final CrossDcHeartbeatingState state;

        public CrossDcHeartbeatingState state() {
            return this.state;
        }

        public MonitoringActive copy(CrossDcHeartbeatingState state) {
            return new MonitoringActive(state);
        }

        public CrossDcHeartbeatingState copy$default$1() {
            return this.state();
        }

        public String productPrefix() {
            return "MonitoringActive";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.state();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringActive;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MonitoringActive)) return false;
            boolean bl = true;
            if (!bl) return false;
            MonitoringActive monitoringActive = (MonitoringActive)x$1;
            CrossDcHeartbeatingState crossDcHeartbeatingState = this.state();
            CrossDcHeartbeatingState crossDcHeartbeatingState2 = monitoringActive.state();
            if (crossDcHeartbeatingState != null) {
                if (!((Object)crossDcHeartbeatingState).equals(crossDcHeartbeatingState2)) return false;
                return true;
            }
            if (crossDcHeartbeatingState2 == null) return true;
            return false;
        }

        public MonitoringActive(CrossDcHeartbeatingState state) {
            this.state = state;
            Product.$init$((Product)this);
        }
    }

    public static final class MonitoringDormant
    implements MonitoringStateReport,
    Product,
    scala.Serializable {
        public MonitoringDormant copy() {
            return new MonitoringDormant();
        }

        public String productPrefix() {
            return "MonitoringDormant";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringDormant;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof MonitoringDormant;
            return bl;
        }

        public MonitoringDormant() {
            Product.$init$((Product)this);
        }
    }

    public static interface MonitoringStateReport
    extends StatusReport {
    }

    public static final class ReportStatus
    implements Product,
    scala.Serializable {
        public ReportStatus copy() {
            return new ReportStatus();
        }

        public String productPrefix() {
            return "ReportStatus";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReportStatus;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof ReportStatus;
            return bl;
        }

        public ReportStatus() {
            Product.$init$((Product)this);
        }
    }

    public static interface StatusReport
    extends NoSerializationVerificationNeeded {
    }
}

