/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;

public class ActiveMQJMSClientBundle_$bundle
implements ActiveMQJMSClientBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQJMSClientBundle_$bundle INSTANCE = new ActiveMQJMSClientBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ActiveMQJMSClientBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidFilter$str() {
        return "AMQ139000: Invalid filter: {0}";
    }

    @Override
    public final ActiveMQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        ActiveMQInvalidFilterExpressionException result = new ActiveMQInvalidFilterExpressionException(this._formatMessage(this.invalidFilter$str(), filter));
        result.initCause(e);
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidSubscriptionName$str() {
        return "AMQ139001: Invalid Subscription Name. It is required to set the subscription name";
    }

    @Override
    public final ActiveMQIllegalStateException invalidSubscriptionName() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.invalidSubscriptionName$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String destinationDoesNotExist$str() {
        return "AMQ139002: Destination {0} does not exist";
    }

    @Override
    public final ActiveMQNonExistentQueueException destinationDoesNotExist(SimpleString destination) {
        ActiveMQNonExistentQueueException result = new ActiveMQNonExistentQueueException(this._formatMessage(this.destinationDoesNotExist$str(), destination));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nameCannotBeNull$str() {
        return "AMQ139003: name cannot be null";
    }

    @Override
    public final IllegalArgumentException nameCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nameCannotBeNull$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nameCannotBeEmpty$str() {
        return "AMQ139004: name cannot be empty";
    }

    @Override
    public final IllegalArgumentException nameCannotBeEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nameCannotBeEmpty$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String callingMethodFromListenerRuntime$str() {
        return "AMQ139005: It is illegal to call this method from within a Message Listener";
    }

    @Override
    public final IllegalStateRuntimeException callingMethodFromListenerRuntime() {
        IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(this.getLoggingLocale(), this.callingMethodFromListenerRuntime$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String callingMethodFromListener$str() {
        return "AMQ139006: It is illegal to call this method from within a Message Listener";
    }

    @Override
    public final IllegalStateException callingMethodFromListener() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.callingMethodFromListener$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String callingMethodFromCompletionListenerRuntime$str() {
        return "AMQ139007: It is illegal to call this method from within a Completion Listener";
    }

    @Override
    public final IllegalStateRuntimeException callingMethodFromCompletionListenerRuntime() {
        IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(this.getLoggingLocale(), this.callingMethodFromCompletionListenerRuntime$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String callingMethodFromCompletionListener$str() {
        return "AMQ139008: It is illegal to call this method from within a Completion Listener";
    }

    @Override
    public final IllegalStateException callingMethodFromCompletionListener() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.callingMethodFromCompletionListener$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullArgumentNotAllowed$str() {
        return "AMQ139009: Null {0} is not allowed";
    }

    @Override
    public final IllegalArgumentException nullArgumentNotAllowed(String type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.nullArgumentNotAllowed$str(), type));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullTopic$str() {
        return "AMQ139010: Topic (Destination) cannot be null";
    }

    @Override
    public final InvalidDestinationException nullTopic() {
        InvalidDestinationException result = new InvalidDestinationException(String.format(this.getLoggingLocale(), this.nullTopic$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String onlyValidForByteOrStreamMessages$str() {
        return "AMQ139011: LargeMessage streaming is only possible on ByteMessage or StreamMessage";
    }

    @Override
    public final IllegalStateException onlyValidForByteOrStreamMessages() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.onlyValidForByteOrStreamMessages$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidJavaIdentifier$str() {
        return "AMQ139012: The property name ''{0}'' is not a valid java identifier.";
    }

    @Override
    public final JMSRuntimeException invalidJavaIdentifier(String propertyName) {
        JMSRuntimeException result = new JMSRuntimeException(this._formatMessage(this.invalidJavaIdentifier$str(), propertyName));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String messageNotWritable$str() {
        return "AMQ139013: Message is read-only";
    }

    @Override
    public final MessageNotWriteableException messageNotWritable() {
        MessageNotWriteableException result = new MessageNotWriteableException(String.format(this.getLoggingLocale(), this.messageNotWritable$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String messageNotReadable$str() {
        return "AMQ139014: Message is write-only";
    }

    @Override
    public final MessageNotReadableException messageNotReadable() {
        MessageNotReadableException result = new MessageNotReadableException(String.format(this.getLoggingLocale(), this.messageNotReadable$str(), new Object[0]));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalDeliveryMode$str() {
        return "AMQ139015: Illegal deliveryMode value: {0}";
    }

    @Override
    public final JMSException illegalDeliveryMode(int deliveryMode) {
        JMSException result = new JMSException(this._formatMessage(this.illegalDeliveryMode$str(), deliveryMode));
        ActiveMQJMSClientBundle_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

