/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PatternMatcher {
    private static final Logger logger = LoggerFactory.getLogger(PatternMatcher.class);
    private final Set _acceptedNames = new HashSet();
    private final Set _acceptedPatterns = new HashSet();

    PatternMatcher() {
    }

    public void addPattern(String patternName) {
        logger.debug("addPattern(patternName={}) - start", (Object)patternName);
        if (patternName.indexOf("*") != -1 || patternName.indexOf("?") != -1) {
            this._acceptedPatterns.add(patternName);
        } else {
            this._acceptedNames.add(patternName.toUpperCase());
        }
    }

    public boolean isEmpty() {
        logger.debug("isEmpty() - start");
        return this._acceptedNames.isEmpty() && this._acceptedPatterns.isEmpty();
    }

    public boolean accept(String name) {
        logger.debug("accept(name={}) - start", (Object)name);
        if (this._acceptedNames.contains(name.toUpperCase())) {
            return true;
        }
        if (this._acceptedPatterns.size() > 0) {
            for (String pattern : this._acceptedPatterns) {
                if (!this.match(pattern, name, false)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean match(String pattern, String str, boolean isCaseSensitive) {
        if (PatternMatcher.logger.isDebugEnabled()) {
            PatternMatcher.logger.debug("match(pattern={}, str={}, isCaseSensitive={}) - start", new Object[]{pattern, str, String.valueOf(isCaseSensitive)});
        }
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (ch != '?') {
                    if (isCaseSensitive && ch != strArr[i]) {
                        return false;
                    }
                    if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[i])) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl40
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxStart]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
lbl40:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl41:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl56
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
lbl56:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl57:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl97
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block31: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (ch == '?' || (!isCaseSensitive || ch == strArr[strIdxStart + i + j]) && (isCaseSensitive || Character.toUpperCase(ch) == Character.toUpperCase(strArr[strIdxStart + i + j]))) {
                            ++j;
                            continue;
                        }
                        break block31;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl97:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl98:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_acceptedNames=").append(this._acceptedNames);
        sb.append(", _acceptedPatterns=").append(this._acceptedPatterns);
        sb.append("]");
        return sb.toString();
    }
}

