/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyHelper;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.w3c.dom.Node;

public class Configurator {
    protected static final Log log = LogFactory.getLog(Configurator.class);
    protected final ProtocolStack stack;

    public Configurator() {
        this.stack = null;
    }

    public Configurator(ProtocolStack protocolStack) {
        this.stack = protocolStack;
    }

    public Protocol setupProtocolStack(List<ProtocolConfiguration> config) throws Exception {
        return Configurator.setupProtocolStack(config, this.stack);
    }

    public Protocol setupProtocolStack(ProtocolStack copySource) throws Exception {
        List<Protocol> protocols = copySource.copyProtocols(this.stack);
        Collections.reverse(protocols);
        return Configurator.connectProtocols(protocols);
    }

    public static Protocol setupProtocolStack(List<ProtocolConfiguration> protocol_configs, ProtocolStack st) throws Exception {
        List<Protocol> protocols = Configurator.createProtocolsAndInitializeAttrs(protocol_configs, st);
        Protocol top_protocol = protocols.get(protocols.size() - 1);
        top_protocol.setUpProtocol(st);
        return Configurator.connectProtocols(protocols);
    }

    public static Protocol createProtocol(String prot_spec, ProtocolStack stack) throws Exception {
        return Configurator.createProtocol(prot_spec, stack, true);
    }

    public static Protocol createProtocol(String prot_spec, ProtocolStack stack, boolean init_attrs) throws Exception {
        if (prot_spec == null) {
            throw new Exception("Configurator.createProtocol(): prot_spec is null");
        }
        ProtocolConfiguration config = new ProtocolConfiguration(prot_spec);
        Protocol prot = Configurator.createLayer(stack, config);
        if (init_attrs) {
            Configurator.initializeAttrs(prot, config, Util.getIpStackType());
        }
        prot.init();
        return prot;
    }

    public static List<Protocol> createProtocolsAndInitializeAttrs(List<ProtocolConfiguration> cfgs, ProtocolStack st) throws Exception {
        List<Protocol> protocols = Configurator.createProtocols(cfgs, st);
        if (protocols == null) {
            return null;
        }
        StackType ip_version = Util.getIpStackType();
        Protocol transport = protocols.get(0);
        if (transport instanceof TP) {
            ProtocolConfiguration cfg = cfgs.get(0);
            Field bind_addr_field = Util.getField(transport.getClass(), "bind_addr");
            Configurator.resolveAndAssignField(transport, bind_addr_field, cfg.getProperties(), ip_version);
            InetAddress resolved_addr = (InetAddress)Util.getField(bind_addr_field, transport);
            if (resolved_addr != null) {
                ip_version = resolved_addr instanceof Inet6Address ? StackType.IPv6 : StackType.IPv4;
            } else if (ip_version == StackType.Dual) {
                ip_version = StackType.IPv4;
            }
        }
        for (int i = 0; i < cfgs.size(); ++i) {
            ProtocolConfiguration config = cfgs.get(i);
            Protocol prot = protocols.get(i);
            Configurator.initializeAttrs(prot, config, ip_version);
        }
        Configurator.setDefaultValues(cfgs, protocols, ip_version);
        Configurator.ensureValidBindAddresses(protocols);
        return protocols;
    }

    public static Protocol connectProtocols(List<Protocol> protocol_list) throws Exception {
        Protocol current_layer = null;
        Protocol next_layer = null;
        for (int i = 0; i < protocol_list.size(); ++i) {
            current_layer = protocol_list.get(i);
            if (i + 1 >= protocol_list.size()) break;
            next_layer = protocol_list.get(i + 1);
            next_layer.setDownProtocol(current_layer);
            current_layer.setUpProtocol(next_layer);
        }
        Configurator.sanityCheck(protocol_list);
        return current_layer;
    }

    public static List<Protocol> createProtocols(List<ProtocolConfiguration> protocol_configs, ProtocolStack stack) throws Exception {
        LinkedList<Protocol> retval = new LinkedList<Protocol>();
        for (int i = 0; i < protocol_configs.size(); ++i) {
            ProtocolConfiguration protocol_config = protocol_configs.get(i);
            Protocol layer = Configurator.createLayer(stack, protocol_config);
            if (layer == null) {
                return null;
            }
            retval.add(layer);
        }
        return retval;
    }

    protected static Protocol createLayer(ProtocolStack stack, ProtocolConfiguration config) throws Exception {
        String protocol_name = config.getProtocolName();
        if (protocol_name == null) {
            return null;
        }
        Class<? extends Protocol> clazz = Util.loadProtocolClass(protocol_name, stack != null ? stack.getClass() : null);
        try {
            Protocol retval = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (stack != null) {
                retval.setProtocolStack(stack);
            }
            return retval;
        }
        catch (InstantiationException inst_ex) {
            throw new InstantiationException(String.format(Util.getMessage("ProtocolCreateError"), protocol_name, inst_ex.getLocalizedMessage()));
        }
    }

    public static void initializeAttrs(Protocol prot, ProtocolConfiguration config, StackType ip_version) throws Exception {
        AccessibleObject[] dependencyOrderedFieldsAndMethods;
        String protocol_name = config.getProtocolName();
        if (protocol_name == null) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>(config.getProperties());
        for (AccessibleObject ordered : dependencyOrderedFieldsAndMethods = Configurator.computePropertyDependencies(prot, properties)) {
            if (ordered instanceof Field) {
                Configurator.resolveAndAssignField(prot, (Field)ordered, properties, ip_version);
                continue;
            }
            if (!(ordered instanceof Method)) continue;
            Configurator.resolveAndInvokePropertyMethod(prot, (Method)ordered, properties, ip_version);
        }
        List<Object> additional_objects = prot.getConfigurableObjects();
        if (additional_objects != null && !additional_objects.isEmpty()) {
            for (Object obj : additional_objects) {
                Configurator.resolveAndAssignFields(obj, properties, ip_version);
                Configurator.resolveAndInvokePropertyMethods(obj, properties, ip_version);
            }
        }
        if (!properties.isEmpty()) {
            throw new IllegalArgumentException(String.format(Util.getMessage("ConfigurationError"), protocol_name, properties));
        }
        List<Node> subtrees = config.getSubtrees();
        if (subtrees != null) {
            for (Node node : subtrees) {
                prot.parse(node);
            }
        }
    }

    public static void sanityCheck(List<Protocol> protocols) throws Exception {
        HashSet<Short> ids = new HashSet<Short>();
        for (Protocol protocol : protocols) {
            short id = protocol.getId();
            String name = protocol.getName();
            if (id <= 0 || ids.add(id)) continue;
            throw new Exception("Protocol ID " + id + " (name=" + name + ") is duplicate; IDs have to be unique");
        }
        for (Protocol protocol : protocols) {
            ArrayList<Integer> tmp;
            List<Integer> required_down_services = protocol.requiredDownServices();
            List<Integer> required_up_services = protocol.requiredUpServices();
            if (required_down_services != null && !required_down_services.isEmpty()) {
                tmp = new ArrayList<Integer>(required_down_services);
                Configurator.removeProvidedUpServices(protocol, tmp);
                if (!tmp.isEmpty()) {
                    throw new Exception("events " + Configurator.printEvents(tmp) + " are required by " + protocol.getName() + ", but not provided by any of the protocols below it");
                }
            }
            if (required_up_services == null || required_up_services.isEmpty()) continue;
            tmp = new ArrayList<Integer>(required_up_services);
            Configurator.removeProvidedDownServices(protocol, tmp);
            if (tmp.isEmpty()) continue;
            throw new Exception("events " + Configurator.printEvents(tmp) + " are required by " + protocol.getName() + ", but not provided by any of the protocols above it");
        }
    }

    protected static String printEvents(List<Integer> events) {
        return events.stream().map(Event::type2String).collect(Collectors.joining(" ", "[", "]"));
    }

    protected static void removeProvidedUpServices(Protocol protocol, List<Integer> events) {
        if (protocol == null || events == null) {
            return;
        }
        for (Object prot = protocol.getDownProtocol(); prot != null && !events.isEmpty(); prot = ((Protocol)prot).getDownProtocol()) {
            List<Integer> provided_up_services = ((Protocol)prot).providedUpServices();
            if (provided_up_services == null || provided_up_services.isEmpty()) continue;
            events.removeAll(provided_up_services);
        }
    }

    protected static void removeProvidedDownServices(Protocol protocol, List<Integer> events) {
        if (protocol == null || events == null) {
            return;
        }
        for (Object prot = protocol.getUpProtocol(); prot != null && !events.isEmpty(); prot = ((Protocol)prot).getUpProtocol()) {
            List<Integer> provided_down_services = ((Protocol)prot).providedDownServices();
            if (provided_down_services == null || provided_down_services.isEmpty()) continue;
            events.removeAll(provided_down_services);
        }
    }

    public static Collection<InetAddress> getAddresses(Map<String, Map<String, InetAddressInfo>> map) throws Exception {
        return map.values().stream().flatMap(m -> m.values().stream()).flatMap(i -> i.getInetAddresses().stream()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Map<String, Map<String, InetAddressInfo>> createInetAddressMap(List<ProtocolConfiguration> protocol_configs, List<Protocol> protocols) throws Exception {
        HashMap<String, Map<String, InetAddressInfo>> inetAddressMap = new HashMap<String, Map<String, InetAddressInfo>>();
        for (int i = 0; i < protocol_configs.size(); ++i) {
            ProtocolConfiguration protocol_config = protocol_configs.get(i);
            Protocol protocol = protocols.get(i);
            String protocolName = protocol.getName();
            HashMap<String, String> properties = new HashMap<String, String>(protocol_config.getProperties());
            Method[] methods = Util.getAllDeclaredMethodsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < methods.length; ++j) {
                if (!Configurator.isSetPropertyMethod(methods[j], protocol.getClass())) continue;
                String propertyName = PropertyHelper.getPropertyName(methods[j]);
                String propertyValue = (String)properties.get(propertyName);
                String tmp = Configurator.grabSystemProp(methods[j].getAnnotation(Property.class));
                if (tmp != null) {
                    propertyValue = tmp;
                }
                if (propertyValue == null || !InetAddressInfo.isInetAddressRelated(methods[j])) continue;
                Object converted = null;
                try {
                    converted = PropertyHelper.getConvertedValue((Object)protocol, methods[j], properties, propertyValue, false, Util.getIpStackType());
                }
                catch (Exception e) {
                    throw new Exception("string could not be converted for method " + propertyName + " in " + protocolName + " with default value " + propertyValue + ".Exception is " + e, e);
                }
                InetAddressInfo inetinfo = new InetAddressInfo(protocol, methods[j], properties, propertyValue, converted);
                Map m = inetAddressMap.computeIfAbsent(protocolName, k -> new HashMap());
                m.put(propertyName, inetinfo);
            }
            Field[] fields = Util.getAllDeclaredFieldsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < fields.length; ++j) {
                String propertyName = PropertyHelper.getPropertyName(fields[j], properties);
                String propertyValue = (String)properties.get(propertyName);
                String tmp = Configurator.grabSystemProp(fields[j].getAnnotation(Property.class));
                if (tmp != null) {
                    propertyValue = tmp;
                }
                if (propertyValue == null && PropertyHelper.usesDefaultConverter(fields[j]) || !InetAddressInfo.isInetAddressRelated(fields[j])) continue;
                Object converted = null;
                try {
                    converted = PropertyHelper.getConvertedValue((Object)protocol, fields[j], properties, propertyValue, false, Util.getIpStackType());
                }
                catch (Exception e) {
                    throw new Exception("string could not be converted for method " + propertyName + " in " + protocolName + " with default value " + propertyValue + ".Exception is " + e, e);
                }
                InetAddressInfo inetinfo = new InetAddressInfo(protocol, fields[j], properties, propertyValue, converted);
                Map m = inetAddressMap.computeIfAbsent(protocolName, k -> new HashMap());
                m.put(propertyName, inetinfo);
            }
        }
        return inetAddressMap;
    }

    public static List<InetAddress> getInetAddresses(List<Protocol> protocols) throws Exception {
        LinkedList<InetAddress> retval = new LinkedList<InetAddress>();
        for (Protocol protocol : protocols) {
            for (Class<?> clazz = protocol.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                for (int j = 0; j < fields.length; ++j) {
                    if (!fields[j].isAnnotationPresent(Property.class) || !InetAddressInfo.isInetAddressRelated(fields[j])) continue;
                    Object value = Configurator.getValueFromProtocol(protocol, fields[j]);
                    if (value instanceof InetAddress) {
                        retval.add((InetAddress)value);
                        continue;
                    }
                    if (value instanceof IpAddress) {
                        retval.add(((IpAddress)value).getIpAddress());
                        continue;
                    }
                    if (!(value instanceof InetSocketAddress)) continue;
                    retval.add(((InetSocketAddress)value).getAddress());
                }
            }
        }
        return retval;
    }

    public static void setDefaultValues(List<ProtocolConfiguration> protocol_configs, List<Protocol> protocols, StackType ip_version) throws Exception {
        InetAddress default_ip_address = Util.getNonLoopbackAddress(ip_version);
        if (default_ip_address == null) {
            log.warn(Util.getMessage("OnlyLoopbackFound"), new Object[]{ip_version});
            default_ip_address = Util.getLoopback(ip_version);
        }
        for (int i = 0; i < protocol_configs.size(); ++i) {
            ProtocolConfiguration protocol_config = protocol_configs.get(i);
            Protocol protocol = protocols.get(i);
            String protocolName = protocol.getName();
            HashMap<String, String> properties = new HashMap<String, String>(protocol_config.getProperties());
            Method[] methods = Util.getAllDeclaredMethodsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < methods.length; ++j) {
                String defaultValue;
                String propertyName;
                Object propertyValue;
                if (!Configurator.isSetPropertyMethod(methods[j], protocol.getClass()) || (propertyValue = Configurator.getValueFromProtocol(protocol, propertyName = PropertyHelper.getPropertyName(methods[j]))) != null) continue;
                Property annotation = methods[j].getAnnotation(Property.class);
                if (!InetAddressInfo.isInetAddressRelated(methods[j])) continue;
                String string = defaultValue = ip_version == StackType.IPv4 ? annotation.defaultValueIPv4() : annotation.defaultValueIPv6();
                if (defaultValue == null || defaultValue.isEmpty()) continue;
                Object converted = null;
                try {
                    converted = defaultValue.equalsIgnoreCase("NON_LOOPBACK_ADDRESS") ? default_ip_address : PropertyHelper.getConvertedValue((Object)protocol, methods[j], properties, defaultValue, true, ip_version);
                    methods[j].invoke((Object)protocol, converted);
                }
                catch (Exception e) {
                    throw new Exception("default could not be assigned for method " + propertyName + " in " + protocolName + " with default " + defaultValue, e);
                }
                log.debug("set property %s.%s to default value %s", protocolName, propertyName, converted);
            }
            Field[] fields = Util.getAllDeclaredFieldsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < fields.length; ++j) {
                String defaultValue;
                String propertyName = PropertyHelper.getPropertyName(fields[j], properties);
                Object propertyValue = Configurator.getValueFromProtocol(protocol, fields[j]);
                if (propertyValue != null) continue;
                Property annotation = fields[j].getAnnotation(Property.class);
                if (!InetAddressInfo.isInetAddressRelated(fields[j])) continue;
                String string = defaultValue = ip_version == StackType.IPv4 ? annotation.defaultValueIPv4() : annotation.defaultValueIPv6();
                if (defaultValue == null || defaultValue.isEmpty() || defaultValue == null && PropertyHelper.usesDefaultConverter(fields[j])) continue;
                Object converted = null;
                try {
                    converted = defaultValue.equalsIgnoreCase("NON_LOOPBACK_ADDRESS") ? default_ip_address : PropertyHelper.getConvertedValue((Object)protocol, fields[j], properties, defaultValue, true, ip_version);
                    if (converted != null) {
                        Util.setField(fields[j], protocol, converted);
                    }
                }
                catch (Exception e) {
                    throw new Exception("default could not be assigned for field " + propertyName + " in " + protocolName + " with default value " + defaultValue, e);
                }
                log.debug("set property " + protocolName + "." + propertyName + " to default value " + converted);
            }
        }
    }

    public static void setDefaultValues(List<Protocol> protocols, StackType ip_version) throws Exception {
        InetAddress default_ip_address = Util.getNonLoopbackAddress(ip_version);
        if (default_ip_address == null) {
            log.warn(Util.getMessage("OnlyLoopbackFound"), new Object[]{ip_version});
            default_ip_address = Util.getLoopback(ip_version);
        }
        for (Protocol protocol : protocols) {
            String protocolName = protocol.getName();
            Field[] fields = Util.getAllDeclaredFieldsWithAnnotations(protocol.getClass(), Property.class);
            for (int j = 0; j < fields.length; ++j) {
                String defaultValue;
                Object propertyValue;
                if (!InetAddressInfo.isInetAddressRelated(fields[j]) || (propertyValue = Configurator.getValueFromProtocol(protocol, fields[j])) != null) continue;
                Property annotation = fields[j].getAnnotation(Property.class);
                String string = defaultValue = ip_version == StackType.IPv6 ? annotation.defaultValueIPv6() : annotation.defaultValueIPv4();
                if (defaultValue == null || defaultValue.isEmpty()) continue;
                Object converted = null;
                try {
                    converted = defaultValue.equalsIgnoreCase("NON_LOOPBACK_ADDRESS") ? default_ip_address : PropertyHelper.getConvertedValue(protocol, fields[j], defaultValue, true, ip_version);
                    if (converted != null) {
                        Util.setField(fields[j], protocol, converted);
                    }
                }
                catch (Exception e) {
                    throw new Exception("default could not be assigned for field " + fields[j].getName() + " in " + protocolName + " with default value " + defaultValue, e);
                }
                log.debug("set property " + protocolName + "." + fields[j].getName() + " to default value " + converted);
            }
        }
    }

    public static void ensureValidBindAddresses(List<Protocol> protocols) throws Exception {
        for (Protocol protocol : protocols) {
            String protocolName = protocol.getName();
            Field[] fields = Util.getAllDeclaredFieldsWithAnnotations(protocol.getClass(), LocalAddress.class);
            for (int i = 0; i < fields.length; ++i) {
                Object val = Configurator.getValueFromProtocol(protocol, fields[i]);
                if (val == null) continue;
                if (!(val instanceof InetAddress)) {
                    throw new Exception("field " + protocolName + "." + fields[i].getName() + " is not an InetAddress");
                }
                Util.checkIfValidAddress((InetAddress)val, protocolName);
            }
        }
    }

    public static <T> T getValueFromProtocol(Protocol protocol, Field field) throws IllegalAccessException {
        if (protocol == null || field == null) {
            return null;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        return (T)field.get(protocol);
    }

    public static <T> T getValueFromProtocol(Protocol protocol, String field_name) throws IllegalAccessException {
        if (protocol == null || field_name == null) {
            return null;
        }
        Field field = Util.getField(protocol.getClass(), field_name);
        return field != null ? (T)Configurator.getValueFromProtocol(protocol, field) : null;
    }

    static AccessibleObject[] computePropertyDependencies(Object obj, Map<String, String> properties) {
        LinkedList<AccessibleObject> unorderedFieldsAndMethods = new LinkedList<AccessibleObject>();
        List<Object> orderedFieldsAndMethods = new LinkedList();
        HashMap<String, AccessibleObject> propertiesInventory = new HashMap<String, AccessibleObject>();
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(Property.class) || !Configurator.isSetPropertyMethod(methods[i], obj.getClass())) continue;
            String propertyName = PropertyHelper.getPropertyName(methods[i]);
            unorderedFieldsAndMethods.add(methods[i]);
            propertiesInventory.put(propertyName, methods[i]);
        }
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].isAnnotationPresent(Property.class)) continue;
                String propertyName = PropertyHelper.getPropertyName(fields[i], properties);
                unorderedFieldsAndMethods.add(fields[i]);
                propertiesInventory.put(propertyName, fields[i]);
            }
        }
        Configurator.checkDependencyReferencesPresent(unorderedFieldsAndMethods, propertiesInventory);
        orderedFieldsAndMethods = Configurator.orderFieldsAndMethodsByDependency(unorderedFieldsAndMethods, propertiesInventory);
        AccessibleObject[] result = new AccessibleObject[orderedFieldsAndMethods.size()];
        for (int i = 0; i < orderedFieldsAndMethods.size(); ++i) {
            result[i] = (AccessibleObject)orderedFieldsAndMethods.get(i);
        }
        return result;
    }

    static List<AccessibleObject> orderFieldsAndMethodsByDependency(List<AccessibleObject> unorderedList, Map<String, AccessibleObject> propertiesMap) {
        Stack<AccessibleObject> stack = new Stack<AccessibleObject>();
        LinkedList<AccessibleObject> orderedList = new LinkedList<AccessibleObject>();
        for (int i = 0; i < unorderedList.size(); ++i) {
            AccessibleObject obj = unorderedList.get(i);
            Configurator.addPropertyToDependencyList(orderedList, propertiesMap, stack, obj);
        }
        return orderedList;
    }

    static void addPropertyToDependencyList(List<AccessibleObject> orderedList, Map<String, AccessibleObject> props, Stack<AccessibleObject> stack, AccessibleObject obj) {
        if (orderedList.contains(obj)) {
            return;
        }
        if (stack.search(obj) > 0) {
            throw new RuntimeException("Deadlock in @Property dependency processing");
        }
        stack.push(obj);
        Property annotation = obj.getAnnotation(Property.class);
        String dependsClause = annotation.dependsUpon();
        StringTokenizer st = new StringTokenizer(dependsClause, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            AccessibleObject dep = props.get(token);
            Configurator.addPropertyToDependencyList(orderedList, props, stack, dep);
        }
        stack.pop();
        orderedList.add(obj);
    }

    static void checkDependencyReferencesPresent(List<AccessibleObject> objects, Map<String, AccessibleObject> props) {
        for (int i = 0; i < objects.size(); ++i) {
            AccessibleObject ao = objects.get(i);
            Property annotation = ao.getAnnotation(Property.class);
            if (annotation == null) {
                throw new IllegalArgumentException("@Property annotation is required for checking dependencies; annotation is missing for Field/Method " + ao.toString());
            }
            String dependsClause = annotation.dependsUpon();
            if (dependsClause.trim().isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(dependsClause, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                boolean found = false;
                Set<String> keyset = props.keySet();
                Iterator<String> iter = keyset.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().equals(token)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("@Property annotation " + annotation.name() + " has an unresolved dependsUpon property: " + token);
            }
        }
    }

    public static void resolveAndInvokePropertyMethods(Object obj, Map<String, String> props, StackType ip_version) throws Exception {
        Method[] methods;
        for (Method method : methods = obj.getClass().getMethods()) {
            Configurator.resolveAndInvokePropertyMethod(obj, method, props, ip_version);
        }
    }

    public static void resolveAndInvokePropertyMethod(Object obj, Method method, Map<String, String> props, StackType ip_version) throws Exception {
        String methodName = method.getName();
        Property annotation = method.getAnnotation(Property.class);
        if (annotation != null && Configurator.isSetPropertyMethod(method, obj.getClass())) {
            String deprecated_msg;
            String propertyName = PropertyHelper.getPropertyName(method);
            String propertyValue = props.get(propertyName);
            String tmp = Configurator.grabSystemProp(method.getAnnotation(Property.class));
            if (tmp != null) {
                propertyValue = tmp;
            }
            if (propertyName != null && propertyValue != null && (deprecated_msg = annotation.deprecatedMessage()) != null && !deprecated_msg.isEmpty()) {
                log.warn(Util.getMessage("Deprecated"), method.getDeclaringClass().getSimpleName() + "." + methodName, deprecated_msg);
            }
            if (propertyValue != null) {
                Object converted = null;
                try {
                    converted = PropertyHelper.getConvertedValue(obj, method, props, propertyValue, true, ip_version);
                    method.invoke(obj, converted);
                }
                catch (Exception e) {
                    String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                    throw new Exception("Could not assign property " + propertyName + " in " + name + ", method is " + methodName + ", converted value is " + converted, e);
                }
            }
            props.remove(propertyName);
        }
    }

    public static void resolveAndAssignFields(Object obj, Map<String, String> props, StackType ip_version) throws Exception {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Configurator.resolveAndAssignField(obj, field, props, ip_version);
            }
        }
    }

    public static void resolveAndAssignField(Object obj, Field field, Map<String, String> props, StackType ip_version) throws Exception {
        Property annotation = field.getAnnotation(Property.class);
        if (annotation != null) {
            String deprecated_msg;
            String tmp;
            String propertyName = PropertyHelper.getPropertyName(field, props);
            String propertyValue = props.get(propertyName);
            if (propertyValue == null && (tmp = Configurator.grabSystemProp(field.getAnnotation(Property.class))) != null) {
                propertyValue = tmp;
            }
            if (propertyName != null && propertyValue != null && (deprecated_msg = annotation.deprecatedMessage()) != null && !deprecated_msg.isEmpty()) {
                log.warn(Util.getMessage("Deprecated"), field.getDeclaringClass().getSimpleName() + "." + field.getName(), deprecated_msg);
            }
            if (propertyValue != null || !PropertyHelper.usesDefaultConverter(field)) {
                Object converted = null;
                try {
                    converted = PropertyHelper.getConvertedValue(obj, field, props, propertyValue, true, ip_version);
                    if (converted != null) {
                        Util.setField(field, obj, converted);
                    }
                }
                catch (Exception e) {
                    String name = obj instanceof Protocol ? ((Protocol)obj).getName() : obj.getClass().getName();
                    throw new Exception("Property assignment of " + propertyName + " in " + name + " with original property value " + propertyValue + " and converted to " + converted + " could not be assigned", e);
                }
            }
            props.remove(propertyName);
        }
    }

    public static boolean isSetPropertyMethod(Method method) {
        return method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1;
    }

    public static boolean isSetPropertyMethod(Method method, Class<?> enclosing_clazz) {
        return method.getName().startsWith("set") && (method.getReturnType() == Void.TYPE || enclosing_clazz.isAssignableFrom(method.getReturnType())) && method.getParameterTypes().length == 1;
    }

    private static String grabSystemProp(Property annotation) {
        String[] system_property_names = annotation.systemProperty();
        String retval = null;
        for (String system_property_name : system_property_names) {
            if (system_property_name == null || system_property_name.isEmpty()) continue;
            try {
                retval = System.getProperty(system_property_name);
                if (retval != null) {
                    return retval;
                }
            }
            catch (SecurityException ex) {
                log.error(Util.getMessage("SyspropFailure"), system_property_name, ex);
            }
            try {
                retval = System.getenv(system_property_name);
                if (retval == null) continue;
                return retval;
            }
            catch (SecurityException ex) {
                log.error(Util.getMessage("SyspropFailure"), system_property_name, ex);
            }
        }
        return retval;
    }

    public static class InetAddressInfo {
        Protocol protocol;
        AccessibleObject fieldOrMethod;
        Map<String, String> properties;
        String propertyName;
        String stringValue;
        Object convertedValue;
        boolean isField;
        boolean isParameterized;
        Object baseType;

        InetAddressInfo(Protocol protocol, AccessibleObject fieldOrMethod, Map<String, String> properties, String stringValue, Object convertedValue) {
            if (protocol == null) {
                throw new IllegalArgumentException("Protocol for Field/Method must be non-null");
            }
            if (fieldOrMethod instanceof Field) {
                this.isField = true;
            } else if (fieldOrMethod instanceof Method) {
                this.isField = false;
            } else {
                throw new IllegalArgumentException("AccesibleObject is neither Field nor Method");
            }
            if (properties == null) {
                throw new IllegalArgumentException("Properties for Field/Method must be non-null");
            }
            this.protocol = protocol;
            this.fieldOrMethod = fieldOrMethod;
            this.properties = properties;
            this.stringValue = stringValue;
            this.convertedValue = convertedValue;
            this.propertyName = this.isField() ? PropertyHelper.getPropertyName((Field)fieldOrMethod, properties) : PropertyHelper.getPropertyName((Method)fieldOrMethod);
            this.isParameterized = false;
            this.isParameterized = this.isField() ? InetAddressInfo.hasParameterizedType((Field)fieldOrMethod) : InetAddressInfo.hasParameterizedType((Method)fieldOrMethod);
            this.baseType = null;
            if (this.isField() && this.isParameterized) {
                ParameterizedType fpt = (ParameterizedType)((Field)fieldOrMethod).getGenericType();
                this.baseType = fpt.getActualTypeArguments()[0];
            } else if (!this.isField() && this.isParameterized) {
                Type[] types = ((Method)fieldOrMethod).getGenericParameterTypes();
                ParameterizedType mpt = (ParameterizedType)types[0];
                this.baseType = mpt.getActualTypeArguments()[0];
            }
        }

        boolean isField() {
            return this.isField;
        }

        String getStringValue() {
            return this.stringValue;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        Object getConvertedValue() {
            return this.convertedValue;
        }

        boolean isParameterized() {
            return this.isParameterized;
        }

        Object getBaseType() {
            return this.baseType;
        }

        static boolean hasParameterizedType(Field f) {
            if (f == null) {
                throw new IllegalArgumentException("Field argument is null");
            }
            Type type = f.getGenericType();
            return type instanceof ParameterizedType;
        }

        static boolean hasParameterizedType(Method m) throws IllegalArgumentException {
            if (m == null) {
                throw new IllegalArgumentException("Method argument is null");
            }
            Type[] types = m.getGenericParameterTypes();
            return types[0] instanceof ParameterizedType;
        }

        static boolean isInetAddressRelated(Field f) {
            if (InetAddressInfo.hasParameterizedType(f)) {
                ParameterizedType fieldtype = (ParameterizedType)f.getGenericType();
                try {
                    InetAddressInfo.parameterizedTypeSanityCheck(fieldtype);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                Class listType = (Class)fieldtype.getActualTypeArguments()[0];
                return InetAddressInfo.isInetAddressOrCompatibleType(listType);
            }
            Class<?> fieldtype = f.getType();
            return InetAddressInfo.isInetAddressOrCompatibleType(fieldtype);
        }

        static boolean isInetAddressRelated(Method m) {
            if (InetAddressInfo.hasParameterizedType(m)) {
                Type[] types = m.getGenericParameterTypes();
                ParameterizedType methodParamType = (ParameterizedType)types[0];
                try {
                    InetAddressInfo.parameterizedTypeSanityCheck(methodParamType);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                Class listType = (Class)methodParamType.getActualTypeArguments()[0];
                return InetAddressInfo.isInetAddressOrCompatibleType(listType);
            }
            Class<?> methodParamType = m.getParameterTypes()[0];
            return InetAddressInfo.isInetAddressOrCompatibleType(methodParamType);
        }

        static boolean isInetAddressOrCompatibleType(Class<?> c) {
            return InetAddress.class.isAssignableFrom(c) || SocketAddress.class.isAssignableFrom(c) || PhysicalAddress.class.isAssignableFrom(c);
        }

        static void parameterizedTypeSanityCheck(ParameterizedType pt) throws IllegalArgumentException {
            Type rawType = pt.getRawType();
            Type[] actualTypes = pt.getActualTypeArguments();
            if (!(rawType instanceof Class) || !Collection.class.isAssignableFrom((Class)rawType)) {
                throw new IllegalArgumentException("Invalid parameterized type definition - parameterized type must be a collection");
            }
            if (!(actualTypes[0] instanceof Class)) {
                throw new IllegalArgumentException("Invalid parameterized type - List must not contain a parameterized type");
            }
        }

        public List<InetAddress> getInetAddresses() {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            if (this.getConvertedValue() == null) {
                return addresses;
            }
            if (!this.isParameterized()) {
                addresses.add(InetAddressInfo.getInetAddress(this.getConvertedValue()));
                return addresses;
            }
            List values = (List)this.getConvertedValue();
            if (values.isEmpty()) {
                return addresses;
            }
            for (int i = 0; i < values.size(); ++i) {
                addresses.add(InetAddressInfo.getInetAddress(values.get(i)));
            }
            return addresses;
        }

        private static InetAddress getInetAddress(Object obj) throws IllegalArgumentException {
            if (obj == null) {
                throw new IllegalArgumentException("Input argument must represent a non-null IP address");
            }
            if (obj instanceof InetAddress) {
                return (InetAddress)obj;
            }
            if (obj instanceof IpAddress) {
                return ((IpAddress)obj).getIpAddress();
            }
            if (obj instanceof InetSocketAddress) {
                return ((InetSocketAddress)obj).getAddress();
            }
            throw new IllegalArgumentException("Input argument does not represent one of InetAddress. IpAddress not InetSocketAddress");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("InetAddressInfo(").append("protocol=" + this.protocol.getName()).append(", propertyName=" + this.getPropertyName()).append(", string value=" + this.getStringValue()).append(", parameterized=" + this.isParameterized());
            if (this.isParameterized()) {
                sb.append(", baseType=" + this.getBaseType());
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

