/*
 * Decompiled with CFR 0.152.
 */
package kamon.context.generated.binary.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.util.InputMismatchException;

public class StringTag
implements Serializable {
    public static int colferSizeMax = 0x1000000;
    public String key;
    public String value;
    private static final long serialVersionUID = 2L;

    public StringTag() {
        this.init();
    }

    private void init() {
        this.key = "";
        this.value = "";
    }

    public byte[] marshal(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[Math.min(colferSizeMax, 2048)];
        }
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferOverflowException bufferOverflowException) {
                byArray = new byte[Math.min(colferSizeMax, byArray.length * 4)];
                continue;
            }
            break;
        }
        outputStream.write(byArray, 0, n);
        return byArray;
    }

    public int marshal(byte[] byArray, int n) {
        int n2 = n;
        try {
            int n3;
            int n4;
            int n5;
            int n6;
            String string;
            int n7;
            if (!this.key.isEmpty()) {
                byArray[n2++] = 0;
                n7 = ++n2;
                string = this.key;
                n6 = string.length();
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = string.charAt(n5);
                    if (n4 < 128) {
                        byArray[n2++] = (byte)n4;
                        continue;
                    }
                    if (n4 < 2048) {
                        byArray[n2++] = (byte)(0xC0 | n4 >>> 6);
                        byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                        continue;
                    }
                    if (n4 < 55296 || n4 > 57343) {
                        byArray[n2++] = (byte)(0xE0 | n4 >>> 12);
                        byArray[n2++] = (byte)(0x80 | n4 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                        continue;
                    }
                    n3 = 0;
                    if (++n5 < n6) {
                        n3 = Character.toCodePoint((char)n4, string.charAt(n5));
                    }
                    if (n3 >= 65536 && n3 < 0x200000) {
                        byArray[n2++] = (byte)(0xF0 | n3 >>> 18);
                        byArray[n2++] = (byte)(0x80 | n3 >>> 12 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n3 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                        continue;
                    }
                    byArray[n2++] = 63;
                }
                n5 = n2 - n7;
                if (n5 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.StringTag.key size %d exceeds %d UTF-8 bytes", n5, colferSizeMax));
                }
                n6 = n7 - 1;
                if (n5 > 127) {
                    ++n2;
                    for (n4 = n5; n4 >= 16384; n4 >>>= 7) {
                        ++n2;
                    }
                    System.arraycopy(byArray, n7, byArray, n2 - n5, n5);
                    do {
                        byArray[n6++] = (byte)(n5 | 0x80);
                    } while ((n5 >>>= 7) > 127);
                }
                byArray[n6] = (byte)n5;
            }
            if (!this.value.isEmpty()) {
                byArray[n2++] = 1;
                n7 = ++n2;
                string = this.value;
                n6 = string.length();
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = string.charAt(n5);
                    if (n4 < 128) {
                        byArray[n2++] = (byte)n4;
                        continue;
                    }
                    if (n4 < 2048) {
                        byArray[n2++] = (byte)(0xC0 | n4 >>> 6);
                        byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                        continue;
                    }
                    if (n4 < 55296 || n4 > 57343) {
                        byArray[n2++] = (byte)(0xE0 | n4 >>> 12);
                        byArray[n2++] = (byte)(0x80 | n4 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                        continue;
                    }
                    n3 = 0;
                    if (++n5 < n6) {
                        n3 = Character.toCodePoint((char)n4, string.charAt(n5));
                    }
                    if (n3 >= 65536 && n3 < 0x200000) {
                        byArray[n2++] = (byte)(0xF0 | n3 >>> 18);
                        byArray[n2++] = (byte)(0x80 | n3 >>> 12 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n3 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                        continue;
                    }
                    byArray[n2++] = 63;
                }
                n5 = n2 - n7;
                if (n5 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.StringTag.value size %d exceeds %d UTF-8 bytes", n5, colferSizeMax));
                }
                n6 = n7 - 1;
                if (n5 > 127) {
                    ++n2;
                    for (n4 = n5; n4 >= 16384; n4 >>>= 7) {
                        ++n2;
                    }
                    System.arraycopy(byArray, n7, byArray, n2 - n5, n5);
                    do {
                        byArray[n6++] = (byte)(n5 | 0x80);
                    } while ((n5 >>>= 7) > 127);
                }
                byArray[n6] = (byte)n5;
            }
            byArray[n2++] = 127;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 - n > colferSizeMax) {
                throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.StringTag exceeds %d bytes", colferSizeMax));
            }
            if (n2 > byArray.length) {
                throw new BufferOverflowException();
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int unmarshal(byte[] byArray, int n) {
        return this.unmarshal(byArray, n, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unmarshal(byte[] byArray, int n, int n2) {
        int n3;
        block15: {
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            n3 = n;
            try {
                byte by;
                int n4;
                int n5;
                byte by2 = byArray[n3++];
                if (by2 == 0) {
                    n5 = 0;
                    n4 = 0;
                    while (true) {
                        by = byArray[n3++];
                        n5 |= (by & 0x7F) << n4;
                        if (n4 == 28 || by >= 0) break;
                        n4 += 7;
                    }
                    if (n5 < 0 || n5 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.StringTag.key size %d exceeds %d UTF-8 bytes", n5, colferSizeMax));
                    }
                    n4 = n3;
                    n3 += n5;
                    this.key = new String(byArray, n4, n5, StandardCharsets.UTF_8);
                    by2 = byArray[n3++];
                }
                if (by2 == 1) {
                    n5 = 0;
                    n4 = 0;
                    while (true) {
                        by = byArray[n3++];
                        n5 |= (by & 0x7F) << n4;
                        if (n4 == 28 || by >= 0) break;
                        n4 += 7;
                    }
                    if (n5 < 0 || n5 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.StringTag.value size %d exceeds %d UTF-8 bytes", n5, colferSizeMax));
                    }
                    n4 = n3;
                    n3 += n5;
                    this.value = new String(byArray, n4, n5, StandardCharsets.UTF_8);
                    by2 = byArray[n3++];
                }
                if (by2 != 127) {
                    throw new InputMismatchException(String.format("colfer: unknown header at byte %d", n3 - 1));
                }
                if (n3 <= n2 || n2 - n >= colferSizeMax) break block15;
            }
            catch (Throwable throwable) {
                if (n3 > n2 && n2 - n < colferSizeMax) {
                    throw new BufferUnderflowException();
                }
                if (n3 < 0 || n3 - n > colferSizeMax) {
                    throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.StringTag exceeds %d bytes", colferSizeMax));
                }
                if (n3 > n2) {
                    throw new BufferUnderflowException();
                }
                throw throwable;
            }
            throw new BufferUnderflowException();
        }
        if (n3 < 0 || n3 - n > colferSizeMax) {
            throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.StringTag exceeds %d bytes", colferSizeMax));
        }
        if (n3 > n2) {
            throw new BufferUnderflowException();
        }
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                byArray = new byte[4 * byArray.length];
                continue;
            }
            break;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray, 0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.init();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.unmarshal(byArray, 0);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public StringTag withKey(String string) {
        this.key = string;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public StringTag withValue(String string) {
        this.value = string;
        return this;
    }

    public final int hashCode() {
        int n = 1;
        if (this.key != null) {
            n = 31 * n + this.key.hashCode();
        }
        if (this.value != null) {
            n = 31 * n + this.value.hashCode();
        }
        return n;
    }

    public final boolean equals(Object object) {
        return object instanceof StringTag && this.equals((StringTag)object);
    }

    public final boolean equals(StringTag stringTag) {
        if (stringTag == null) {
            return false;
        }
        if (stringTag == this) {
            return true;
        }
        return stringTag.getClass() == StringTag.class && (this.key == null ? stringTag.key == null : this.key.equals(stringTag.key)) && (this.value == null ? stringTag.value == null : this.value.equals(stringTag.value));
    }

    public static class Unmarshaller {
        protected InputStream in;
        public byte[] buf;
        protected int offset;
        protected int i;

        public Unmarshaller(InputStream inputStream, byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                byArray = new byte[Math.min(colferSizeMax, 2048)];
            }
            this.buf = byArray;
            this.reset(inputStream);
        }

        public void reset(InputStream inputStream) {
            if (this.i != this.offset) {
                throw new IllegalStateException("colfer: pending data");
            }
            this.in = inputStream;
            this.offset = 0;
            this.i = 0;
        }

        public StringTag next() throws IOException {
            if (this.in == null) {
                return null;
            }
            while (true) {
                if (this.i > this.offset) {
                    try {
                        StringTag stringTag = new StringTag();
                        this.offset = stringTag.unmarshal(this.buf, this.offset, this.i);
                        return stringTag;
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (this.i == this.buf.length) {
                    byte[] byArray = this.buf;
                    if (this.offset == 0) {
                        this.buf = new byte[Math.min(colferSizeMax, this.buf.length * 4)];
                    }
                    System.arraycopy(byArray, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert (this.i < this.buf.length);
                int n = this.in.read(this.buf, this.i, this.buf.length - this.i);
                if (n < 0) {
                    if (this.i > this.offset) {
                        throw new InputMismatchException("colfer: pending data with EOF");
                    }
                    return null;
                }
                assert (n > 0);
                this.i += n;
            }
        }
    }
}

