/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.core.upgrade.ConfigurationItemData;
import com.xebialabs.deployit.core.upgrade.PermissionEntry;
import com.xebialabs.deployit.core.upgrade.RoleEntry;
import com.xebialabs.deployit.core.upgrade.RolePrincipal;
import com.xebialabs.deployit.core.upgrade.RoleRole;
import com.xebialabs.deployit.core.upgrade.service.ArchiveSecurityUpgraderService;
import com.xebialabs.deployit.core.upgrade.service.SecurityUpgraderService;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005I4AAD\b\u00015!AA\u0006\u0001BC\u0002\u0013\u0005Q\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u0003/\u0011!)\u0004A!b\u0001\n\u00031\u0004\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000bm\u0002A\u0011\u0001\u001f\t\u000fE\u0003!\u0019!C\u0005%\"1A\f\u0001Q\u0001\nMCq!\u0018\u0001C\u0002\u0013%!\u000b\u0003\u0004_\u0001\u0001\u0006Ia\u0015\u0005\u0006?\u0002!\t\u0005\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006Y\u0002!I!\u001c\u0005\u0006c\u0002!I!\u001c\u0002)\t\u0016\u0004Hn\\=jif*\u0004GU3q_J$\u0018N\\4J[B\u0014xN^3nK:$8/\u00169he\u0006$WM\u001d\u0006\u0003!E\tq!\u001e9he\u0006$WM\u0003\u0002\u0013'\u0005!1m\u001c:f\u0015\t!R#\u0001\u0005eKBdw._5u\u0015\t1r#A\u0005yK\nL\u0017\r\\1cg*\t\u0001$A\u0002d_6\u001c\u0001aE\u0002\u00017\u0011\u0002\"\u0001\b\u0012\u000e\u0003uQ!\u0001\u0005\u0010\u000b\u0005}\u0001\u0013aA1qS*\u0011\u0011eE\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\rj\"aB+qOJ\fG-\u001a\t\u0003K)j\u0011A\n\u0006\u0003O!\nQa\u001d7gi)T\u0011!K\u0001\tOJL'P\u001f7fI&\u00111F\n\u0002\b\u0019><w-\u001b8h\u0003]\u0019XmY;sSRLX\u000b]4sC\u0012,'oU3sm&\u001cW-F\u0001/!\ty#'D\u00011\u0015\t\tt\"A\u0004tKJ4\u0018nY3\n\u0005M\u0002$aF*fGV\u0014\u0018\u000e^=Va\u001e\u0014\u0018\rZ3s'\u0016\u0014h/[2f\u0003a\u0019XmY;sSRLX\u000b]4sC\u0012,'oU3sm&\u001cW\rI\u0001\u001fCJ\u001c\u0007.\u001b<f'\u0016\u001cWO]5usV\u0003xM]1eKJ\u001cVM\u001d<jG\u0016,\u0012a\u000e\t\u0003_aJ!!\u000f\u0019\u0003=\u0005\u00138\r[5wKN+7-\u001e:jif,\u0006o\u001a:bI\u0016\u00148+\u001a:wS\u000e,\u0017aH1sG\"Lg/Z*fGV\u0014\u0018\u000e^=Va\u001e\u0014\u0018\rZ3s'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"2!P P!\tq\u0004!D\u0001\u0010\u0011\u0015aS\u00011\u0001/Q\ty\u0014\t\u0005\u0002C\u001b6\t1I\u0003\u0002E\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0019;\u0015a\u00024bGR|'/\u001f\u0006\u0003\u0011&\u000bQAY3b]NT!AS&\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001T\u0001\u0004_J<\u0017B\u0001(D\u0005%\tU\u000f^8xSJ,G\rC\u00036\u000b\u0001\u0007q\u0007\u000b\u0002P\u0003\u0006yQM\u001c<je>tW.\u001a8u)f\u0004X-F\u0001T!\t!&,D\u0001V\u0015\t1v+A\u0004sK\u001adWm\u0019;\u000b\u0005}A&BA-\u0014\u0003\u0019\u0001H.^4j]&\u00111,\u0016\u0002\u0005)f\u0004X-\u0001\tf]ZL'o\u001c8nK:$H+\u001f9fA\u0005y\u0011\r\u001d9mS\u000e\fG/[8o)f\u0004X-\u0001\tbaBd\u0017nY1uS>tG+\u001f9fA\u0005IAm\\+qOJ\fG-\u001a\u000b\u0002CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n9!i\\8mK\u0006t\u0017AD;qOJ\fG-\u001a,feNLwN\u001c\u000b\u0002SB\u0011AD[\u0005\u0003Wv\u0011qAV3sg&|g.\u0001\u000fva\u0012\fG/Z%oi\u0016\u0014h.\u00197B]\u0012\u001cVmY;sK\u000eK\u0017\nZ:\u0015\u00039\u0004\"AY8\n\u0005A\u001c'\u0001B+oSR\fq$\u001e9eCR,'k\u001c7fg\u0006sG\rU3s[&\u001c8/[8ogN\u001b\u0007.Z7b\u0001")
public class Deployit950ReportingImprovementsUpgrader
extends Upgrade
implements Logging {
    private final SecurityUpgraderService securityUpgraderService;
    private final ArchiveSecurityUpgraderService archiveSecurityUpgraderService;
    private final Type environmentType;
    private final Type applicationType;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Deployit950ReportingImprovementsUpgrader deployit950ReportingImprovementsUpgrader = this;
        synchronized (deployit950ReportingImprovementsUpgrader) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SecurityUpgraderService securityUpgraderService() {
        return this.securityUpgraderService;
    }

    public ArchiveSecurityUpgraderService archiveSecurityUpgraderService() {
        return this.archiveSecurityUpgraderService;
    }

    private Type environmentType() {
        return this.environmentType;
    }

    private Type applicationType() {
        return this.applicationType;
    }

    public boolean doUpgrade() {
        Failure failure;
        Throwable exception;
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.updateInternalAndSecureCiIds();
            this.updateRolesAndPermissionsSchema();
        });
        if (try_ instanceof Success) {
            this.logger().debug((Function0 & Serializable)() -> "Reporting updates have been successfully applied.");
            bl = true;
        } else if (try_ instanceof Failure && (exception = (failure = (Failure)try_).exception()) instanceof Exception) {
            Exception exception2 = (Exception)exception;
            this.logger().error((Function0 & Serializable)() -> "Reporting updates cannot be applied.", (Function0 & Serializable)() -> exception2);
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"9.5.0");
    }

    private void updateInternalAndSecureCiIds() {
        this.logger().info((Function0 & Serializable)() -> "Updating existing archive database with Security data");
        List environmentTypes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Type[]{this.environmentType()}));
        List applicationTypes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Type[]{this.applicationType()}));
        List customEnvTypes = CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)this.environmentType())).asScala().toList();
        List customAppTypes = CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)this.applicationType())).asScala().toList();
        if (customEnvTypes.nonEmpty()) {
            environmentTypes = (List)environmentTypes.$plus$plus((IterableOnce)customEnvTypes);
        }
        if (customAppTypes.nonEmpty()) {
            applicationTypes = (List)applicationTypes.$plus$plus((IterableOnce)customAppTypes);
        }
        environmentTypes.foreach((Function1 & Serializable)envType -> {
            Deployit950ReportingImprovementsUpgrader.$anonfun$updateInternalAndSecureCiIds$2(this, envType);
            return BoxedUnit.UNIT;
        });
        applicationTypes.foreach((Function1 & Serializable)appType -> {
            Deployit950ReportingImprovementsUpgrader.$anonfun$updateInternalAndSecureCiIds$3(this, appType);
            return BoxedUnit.UNIT;
        });
        List<ConfigurationItemData> otherCis = this.securityUpgraderService().fetchOtherCis();
        this.archiveSecurityUpgraderService().updateTargetCis(otherCis);
        this.logger().info((Function0 & Serializable)() -> "Finished updating existing archive database with Security data");
    }

    private void updateRolesAndPermissionsSchema() {
        List<RoleEntry> roles = this.securityUpgraderService().fetchRoles();
        List<RoleRole> roleRoles = this.securityUpgraderService().fetchRoleRoles();
        List<RolePrincipal> rolePrincipals = this.securityUpgraderService().fetchRolePrincipals();
        List<PermissionEntry> rolePermissions = this.securityUpgraderService().fetchRolePermissions();
        this.logger().info((Function0 & Serializable)() -> "Inserting roles and permission records to the archive database");
        this.archiveSecurityUpgraderService().insertArchiveRoles(roles);
        this.archiveSecurityUpgraderService().insertArchiveRoleRoles(roleRoles);
        this.archiveSecurityUpgraderService().insertArchiveRolePrincipals(rolePrincipals);
        this.archiveSecurityUpgraderService().insertArchiveRolePermissions(rolePermissions);
        this.logger().info((Function0 & Serializable)() -> "Finished inserting  roles and permission records to the archive database");
    }

    public static final /* synthetic */ void $anonfun$updateInternalAndSecureCiIds$2(Deployit950ReportingImprovementsUpgrader $this, Type envType) {
        List<ConfigurationItemData> cisEnvs = $this.securityUpgraderService().fetchCis(envType.toString());
        $this.archiveSecurityUpgraderService().updateEnvironments(cisEnvs);
    }

    public static final /* synthetic */ void $anonfun$updateInternalAndSecureCiIds$3(Deployit950ReportingImprovementsUpgrader $this, Type appType) {
        List<ConfigurationItemData> cisApps = $this.securityUpgraderService().fetchCis(appType.toString());
        $this.archiveSecurityUpgraderService().updateApplications(cisApps);
    }

    public Deployit950ReportingImprovementsUpgrader(@Autowired SecurityUpgraderService securityUpgraderService, @Autowired ArchiveSecurityUpgraderService archiveSecurityUpgraderService) {
        this.securityUpgraderService = securityUpgraderService;
        this.archiveSecurityUpgraderService = archiveSecurityUpgraderService;
        Logging.$init$((Logging)this);
        this.environmentType = Type.valueOf((String)"udm.Environment");
        this.applicationType = Type.valueOf((String)"udm.Application");
    }
}

