/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc;

import com.vladsch.flexmark.ext.toc.TocBlockBase;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class TocBlock
extends TocBlockBase {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence tocKeyword = BasedSequence.NULL;
    protected BasedSequence style = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        TocBlock.segmentSpan((StringBuilder)out, (BasedSequence)this.openingMarker, (String)"openingMarker");
        TocBlock.segmentSpan((StringBuilder)out, (BasedSequence)this.tocKeyword, (String)"tocKeyword");
        TocBlock.segmentSpan((StringBuilder)out, (BasedSequence)this.style, (String)"style");
        TocBlock.segmentSpan((StringBuilder)out, (BasedSequence)this.closingMarker, (String)"closingMarker");
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        BasedSequence[] nodeSegments = new BasedSequence[]{this.openingMarker, this.tocKeyword, this.style, this.closingMarker};
        if (this.lineSegments.size() == 0) {
            return nodeSegments;
        }
        BasedSequence[] allSegments = new BasedSequence[this.lineSegments.size() + nodeSegments.length];
        this.lineSegments.toArray(allSegments);
        System.arraycopy(allSegments, 0, allSegments, nodeSegments.length, this.lineSegments.size());
        return allSegments;
    }

    public TocBlock(BasedSequence chars) {
        this(chars, false);
    }

    public TocBlock(BasedSequence chars, boolean closingSimToc) {
        this(chars, null, closingSimToc);
    }

    public TocBlock(BasedSequence chars, BasedSequence styleChars) {
        this(chars, styleChars, false);
    }

    public TocBlock(BasedSequence chars, BasedSequence styleChars, boolean closingSimToc) {
        super(chars);
        this.openingMarker = chars.subSequence(0, 1);
        this.tocKeyword = chars.subSequence(1, 4);
        if (styleChars != null) {
            this.style = styleChars;
        }
        int closingPos = chars.indexOf(']', 4);
        if (closingSimToc && (closingPos == -1 || closingPos + 1 >= chars.length() || chars.charAt(closingPos + 1) != ':')) {
            throw new IllegalStateException("Invalid TOC block sequence");
        }
        this.closingMarker = chars.subSequence(closingPos, closingPos + (closingSimToc ? 2 : 1));
    }

    @Override
    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    @Override
    public BasedSequence getTocKeyword() {
        return this.tocKeyword;
    }

    @Override
    public BasedSequence getStyle() {
        return this.style;
    }

    @Override
    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }
}

