/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ObjectError
extends DefaultMessageSourceResolvable {
    private final String objectName;
    @Nullable
    private transient Object source;

    public ObjectError(String objectName, @Nullable String defaultMessage) {
        this(objectName, null, null, defaultMessage);
    }

    public ObjectError(String objectName, @Nullable String[] codes, @Nullable Object[] arguments, @Nullable String defaultMessage) {
        super(codes, arguments, defaultMessage);
        Assert.notNull((Object)objectName, (String)"Object name must not be null");
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void wrap(Object source) {
        if (this.source != null) {
            throw new IllegalStateException("Already wrapping " + String.valueOf(this.source));
        }
        this.source = source;
    }

    public <T> T unwrap(Class<T> sourceType) {
        Throwable throwable;
        Throwable cause;
        if (sourceType.isInstance(this.source)) {
            return sourceType.cast(this.source);
        }
        Object object = this.source;
        if (object instanceof Throwable && sourceType.isInstance(cause = (throwable = (Throwable)object).getCause())) {
            return sourceType.cast(cause);
        }
        throw new IllegalArgumentException("No source object of the given type available: " + String.valueOf(sourceType));
    }

    public boolean contains(Class<?> sourceType) {
        Throwable throwable;
        Object object;
        return sourceType.isInstance(this.source) || (object = this.source) instanceof Throwable && sourceType.isInstance((throwable = (Throwable)object).getCause());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass() || !super.equals(other)) {
            return false;
        }
        ObjectError otherError = (ObjectError)other;
        return this.getObjectName().equals(otherError.getObjectName());
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + this.getObjectName().hashCode();
    }

    @Override
    public String toString() {
        return "Error in object '" + this.objectName + "': " + this.resolvableToString();
    }
}

