/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.monitor.DerbyObservable;
import org.apache.derby.iapi.services.monitor.DerbyObserver;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.raw.data.DropOnCommit;
import org.apache.derby.impl.store.raw.data.StreamFileContainer;
import org.apache.derby.shared.common.error.StandardException;

final class StreamFileContainerHandle
implements StreamContainerHandle,
DerbyObserver {
    private final UUID rawStoreId;
    protected final ContainerKey identity;
    protected boolean active;
    protected StreamFileContainer container;
    protected RawTransaction xact;
    private boolean hold;

    public StreamFileContainerHandle(UUID uUID, RawTransaction rawTransaction, ContainerKey containerKey, boolean bl) {
        this.identity = containerKey;
        this.xact = rawTransaction;
        this.rawStoreId = uUID;
        this.hold = bl;
    }

    public StreamFileContainerHandle(UUID uUID, RawTransaction rawTransaction, StreamFileContainer streamFileContainer, boolean bl) {
        this.identity = streamFileContainer.getIdentity();
        this.xact = rawTransaction;
        this.rawStoreId = uUID;
        this.hold = bl;
        this.container = streamFileContainer;
    }

    @Override
    public void getContainerProperties(Properties properties) throws StandardException {
        this.container.getContainerProperties(properties);
    }

    @Override
    public boolean fetchNext(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        return this.container.fetchNext(dataValueDescriptorArray);
    }

    @Override
    public void close() {
        if (this.xact == null) {
            return;
        }
        this.active = false;
        this.container.close();
        this.container = null;
        this.xact.deleteObserver(this);
        this.xact = null;
    }

    @Override
    public void removeContainer() throws StandardException {
        this.container.removeContainer();
    }

    @Override
    public ContainerKey getId() {
        return this.identity;
    }

    @Override
    public void update(DerbyObservable derbyObservable, Object object) {
        if (this.xact == null) {
            return;
        }
        if (object.equals(RawTransaction.COMMIT) || object.equals(RawTransaction.ABORT) || object.equals(this.identity)) {
            this.close();
            return;
        }
        if (object.equals(RawTransaction.SAVEPOINT_ROLLBACK)) {
            return;
        }
    }

    public boolean useContainer() throws StandardException {
        if (!this.container.use(this)) {
            this.container = null;
            return false;
        }
        this.active = true;
        if (!this.hold) {
            this.xact.addObserver(this);
            this.xact.addObserver(new DropOnCommit(this.identity, true));
        }
        return true;
    }

    public final RawTransaction getTransaction() {
        return this.xact;
    }

    public String toString() {
        return super.toString();
    }
}

