/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.jetty.metrics;

import com.tqdev.metrics.core.MetricRegistry;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.ee10.servlet.AsyncContextState;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class CustomInstrumentedHandler
extends Handler.Wrapper {
    private final MetricRegistry registry;
    private AsyncListener listener = new AsyncListener(){
        private long startTime;

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            this.startTime = CustomInstrumentedHandler.this.registry.getNanos();
            event.getAsyncContext().addListener((AsyncListener)this);
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState state = (AsyncContextState)event.getAsyncContext();
            HttpServletRequest request = (HttpServletRequest)state.getRequest();
            HttpServletResponse response = (HttpServletResponse)state.getResponse();
            CustomInstrumentedHandler.this.updateResponses(request, response, this.startTime);
        }
    };

    public CustomInstrumentedHandler(MetricRegistry registry) {
        this.registry = registry;
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (int responseStatus = 1; responseStatus <= 5; ++responseStatus) {
            this.registry.set("jetty.Response.Invocations", responseStatus + "xx-responses", 0L);
            this.registry.set("jetty.Response.Durations", responseStatus + "xx-responses", 0L);
        }
        this.registry.set("jetty.Response.Invocations", "other-responses", 0L);
        this.registry.set("jetty.Response.Durations", "other-responses", 0L);
        for (HttpMethod method : HttpMethod.values()) {
            String name = method.asString().toLowerCase();
            this.registry.set("jetty.Request.Invocations", name + "-requests", 0L);
            this.registry.set("jetty.Request.Durations", name + "-requests", 0L);
        }
        this.registry.set("jetty.Request.Invocations", "other-requests", 0L);
        this.registry.set("jetty.Request.Durations", "other-requests", 0L);
        this.registry.set("jetty.Aggregated.Invocations", "requests", 0L);
        this.registry.set("jetty.Aggregated.Durations", "requests", 0L);
        this.registry.set("jetty.Thread.Gauges", "threads", () -> this.getServer().getThreadPool().getThreads());
        this.registry.set("jetty.Thread.Gauges", "idle-threads", () -> this.getServer().getThreadPool().getIdleThreads());
        if (this.getServer().getThreadPool() instanceof QueuedThreadPool) {
            this.registry.set("jetty.Thread.Gauges", "busy-threads", () -> ((QueuedThreadPool)this.getServer().getThreadPool()).getBusyThreads());
            this.registry.set("jetty.Thread.Gauges", "min-threads", () -> ((QueuedThreadPool)this.getServer().getThreadPool()).getMinThreads());
            this.registry.set("jetty.Thread.Gauges", "max-threads", () -> ((QueuedThreadPool)this.getServer().getThreadPool()).getMaxThreads());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (!this.registry.isEnabled()) {
            return super.handle(request, response, callback);
        }
        if (request instanceof ServletContextRequest) {
            ServletContextRequest httpRequest = (ServletContextRequest)request;
            ServletChannelState state = httpRequest.getServletRequestState();
            if (state.isInitial()) {
                state.addListener(this.listener);
            }
            long startTime = this.registry.getNanos();
            try {
                boolean bl = super.handle(request, response, callback);
                return bl;
            }
            finally {
                if (!state.isSuspended() && state.isInitial()) {
                    this.updateResponses(request, response, startTime);
                }
            }
        }
        return super.handle(request, response, callback);
    }

    private String getMethodGroup(String method) {
        HttpMethod m = HttpMethod.fromString((String)method);
        if (m == null) {
            return "other";
        }
        return m.asString().toLowerCase();
    }

    private String getStatusGroup(int status) {
        int responseStatus = status / 100;
        if (responseStatus < 1 || responseStatus > 5) {
            return "other";
        }
        return responseStatus + "xx";
    }

    private void updateResponses(Request request, Response response, long startTime) {
        long duration = this.registry.getNanos() - startTime;
        this.registry.increment("jetty.Aggregated.Invocations", "requests");
        this.registry.add("jetty.Aggregated.Durations", "requests", duration);
        String methodGroup = this.getMethodGroup(request.getMethod());
        this.registry.increment("jetty.Request.Invocations", methodGroup + "-requests");
        this.registry.add("jetty.Request.Durations", methodGroup + "-requests", duration);
        String statusGroup = this.getStatusGroup(response.getStatus());
        this.registry.increment("jetty.Response.Invocations", statusGroup + "-responses");
        this.registry.add("jetty.Response.Durations", statusGroup + "-responses", duration);
    }

    private void updateResponses(HttpServletRequest request, HttpServletResponse response, long startTime) {
        long duration = this.registry.getNanos() - startTime;
        this.registry.increment("jetty.Aggregated.Invocations", "requests");
        this.registry.add("jetty.Aggregated.Durations", "requests", duration);
        String methodGroup = this.getMethodGroup(request.getMethod());
        this.registry.increment("jetty.Request.Invocations", methodGroup + "-requests");
        this.registry.add("jetty.Request.Durations", methodGroup + "-requests", duration);
        String statusGroup = this.getStatusGroup(response.getStatus());
        this.registry.increment("jetty.Response.Invocations", statusGroup + "-responses");
        this.registry.add("jetty.Response.Durations", statusGroup + "-responses", duration);
    }
}

