/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;

public class SequenceInformationExtractorTiDBDatabaseImpl
extends SequenceInformationExtractorLegacyImpl {
    public static final SequenceInformationExtractorTiDBDatabaseImpl INSTANCE = new SequenceInformationExtractorTiDBDatabaseImpl();
    private static final String SQL_SEQUENCE_QUERY = "SELECT '%1$s' AS sequence_name, MIN_VALUE AS minimum_value, MAX_VALUE AS maximum_value, START AS start_value, INCREMENT AS increment FROM information_schema.sequences WHERE sequence_name = '%1$s' AND sequence_schema = database()";
    private static final String UNION_ALL = "UNION ALL ";

    @Override
    public Iterable<SequenceInformation> extractMetadata(ExtractionContext extractionContext) throws SQLException {
        String lookupSql = extractionContext.getJdbcEnvironment().getDialect().getQuerySequencesString();
        if (lookupSql == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE.extractMetadata(extractionContext);
        }
        IdentifierHelper identifierHelper = extractionContext.getJdbcEnvironment().getIdentifierHelper();
        ArrayList<SequenceInformation> sequenceInformationList = new ArrayList<SequenceInformation>();
        ArrayList<String> sequenceNames = new ArrayList<String>();
        try (Statement statement = extractionContext.getJdbcConnection().createStatement();
             ResultSet resultSet = statement.executeQuery(lookupSql);){
            while (resultSet.next()) {
                sequenceNames.add(this.resultSetSequenceName(resultSet));
            }
        }
        if (!sequenceNames.isEmpty()) {
            StringBuilder sequenceInfoQueryBuilder = new StringBuilder();
            for (String sequenceName : sequenceNames) {
                if (sequenceInfoQueryBuilder.length() > 0) {
                    sequenceInfoQueryBuilder.append(UNION_ALL);
                }
                sequenceInfoQueryBuilder.append(String.format(SQL_SEQUENCE_QUERY, sequenceName));
            }
            try (Statement statement = extractionContext.getJdbcConnection().createStatement();
                 ResultSet resultSet = statement.executeQuery(sequenceInfoQueryBuilder.toString());){
                while (resultSet.next()) {
                    SequenceInformationImpl sequenceInformation = new SequenceInformationImpl(new QualifiedSequenceName(null, null, identifierHelper.toIdentifier(this.resultSetSequenceName(resultSet))), this.resultSetStartValueSize(resultSet), this.resultSetMinValue(resultSet), this.resultSetMaxValue(resultSet), this.resultSetIncrementValue(resultSet));
                    sequenceInformationList.add(sequenceInformation);
                }
            }
        }
        return sequenceInformationList;
    }

    @Override
    protected String sequenceNameColumn() {
        return "sequence_name";
    }

    @Override
    protected String sequenceIncrementColumn() {
        return "increment";
    }

    @Override
    protected String resultSetSequenceName(ResultSet resultSet) throws SQLException {
        return resultSet.getString(this.sequenceNameColumn());
    }

    @Override
    protected Number resultSetIncrementValue(ResultSet resultSet) throws SQLException {
        String column = this.sequenceIncrementColumn();
        return column != null ? Long.valueOf(resultSet.getLong(column)) : null;
    }
}

