/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.RIMBeanServerRegistrationUtility;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractJCacheManager
implements CacheManager {
    private static final Log log = (Log)LogFactory.getLog(AbstractJCacheManager.class, Log.class);
    private final URI uri;
    private final CachingProvider provider;
    protected Properties properties;
    private final HashMap<String, AbstractJCache<?, ?>> caches = new HashMap();
    private final StackTraceElement[] allocationStackTrace = Thread.currentThread().getStackTrace();
    private final boolean managedCacheManager;
    private volatile boolean isClosed;

    public AbstractJCacheManager(URI uri, ClassLoader classLoader, CachingProvider provider, Properties properties, boolean managedCacheManager) {
        this.uri = uri;
        this.provider = provider;
        this.properties = properties;
        this.managedCacheManager = managedCacheManager;
        this.isClosed = false;
    }

    public CachingProvider getCachingProvider() {
        return this.provider;
    }

    public URI getURI() {
        return this.uri;
    }

    public Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) {
        this.checkNotClosed().checkNull(cacheName, "cacheName").checkNull(configuration, "configuration");
        HashMap<String, AbstractJCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            AbstractJCache<Object, Object> cache = this.caches.get(cacheName);
            if (cache != null) {
                throw log.cacheAlreadyRegistered(cacheName, cache.getConfiguration(Configuration.class), configuration);
            }
            cache = this.create(cacheName, configuration);
            this.caches.put(cache.getName(), cache);
            return this.unchecked(cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkNotClosed().checkNull(keyType, "keyType").checkNull(valueType, "valueType");
        HashMap<String, AbstractJCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            Cache<K, V> cache = this.unchecked((Cache)this.caches.get(cacheName));
            if (cache != null) {
                Configuration configuration = cache.getConfiguration(Configuration.class);
                Class cfgKeyType = configuration.getKeyType();
                if (this.verifyType(keyType, cfgKeyType)) {
                    Class cfgValueType = configuration.getValueType();
                    if (this.verifyType(valueType, cfgValueType)) {
                        return cache;
                    }
                    throw log.incompatibleType(valueType, cfgValueType);
                }
                throw log.incompatibleType(keyType, cfgKeyType);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.checkNotClosed();
        HashMap<String, AbstractJCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            return this.unchecked((Cache)this.caches.get(cacheName));
        }
    }

    public Iterable<String> getCacheNames() {
        if (this.isClosed) {
            throw log.cacheManagerClosed();
        }
        return this.delegateCacheNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCache(String cacheName) {
        AbstractJCache<?, ?> destroyedCache;
        this.checkNotClosed().checkNull(cacheName, "cacheName");
        HashMap<String, AbstractJCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            destroyedCache = this.caches.remove(cacheName);
        }
        if (destroyedCache != null) {
            this.delegateRemoveCache(destroyedCache);
            destroyedCache.close();
        }
        this.unregisterCacheMBeans(destroyedCache);
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkNotClosed();
        this.caches.get(cacheName).setManagementEnabled(enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkNotClosed();
        this.caches.get(cacheName).setStatisticsEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isClosed()) {
            ArrayList cacheList;
            HashMap<String, AbstractJCache<?, ?>> hashMap = this.caches;
            synchronized (hashMap) {
                cacheList = new ArrayList(this.caches.values());
                this.caches.clear();
            }
            for (AbstractJCache abstractJCache : cacheList) {
                try {
                    abstractJCache.close();
                    this.unregisterCacheMBeans(abstractJCache);
                }
                catch (Exception exception) {}
            }
            this.delegateStop();
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.delegateIsClosed() || this.isClosed;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.managedCacheManager && !this.isClosed) {
                Log.LeakDescription t = log.cacheManagerNotClosed();
                t.setStackTrace(this.allocationStackTrace);
                log.leakedCacheManager(t);
                this.delegateStop();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, I extends BasicCache<K, V>> Cache<K, V> getOrCreateCache(String cacheName, I ispnCache) {
        HashMap<String, AbstractJCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            AbstractJCache<Object, Object> cache = this.caches.get(cacheName);
            if (cache == null) {
                cache = this.create(ispnCache);
                this.caches.put(cacheName, cache);
            }
            return this.unchecked(cache);
        }
    }

    protected <K, V> void registerPredefinedCache(String cacheName, AbstractJCache<K, V> cache) {
        this.caches.put(cacheName, cache);
    }

    protected abstract void delegateLogIsClosed();

    protected abstract Iterable<String> delegateCacheNames();

    protected abstract void delegateStop();

    protected abstract boolean delegateIsClosed();

    protected abstract <K, V> void delegateRemoveCache(AbstractJCache<K, V> var1);

    protected abstract <K, V, C extends Configuration<K, V>> AbstractJCache<K, V> create(String var1, C var2);

    protected abstract <K, V, I extends BasicCache<K, V>> AbstractJCache<K, V> create(I var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getManagedCacheNames() {
        HashSet<String> result = new HashSet<String>();
        HashMap<String, AbstractJCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            result.addAll(this.caches.keySet());
        }
        return Collections.unmodifiableSet(result);
    }

    private void unregisterCacheMBeans(AbstractJCache<?, ?> cache) {
        if (cache != null) {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(cache, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
            RIMBeanServerRegistrationUtility.unregisterCacheObject(cache, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        }
    }

    private AbstractJCacheManager checkNotClosed() {
        if (this.isClosed()) {
            this.delegateLogIsClosed();
        }
        return this;
    }

    private AbstractJCacheManager checkNull(Object obj, String name) {
        if (obj == null) {
            throw log.parameterMustNotBeNull(name);
        }
        return this;
    }

    private <K, V> Cache<K, V> unchecked(Cache<?, ?> cache) {
        return cache;
    }

    private <K> boolean verifyType(Class<K> type, Class<?> cfgType) {
        return cfgType != null && cfgType.equals(type);
    }
}

