/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.concurrent.CancellationException;
import org.apache.http.client.methods.HttpRequestBase;

public abstract class Cancellable {
    static final Cancellable NO_OP = new Cancellable(){

        @Override
        public void cancel() {
        }

        @Override
        void runIfNotCancelled(Runnable runnable) {
            throw new UnsupportedOperationException();
        }
    };

    public abstract void cancel();

    abstract void runIfNotCancelled(Runnable var1);

    static Cancellable fromRequest(HttpRequestBase httpRequest) {
        return new RequestCancellable(httpRequest);
    }

    static CancellationException newCancellationException() {
        return new CancellationException("request was cancelled");
    }

    private static class RequestCancellable
    extends Cancellable {
        private final HttpRequestBase httpRequest;

        private RequestCancellable(HttpRequestBase httpRequest) {
            this.httpRequest = httpRequest;
        }

        @Override
        public synchronized void cancel() {
            this.httpRequest.abort();
        }

        @Override
        synchronized void runIfNotCancelled(Runnable runnable) {
            if (this.httpRequest.isAborted()) {
                throw RequestCancellable.newCancellationException();
            }
            runnable.run();
        }
    }
}

