/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.springframework.data.jpa.repository.query.BadJpqlGrammarException;
import org.springframework.util.ObjectUtils;

class BadJpqlGrammarErrorListener
extends BaseErrorListener {
    private final String query;
    private final String grammar;

    BadJpqlGrammarErrorListener(String query) {
        this(query, "JPQL");
    }

    BadJpqlGrammarErrorListener(String query, String grammar) {
        this.query = query;
        this.grammar = grammar;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        throw new BadJpqlGrammarException(BadJpqlGrammarErrorListener.formatMessage(offendingSymbol, line, charPositionInLine, msg, e, this.query), this.grammar, this.query, null);
    }

    private static String formatMessage(Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e, String query) {
        CommonToken ct;
        String token;
        String errorText = "At " + line + ":" + charPositionInLine;
        if (offendingSymbol instanceof CommonToken && !ObjectUtils.isEmpty((Object)(token = (ct = (CommonToken)offendingSymbol).getText()))) {
            errorText = errorText + " and token '" + token + "'";
        }
        errorText = errorText + ", ";
        if (e instanceof NoViableAltException) {
            errorText = errorText + message.substring(0, message.indexOf(39));
            if (query.isEmpty()) {
                errorText = errorText + "'*' (empty query string)";
            } else {
                List<String> list = query.lines().toList();
                String lineText = list.get(line - 1);
                String text = lineText.substring(0, charPositionInLine) + "*" + lineText.substring(charPositionInLine);
                errorText = errorText + "'" + text + "'";
            }
        } else {
            errorText = e instanceof InputMismatchException ? errorText + message.substring(0, message.length() - 1).replace(" expecting {", ", expecting one of the following tokens: ") : errorText + message;
        }
        return errorText;
    }
}

