/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.core.lang.Nullable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventProcessor<T>
implements EventPublisher<T> {
    final List<EventConsumer<T>> onEventConsumers = new CopyOnWriteArrayList<EventConsumer<T>>();
    final ConcurrentMap<String, List<EventConsumer<T>>> eventConsumerMap = new ConcurrentHashMap<String, List<EventConsumer<T>>>();
    private boolean consumerRegistered;

    public boolean hasConsumers() {
        return this.consumerRegistered;
    }

    public synchronized void registerConsumer(String className, EventConsumer<? extends T> eventConsumer) {
        this.eventConsumerMap.compute(className, (k, consumers) -> {
            if (consumers == null) {
                consumers = new CopyOnWriteArrayList<EventConsumer>();
                consumers.add(eventConsumer);
                return consumers;
            }
            consumers.add(eventConsumer);
            return consumers;
        });
        this.consumerRegistered = true;
    }

    public <E extends T> boolean processEvent(E event) {
        List consumers;
        boolean consumed = false;
        if (!this.onEventConsumers.isEmpty()) {
            for (EventConsumer<E> eventConsumer : this.onEventConsumers) {
                eventConsumer.consumeEvent(event);
            }
            consumed = true;
        }
        if (!this.eventConsumerMap.isEmpty() && (consumers = (List)this.eventConsumerMap.get(event.getClass().getName())) != null && !consumers.isEmpty()) {
            for (EventConsumer consumer : consumers) {
                consumer.consumeEvent(event);
            }
            consumed = true;
        }
        return consumed;
    }

    @Override
    public synchronized void onEvent(@Nullable EventConsumer<T> onEventConsumer) {
        this.onEventConsumers.add(onEventConsumer);
        this.consumerRegistered = true;
    }
}

