/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import java.util.function.Function;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutAuthentication;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutTokenValidator;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.oidc.authentication.logout.OidcLogoutToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class OidcBackChannelLogoutAuthenticationProvider
implements AuthenticationProvider {
    private JwtDecoderFactory<ClientRegistration> logoutTokenDecoderFactory;

    OidcBackChannelLogoutAuthenticationProvider() {
        Function<ClientRegistration, OAuth2TokenValidator> jwtValidator = clientRegistration -> JwtValidators.createDefaultWithValidators((OAuth2TokenValidator[])new OAuth2TokenValidator[]{new OidcBackChannelLogoutTokenValidator((ClientRegistration)clientRegistration)});
        this.logoutTokenDecoderFactory = clientRegistration -> {
            String jwkSetUri = clientRegistration.getProviderDetails().getJwkSetUri();
            if (!StringUtils.hasText((String)jwkSetUri)) {
                OAuth2Error oauth2Error = new OAuth2Error("missing_signature_verifier", "Failed to find a Signature Verifier for Client Registration: '" + clientRegistration.getRegistrationId() + "'. Check to ensure you have configured the JwkSet URI.", null);
                throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
            }
            DefaultJOSEObjectTypeVerifier typeVerifier = new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{null, JOSEObjectType.JWT, new JOSEObjectType("logout+jwt")});
            NimbusJwtDecoder decoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwtProcessorCustomizer(arg_0 -> OidcBackChannelLogoutAuthenticationProvider.lambda$new$1((JOSEObjectTypeVerifier)typeVerifier, arg_0)).build();
            decoder.setJwtValidator((OAuth2TokenValidator)jwtValidator.apply((ClientRegistration)clientRegistration));
            decoder.setClaimSetConverter((Converter)OidcIdTokenDecoderFactory.createDefaultClaimTypeConverter());
            return decoder;
        };
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof OidcLogoutAuthenticationToken)) {
            return null;
        }
        OidcLogoutAuthenticationToken token = (OidcLogoutAuthenticationToken)authentication;
        String logoutToken = token.getLogoutToken();
        ClientRegistration registration = token.getClientRegistration();
        Jwt jwt = this.decode(registration, logoutToken);
        OidcLogoutToken oidcLogoutToken = OidcLogoutToken.withTokenValue((String)logoutToken).claims(claims -> claims.putAll(jwt.getClaims())).build();
        return new OidcBackChannelLogoutAuthentication(oidcLogoutToken, registration);
    }

    public boolean supports(Class<?> authentication) {
        return OidcLogoutAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Jwt decode(ClientRegistration registration, String token) {
        JwtDecoder logoutTokenDecoder = this.logoutTokenDecoderFactory.createDecoder((Object)registration);
        try {
            return logoutTokenDecoder.decode(token);
        }
        catch (BadJwtException failed) {
            OAuth2Error error = new OAuth2Error("invalid_request", failed.getMessage(), "https://openid.net/specs/openid-connect-backchannel-1_0.html#Validation");
            throw new OAuth2AuthenticationException(error, (Throwable)failed);
        }
        catch (Exception failed) {
            throw new AuthenticationServiceException(failed.getMessage(), (Throwable)failed);
        }
    }

    void setLogoutTokenDecoderFactory(JwtDecoderFactory<ClientRegistration> logoutTokenDecoderFactory) {
        Assert.notNull(logoutTokenDecoderFactory, (String)"logoutTokenDecoderFactory cannot be null");
        this.logoutTokenDecoderFactory = logoutTokenDecoderFactory;
    }

    private static /* synthetic */ void lambda$new$1(JOSEObjectTypeVerifier typeVerifier, ConfigurableJWTProcessor processor) {
        processor.setJWSTypeVerifier(typeVerifier);
    }
}

