/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

abstract class OncePerRequestFilter
implements Filter {
    public static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";
    private String alreadyFilteredAttributeName = this.getClass().getName().concat(".FILTERED");

    OncePerRequestFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean hasAlreadyFilteredAttribute;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("OncePerRequestFilter just supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(alreadyFilteredAttributeName) != null;
        if (hasAlreadyFilteredAttribute) {
            if (DispatcherType.ERROR.equals((Object)request.getDispatcherType())) {
                this.doFilterNestedErrorDispatch(httpRequest, httpResponse, filterChain);
                return;
            }
            filterChain.doFilter(request, response);
        } else {
            request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
            try {
                this.doFilterInternal(httpRequest, httpResponse, filterChain);
            }
            finally {
                request.removeAttribute(alreadyFilteredAttributeName);
            }
        }
    }

    protected String getAlreadyFilteredAttributeName() {
        return this.alreadyFilteredAttributeName;
    }

    protected void doFilterNestedErrorDispatch(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
    }

    protected abstract void doFilterInternal(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

