/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.checksums.ChecksumValidation;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksum;
import software.amazon.awssdk.core.internal.util.ClassLoaderHelper;
import software.amazon.awssdk.core.signer.NoOpSigner;
import software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions;
import software.amazon.awssdk.crt.io.StandardRetryOptions;
import software.amazon.awssdk.http.SdkHttpExecutionAttributes;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.DelegatingS3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;
import software.amazon.awssdk.services.s3.crt.S3CrtHttpConfiguration;
import software.amazon.awssdk.services.s3.crt.S3CrtRetryConfiguration;
import software.amazon.awssdk.services.s3.internal.checksums.ChecksumsEnabledValidator;
import software.amazon.awssdk.services.s3.internal.crt.CrtContentLengthOnlyAsyncFileRequestBody;
import software.amazon.awssdk.services.s3.internal.crt.CrtS3ExpressNoOpAuthScheme;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtAsyncClient;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtAsyncHttpClient;
import software.amazon.awssdk.services.s3.internal.crt.S3InternalSdkHttpExecutionAttribute;
import software.amazon.awssdk.services.s3.internal.crt.S3NativeClientConfiguration;
import software.amazon.awssdk.services.s3.internal.multipart.CopyObjectHelper;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressUtils;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3CrtAsyncClient
extends DelegatingS3AsyncClient
implements S3CrtAsyncClient {
    public static final ExecutionAttribute<Path> OBJECT_FILE_PATH = new ExecutionAttribute("objectFilePath");
    private static final String CRT_CLIENT_CLASSPATH = "software.amazon.awssdk.crt.s3.S3Client";
    private final CopyObjectHelper copyObjectHelper;

    private DefaultS3CrtAsyncClient(DefaultS3CrtClientBuilder builder) {
        super(DefaultS3CrtAsyncClient.initializeS3AsyncClient(builder));
        long partSizeInBytes = builder.minimalPartSizeInBytes == null ? 0x800000L : builder.minimalPartSizeInBytes;
        long thresholdInBytes = builder.thresholdInBytes == null ? partSizeInBytes : builder.thresholdInBytes;
        this.copyObjectHelper = new CopyObjectHelper((S3AsyncClient)this.delegate(), partSizeInBytes, thresholdInBytes);
    }

    @Override
    public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, Path sourcePath) {
        AwsRequestOverrideConfiguration overrideConfig = putObjectRequest.overrideConfiguration().map(config -> (AwsRequestOverrideConfiguration.Builder)config.toBuilder().putExecutionAttribute(OBJECT_FILE_PATH, (Object)sourcePath)).orElseGet(() -> (AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().putExecutionAttribute(OBJECT_FILE_PATH, (Object)sourcePath)).build();
        return this.putObject((PutObjectRequest)((Object)putObjectRequest.toBuilder().overrideConfiguration(overrideConfig).build()), (AsyncRequestBody)new CrtContentLengthOnlyAsyncFileRequestBody(sourcePath));
    }

    @Override
    public CompletableFuture<CopyObjectResponse> copyObject(CopyObjectRequest copyObjectRequest) {
        return this.copyObjectHelper.copyObject(copyObjectRequest);
    }

    private static S3AsyncClient initializeS3AsyncClient(DefaultS3CrtClientBuilder builder) {
        ClientOverrideConfiguration.Builder overrideConfigurationBuilder = ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)new NoOpSigner()).putExecutionAttribute(SdkExecutionAttribute.HTTP_RESPONSE_CHECKSUM_VALIDATION, (Object)ChecksumValidation.FORCE_SKIP).putExecutionAttribute(ChecksumsEnabledValidator.SKIP_MD5_TRAILING_CHECKSUM, (Object)true).retryStrategy(AwsRetryStrategy.doNotRetry()).addExecutionInterceptor((ExecutionInterceptor)new ValidateRequestInterceptor()).addExecutionInterceptor((ExecutionInterceptor)new AttachHttpAttributesExecutionInterceptor());
        if (builder.executionInterceptors != null) {
            builder.executionInterceptors.forEach(arg_0 -> ((ClientOverrideConfiguration.Builder)overrideConfigurationBuilder).addExecutionInterceptor(arg_0));
        }
        DefaultS3CrtClientBuilder finalBuilder = DefaultS3CrtAsyncClient.resolveChecksumConfiguration(builder);
        S3AsyncClientBuilder s3AsyncClientBuilder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().requestChecksumCalculation(finalBuilder.requestChecksumCalculation)).responseChecksumValidation(finalBuilder.responseChecksumValidation)).region(finalBuilder.region)).endpointOverride(finalBuilder.endpointOverride)).credentialsProvider(finalBuilder.credentialsProvider)).overrideConfiguration((ClientOverrideConfiguration)overrideConfigurationBuilder.build())).accelerate(finalBuilder.accelerate)).forcePathStyle(finalBuilder.forcePathStyle)).crossRegionAccessEnabled(finalBuilder.crossRegionAccessEnabled)).putAuthScheme(new CrtS3ExpressNoOpAuthScheme())).httpClientBuilder(DefaultS3CrtAsyncClient.initializeS3CrtAsyncHttpClient(finalBuilder))).disableS3ExpressSessionAuth(finalBuilder.disableS3ExpressSessionAuth);
        if (finalBuilder.futureCompletionExecutor != null) {
            s3AsyncClientBuilder.asyncConfiguration(b -> b.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)finalBuilder.futureCompletionExecutor));
        }
        return (S3AsyncClient)s3AsyncClientBuilder.build();
    }

    private static DefaultS3CrtClientBuilder resolveChecksumConfiguration(DefaultS3CrtClientBuilder builder) {
        Boolean checksumEnabledValidation = builder.checksumValidationEnabled;
        RequestChecksumCalculation requestChecksumCalculation = builder.requestChecksumCalculation;
        ResponseChecksumValidation responseChecksumValidation = builder.responseChecksumValidation;
        if (checksumEnabledValidation != null) {
            Validate.validState((requestChecksumCalculation == null && responseChecksumValidation == null ? 1 : 0) != 0, (String)"Checksum behavior has been configured on the S3CrtAsyncClientBuilder using the deprecated checksumEnabledValidation() AND one or both of requestChecksumCalculation() and responseChecksumValidation()", (Object[])new Object[0]);
            if (checksumEnabledValidation.booleanValue()) {
                requestChecksumCalculation = RequestChecksumCalculation.WHEN_SUPPORTED;
                responseChecksumValidation = ResponseChecksumValidation.WHEN_SUPPORTED;
            } else {
                requestChecksumCalculation = RequestChecksumCalculation.WHEN_REQUIRED;
                responseChecksumValidation = ResponseChecksumValidation.WHEN_REQUIRED;
            }
        }
        return builder.requestChecksumCalculation(requestChecksumCalculation).responseChecksumValidation(responseChecksumValidation);
    }

    private static S3CrtAsyncHttpClient.Builder initializeS3CrtAsyncHttpClient(DefaultS3CrtClientBuilder builder) {
        DefaultS3CrtAsyncClient.validateCrtInClassPath();
        Validate.isPositiveOrNull((Long)builder.readBufferSizeInBytes, (String)"initialReadBufferSizeInBytes");
        Validate.isPositiveOrNull((Integer)builder.maxConcurrency, (String)"maxConcurrency");
        Validate.isPositiveOrNull((Double)builder.targetThroughputInGbps, (String)"targetThroughputInGbps");
        Validate.isPositiveOrNull((Long)builder.minimalPartSizeInBytes, (String)"minimalPartSizeInBytes");
        Validate.isPositiveOrNull((Long)builder.thresholdInBytes, (String)"thresholdInBytes");
        S3NativeClientConfiguration.Builder nativeClientBuilder = S3NativeClientConfiguration.builder().targetThroughputInGbps(builder.targetThroughputInGbps).partSizeInBytes(builder.minimalPartSizeInBytes).maxConcurrency(builder.maxConcurrency).signingRegion(builder.region == null ? null : builder.region.id()).endpointOverride(builder.endpointOverride).credentialsProvider((IdentityProvider<? extends AwsCredentialsIdentity>)builder.credentialsProvider).readBufferSizeInBytes(builder.readBufferSizeInBytes).httpConfiguration(builder.httpConfiguration).thresholdInBytes(builder.thresholdInBytes).maxNativeMemoryLimitInBytes(builder.maxNativeMemoryLimitInBytes);
        if (builder.retryConfiguration != null) {
            nativeClientBuilder.standardRetryOptions(new StandardRetryOptions().withBackoffRetryOptions(new ExponentialBackoffRetryOptions().withMaxRetries((long)builder.retryConfiguration.numRetries().intValue())));
        }
        return S3CrtAsyncHttpClient.builder().s3ClientConfiguration(nativeClientBuilder.build());
    }

    private static void validateCrtInClassPath() {
        try {
            ClassLoaderHelper.loadClass((String)CRT_CLIENT_CLASSPATH, (boolean)false, (Class[])new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load classes from AWS Common Runtime (CRT) library.software.amazon.awssdk.crt:crt is a required dependency; make sure you have it on the classpath.", e);
        }
    }

    private static final class ValidateRequestInterceptor
    implements ExecutionInterceptor {
        private ValidateRequestInterceptor() {
        }

        public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
            ValidateRequestInterceptor.validateOverrideConfiguration(context.request());
        }

        private static void validateOverrideConfiguration(SdkRequest request) {
            if (!(request instanceof AwsRequest)) {
                return;
            }
            if (request.overrideConfiguration().isPresent()) {
                AwsRequestOverrideConfiguration overrideConfiguration = (AwsRequestOverrideConfiguration)request.overrideConfiguration().get();
                if (overrideConfiguration.signer().isPresent()) {
                    throw new UnsupportedOperationException("Request-level signer override is not supported");
                }
                if (overrideConfiguration.credentialsIdentityProvider().isPresent()) {
                    throw new UnsupportedOperationException("Request-level credentials override is not supported");
                }
                if (!CollectionUtils.isNullOrEmpty((Collection)overrideConfiguration.metricPublishers())) {
                    throw new UnsupportedOperationException("Request-level Metric Publishers override is not supported");
                }
                if (overrideConfiguration.apiCallAttemptTimeout().isPresent()) {
                    throw new UnsupportedOperationException("Request-level apiCallAttemptTimeout override is not supported");
                }
            }
        }
    }

    private static final class AttachHttpAttributesExecutionInterceptor
    implements ExecutionInterceptor {
        private AttachHttpAttributesExecutionInterceptor() {
        }

        public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
            SdkHttpExecutionAttributes existingHttpAttributes = (SdkHttpExecutionAttributes)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SDK_HTTP_EXECUTION_ATTRIBUTES);
            SdkHttpExecutionAttributes.Builder builder = existingHttpAttributes != null ? existingHttpAttributes.toBuilder() : SdkHttpExecutionAttributes.builder();
            SdkHttpExecutionAttributes attributes = builder.put(S3InternalSdkHttpExecutionAttribute.OPERATION_NAME, (Object)((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME))).put(S3InternalSdkHttpExecutionAttribute.HTTP_CHECKSUM, (Object)((HttpChecksum)executionAttributes.getAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM))).put(S3InternalSdkHttpExecutionAttribute.SIGNING_REGION, (Object)((Region)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION))).put(S3InternalSdkHttpExecutionAttribute.OBJECT_FILE_PATH, (Object)((Path)executionAttributes.getAttribute(OBJECT_FILE_PATH))).put(S3InternalSdkHttpExecutionAttribute.USE_S3_EXPRESS_AUTH, (Object)S3ExpressUtils.useS3ExpressAuthScheme(executionAttributes)).put(S3InternalSdkHttpExecutionAttribute.SIGNING_NAME, (Object)((String)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME))).put(S3InternalSdkHttpExecutionAttribute.REQUEST_CHECKSUM_CALCULATION, (Object)((RequestChecksumCalculation)executionAttributes.getAttribute(SdkInternalExecutionAttribute.REQUEST_CHECKSUM_CALCULATION))).put(S3InternalSdkHttpExecutionAttribute.RESPONSE_CHECKSUM_VALIDATION, (Object)((ResponseChecksumValidation)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESPONSE_CHECKSUM_VALIDATION))).build();
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM, null);
            executionAttributes.putAttribute(SdkExecutionAttribute.RESOLVED_CHECKSUM_SPECS, null);
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.SDK_HTTP_EXECUTION_ATTRIBUTES, (Object)attributes);
        }
    }

    public static final class DefaultS3CrtClientBuilder
    implements S3CrtAsyncClientBuilder {
        private Long readBufferSizeInBytes;
        private IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;
        private Region region;
        private Long minimalPartSizeInBytes;
        private Double targetThroughputInGbps;
        private Long maxNativeMemoryLimitInBytes;
        private Integer maxConcurrency;
        private URI endpointOverride;
        private Boolean checksumValidationEnabled;
        private RequestChecksumCalculation requestChecksumCalculation;
        private ResponseChecksumValidation responseChecksumValidation;
        private S3CrtHttpConfiguration httpConfiguration;
        private Boolean accelerate;
        private Boolean forcePathStyle;
        private List<ExecutionInterceptor> executionInterceptors;
        private S3CrtRetryConfiguration retryConfiguration;
        private boolean crossRegionAccessEnabled;
        private Long thresholdInBytes;
        private Executor futureCompletionExecutor;
        private Boolean disableS3ExpressSessionAuth;

        @Override
        public DefaultS3CrtClientBuilder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder minimumPartSizeInBytes(Long partSizeBytes) {
            this.minimalPartSizeInBytes = partSizeBytes;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder targetThroughputInGbps(Double targetThroughputInGbps) {
            this.targetThroughputInGbps = targetThroughputInGbps;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder maxNativeMemoryLimitInBytes(Long maxNativeMemoryLimitInBytes) {
            this.maxNativeMemoryLimitInBytes = maxNativeMemoryLimitInBytes;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder checksumValidationEnabled(Boolean checksumValidationEnabled) {
            this.checksumValidationEnabled = checksumValidationEnabled;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder requestChecksumCalculation(RequestChecksumCalculation requestChecksumCalculation) {
            this.requestChecksumCalculation = requestChecksumCalculation;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder responseChecksumValidation(ResponseChecksumValidation responseChecksumValidation) {
            this.responseChecksumValidation = responseChecksumValidation;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder initialReadBufferSizeInBytes(Long readBufferSizeInBytes) {
            this.readBufferSizeInBytes = readBufferSizeInBytes;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder httpConfiguration(S3CrtHttpConfiguration configuration) {
            this.httpConfiguration = configuration;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder accelerate(Boolean accelerate) {
            this.accelerate = accelerate;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder forcePathStyle(Boolean forcePathStyle) {
            this.forcePathStyle = forcePathStyle;
            return this;
        }

        @SdkTestInternalApi
        DefaultS3CrtClientBuilder addExecutionInterceptor(ExecutionInterceptor executionInterceptor) {
            if (this.executionInterceptors == null) {
                this.executionInterceptors = new ArrayList<ExecutionInterceptor>();
            }
            this.executionInterceptors.add(executionInterceptor);
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder retryConfiguration(S3CrtRetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder crossRegionAccessEnabled(Boolean crossRegionAccessEnabled) {
            this.crossRegionAccessEnabled = crossRegionAccessEnabled;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder thresholdInBytes(Long thresholdInBytes) {
            this.thresholdInBytes = thresholdInBytes;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder futureCompletionExecutor(Executor futureCompletionExecutor) {
            this.futureCompletionExecutor = futureCompletionExecutor;
            return this;
        }

        @Override
        public DefaultS3CrtClientBuilder disableS3ExpressSessionAuth(Boolean disableS3ExpressSessionAuth) {
            this.disableS3ExpressSessionAuth = disableS3ExpressSessionAuth;
            return this;
        }

        @Override
        public S3CrtAsyncClient build() {
            return new DefaultS3CrtAsyncClient(this);
        }
    }
}

