/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.index;

import com.xebialabs.deployit.plugin.stitch.dao.ContentRepository;
import com.xebialabs.deployit.plugin.stitch.dao.MacroParameterRepository;
import com.xebialabs.deployit.plugin.stitch.dao.NamespaceRepository;
import com.xebialabs.deployit.plugin.stitch.dao.RuleConditionRepository;
import com.xebialabs.deployit.plugin.stitch.dao.StitchDefinitionRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.MacroRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.RuleRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.parameters.MacroProcessorParameterRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.parameters.RuleProcessorParameterRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.processor.MacroProcessorRepository;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.processor.RuleProcessorRepository;
import com.xebialabs.deployit.plugin.stitch.model.Namespace;
import com.xebialabs.deployit.plugin.stitch.model.StitchDefinition;
import com.xebialabs.deployit.plugin.stitch.model.processor.MacroProcessor;
import com.xebialabs.deployit.plugin.stitch.model.specification.Macro;
import com.xebialabs.deployit.plugin.stitch.service.CacheService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.IndexCleaner;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001B\u000e\u001d\u00015B\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\u0005\u0004!\u0011!Q\u0001\n\tD\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011!I\bA!A!\u0002\u0013Q\b\"B?\u0001\t\u0003q\bbCA\r\u0001\u0001\u0007\t\u0019!C\u0001\u00037A1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00020!Y\u00111\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000f\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!a;\u0001\t\u0003\ni\u000fC\u0004\u0002t\u0002!\t%!>\u0003'\u0011+g-Y;mi&sG-\u001a=DY\u0016\fg.\u001a:\u000b\u0005uq\u0012!B5oI\u0016D(BA\u0010!\u0003\u0019)gnZ5oK*\u0011\u0011EI\u0001\bg\u0016\u0014h/[2f\u0015\t\u0019C%\u0001\u0004ti&$8\r\u001b\u0006\u0003K\u0019\na\u0001\u001d7vO&t'BA\u0014)\u0003!!W\r\u001d7ps&$(BA\u0015+\u0003%AXMY5bY\u0006\u00147OC\u0001,\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0006\u000e\u001d\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)d'D\u0001\u001d\u0013\t9DD\u0001\u0007J]\u0012,\u0007p\u00117fC:,'\u000f\u0005\u0002:}5\t!H\u0003\u0002<y\u0005)1\u000f\u001c45U*\tQ(\u0001\u0005he&T(\u0010\\3e\u0013\ty$HA\u0004M_\u001e<\u0017N\\4\u00025M$\u0018\u000e^2i\t\u00164\u0017N\\5uS>t'+\u001a9pg&$xN]=\u0011\u0005\t+U\"A\"\u000b\u0005\u0011\u0013\u0013a\u00013b_&\u0011ai\u0011\u0002\u001b'RLGo\u00195EK\u001aLg.\u001b;j_:\u0014V\r]8tSR|'/_\u0001\u000feVdWMU3q_NLGo\u001c:z!\tIE*D\u0001K\u0015\tY5)A\u0002ka\u0006L!!\u0014&\u0003\u001dI+H.\u001a*fa>\u001c\u0018\u000e^8ss\u00069\"/\u001e7f\u0007>tG-\u001b;j_:\u0014V\r]8tSR|'/\u001f\t\u0003\u0005BK!!U\"\u0003/I+H.Z\"p]\u0012LG/[8o%\u0016\u0004xn]5u_JL\u0018aD7bGJ|'+\u001a9pg&$xN]=\u0011\u0005%#\u0016BA+K\u0005=i\u0015m\u0019:p%\u0016\u0004xn]5u_JL\u0018\u0001G7bGJ|\u0007+\u0019:b[\u0016$XM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011!\tW\u0005\u00033\u000e\u0013\u0001$T1de>\u0004\u0016M]1nKR,'OU3q_NLGo\u001c:z\u0003]\u0011X\u000f\\3Qe>\u001cWm]:peJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002]?6\tQL\u0003\u0002_\u0015\u0006I\u0001O]8dKN\u001cxN]\u0005\u0003Av\u0013qCU;mKB\u0013xnY3tg>\u0014(+\u001a9pg&$xN]=\u0002AI,H.\u001a)s_\u000e,7o]8s!\u0006\u0014\u0018-\\3uKJ\u0014V\r]8tSR|'/\u001f\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K*\u000b!\u0002]1sC6,G/\u001a:t\u0013\t9GM\u0001\u0011Sk2,\u0007K]8dKN\u001cxN\u001d)be\u0006lW\r^3s%\u0016\u0004xn]5u_JL\u0018\u0001G7bGJ|\u0007K]8dKN\u001cxN\u001d*fa>\u001c\u0018\u000e^8ssB\u0011AL[\u0005\u0003Wv\u0013\u0001$T1de>\u0004&o\\2fgN|'OU3q_NLGo\u001c:z\u0003\u0005j\u0017m\u0019:p!J|7-Z:t_J\u0004\u0016M]1nKR,'OU3q_NLGo\u001c:z!\t\u0019g.\u0003\u0002pI\n\tS*Y2s_B\u0013xnY3tg>\u0014\b+\u0019:b[\u0016$XM\u001d*fa>\u001c\u0018\u000e^8ss\u0006\tR.Y2s_\u000e\u000b7\r[3TKJ4\u0018nY3\u0011\u0005I\u001cX\"\u0001\u0011\n\u0005Q\u0004#\u0001D\"bG\",7+\u001a:wS\u000e,\u0017a\u00058b[\u0016\u001c\b/Y2f%\u0016\u0004xn]5u_JL\bC\u0001\"x\u0013\tA8IA\nOC6,7\u000f]1dKJ+\u0007o\\:ji>\u0014\u00180A\td_:$XM\u001c;SKB|7/\u001b;pef\u0004\"AQ>\n\u0005q\u001c%!E\"p]R,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"\u0012d`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018A\u0011Q\u0007\u0001\u0005\u0006\u00016\u0001\r!\u0011\u0005\u0006\u000f6\u0001\r\u0001\u0013\u0005\u0006\u001d6\u0001\ra\u0014\u0005\u0006%6\u0001\ra\u0015\u0005\u0006-6\u0001\ra\u0016\u0005\u000656\u0001\ra\u0017\u0005\u0006C6\u0001\rA\u0019\u0005\u0006Q6\u0001\r!\u001b\u0005\u0006Y6\u0001\r!\u001c\u0005\u0006a6\u0001\r!\u001d\u0005\u0006k6\u0001\rA\u001e\u0005\u0006s6\u0001\rA_\u0001\u000eK:$\u0018\u000e^=NC:\fw-\u001a:\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0002(\u00059!.Y6beR\f\u0017\u0002BA\u0016\u0003C\u0011Q\"\u00128uSRLX*\u00198bO\u0016\u0014\u0018!E3oi&$\u00180T1oC\u001e,'o\u0018\u0013fcR!\u0011\u0011GA\u001c!\ry\u00131G\u0005\u0004\u0003k\u0001$\u0001B+oSRD\u0011\"!\u000f\u0010\u0003\u0003\u0005\r!!\b\u0002\u0007a$\u0013'\u0001\bf]RLG/_'b]\u0006<WM\u001d\u0011)\u0007A\ty\u0004\u0005\u0003\u0002 \u0005\u0005\u0013\u0002BA\"\u0003C\u0011!\u0003U3sg&\u001cH/\u001a8dK\u000e{g\u000e^3yi\u0006\u0019B-\u001a7fi\u0016\u001cF/\u001b;dQ\u000e{g\u000e^3oiR1\u0011\u0011GA%\u0003'Bq!a\u0013\u0012\u0001\u0004\ti%\u0001\u0005t_V\u00148-Z%e!\ry\u0013qJ\u0005\u0004\u0003#\u0002$aA%oi\"9\u0011QK\tA\u0002\u0005]\u0013A\u00032sC:\u001c\u0007NT1nKB!\u0011\u0011LA4\u001d\u0011\tY&a\u0019\u0011\u0007\u0005u\u0003'\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u0017\u0002\rq\u0012xn\u001c;?\u0013\r\t)\u0007M\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00141\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0004'\u0001\feK2,G/Z*uSR\u001c\u0007\u000eR3gS:LG/[8o)\u0019\t\t$!\u001d\u0002t!9\u00111\n\nA\u0002\u00055\u0003bBA+%\u0001\u0007\u0011qK\u0001\fI\u0016dW\r^3Sk2,7\u000f\u0006\u0004\u00022\u0005e\u00141\u0010\u0005\b\u0003\u0017\u001a\u0002\u0019AA'\u0011\u001d\t)f\u0005a\u0001\u0003/\nA\u0002Z3mKR,W*Y2s_N$b!!\r\u0002\u0002\u0006\r\u0005bBA&)\u0001\u0007\u0011Q\n\u0005\b\u0003+\"\u0002\u0019AA,\u0003A!W\r\\3uKB\u0013xnY3tg>\u00148\u000f\u0006\u0004\u00022\u0005%\u00151\u0012\u0005\b\u0003\u0017*\u0002\u0019AA'\u0011\u001d\t)&\u0006a\u0001\u0003/\nqb\u00197fC:t\u0015-\\3ta\u0006\u001cWm\u001d\u000b\u0005\u0003c\t\t\nC\u0004\u0002\u0014Z\u0001\r!!&\u0002\u00159\fW.Z:qC\u000e,7\u000f\u0005\u0004\u0002Z\u0005]\u00151T\u0005\u0005\u00033\u000bYGA\u0002TKR\u0004B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0004\u0003C\u0013\u0013!B7pI\u0016d\u0017\u0002BAS\u0003?\u0013\u0011BT1nKN\u0004\u0018mY3\u0002\u0015\rdW-\u00198DC\u000eDW\r\u0006\u0004\u00022\u0005-\u0016Q\u001a\u0005\b\u0003[;\u0002\u0019AAX\u0003\u0019i\u0017m\u0019:pgB1\u0011\u0011WA^\u0003\u0003tA!a-\u00028:!\u0011QLA[\u0013\u0005\t\u0014bAA]a\u00059\u0001/Y2lC\u001e,\u0017\u0002BA_\u0003\u007f\u0013A\u0001T5ti*\u0019\u0011\u0011\u0018\u0019\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bTA!a2\u0002 \u0006i1\u000f]3dS\u001aL7-\u0019;j_:LA!a3\u0002F\n)Q*Y2s_\"9\u0011qZ\fA\u0002\u0005E\u0017aD7bGJ|\u0007K]8dKN\u001cxN]:\u0011\r\u0005E\u00161XAj!\u0011\t).!7\u000e\u0005\u0005]'b\u00010\u0002 &!\u00111\\Al\u00059i\u0015m\u0019:p!J|7-Z:t_J\fQa\u00197fC:$b!!\r\u0002b\u0006\r\bbBA&1\u0001\u0007\u0011Q\n\u0005\b\u0003+B\u0002\u0019AAs!\u0015y\u0013q]A,\u0013\r\tI\u000f\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001d\rdW-\u00198G_J\u001cv.\u001e:dKR1\u0011\u0011GAx\u0003cDq!a\u0013\u001a\u0001\u0004\ti\u0005C\u0004\u0002Ve\u0001\r!!:\u0002\u001fI,Wn\u001c<f\r>\u00148k\\;sG\u0016$B!!\r\u0002x\"9\u00111\n\u000eA\u0002\u00055\u0003f\u0001\u0001\u0002|B!\u0011Q B\u0006\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011AC:uKJ,w\u000e^=qK*!!Q\u0001B\u0004\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'B\u0001B\u0005\u0003\ry'oZ\u0005\u0005\u0005\u001b\tyPA\u0004TKJ4\u0018nY3)\u0007\u0001\u0011\t\u0002\u0005\u0003\u0003\u0014\t\u0005RB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0003\u001c\tu\u0011a\u00024bGR|'/\u001f\u0006\u0005\u0005?\u0011\u0019!A\u0003cK\u0006t7/\u0003\u0003\u0003$\tU!!C!vi><\u0018N]3e\u0001")
public class DefaultIndexCleaner
implements IndexCleaner,
Logging {
    private final StitchDefinitionRepository stitchDefinitionRepository;
    private final RuleRepository ruleRepository;
    private final RuleConditionRepository ruleConditionRepository;
    private final MacroRepository macroRepository;
    private final MacroParameterRepository macroParameterRepository;
    private final RuleProcessorRepository ruleProcessorRepository;
    private final RuleProcessorParameterRepository ruleProcessorParameterRepository;
    private final MacroProcessorRepository macroProcessorRepository;
    private final MacroProcessorParameterRepository macroProcessorParameterRepository;
    private final CacheService macroCacheService;
    private final NamespaceRepository namespaceRepository;
    private final ContentRepository contentRepository;
    @PersistenceContext
    private EntityManager entityManager;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultIndexCleaner defaultIndexCleaner = this;
        synchronized (defaultIndexCleaner) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public EntityManager entityManager() {
        return this.entityManager;
    }

    public void entityManager_$eq(EntityManager x$1) {
        this.entityManager = x$1;
    }

    private void deleteStitchContent(int sourceId, String branchName) {
        this.contentRepository.deleteBySourceIdAndBranchName(sourceId, branchName);
    }

    private void deleteStitchDefinition(int sourceId, String branchName) {
        this.stitchDefinitionRepository.deleteBySourceIdAndBranchName(sourceId, branchName);
    }

    private void deleteRules(int sourceId, String branchName) {
        this.ruleConditionRepository.deleteByRule_BranchNameAndSourceId(branchName, sourceId);
        this.ruleRepository.deleteBySourceIdAndBranchName(sourceId, branchName);
    }

    private void deleteMacros(int sourceId, String branchName) {
        this.macroParameterRepository.deleteByMacro_BranchNameAndSourceId(branchName, sourceId);
        this.macroRepository.deleteBySourceIdAndBranchName(sourceId, branchName);
    }

    private void deleteProcessors(int sourceId, String branchName) {
        this.ruleProcessorParameterRepository.deleteByProcessor_Rule_BranchNameAndSourceId(branchName, sourceId);
        this.ruleProcessorRepository.deleteByRule_BranchNameAndSourceId(branchName, sourceId);
        this.macroProcessorParameterRepository.deleteByProcessor_Macro_BranchNameAndSourceId(branchName, sourceId);
        this.macroProcessorRepository.deleteByMacro_BranchNameAndSourceId(branchName, sourceId);
    }

    private void cleanNamespaces(Set<Namespace> namespaces) {
        ((IterableOnceOps)namespaces.filterNot((Function1 & Serializable)namespace -> BoxesRunTime.boxToBoolean((boolean)this.stitchDefinitionRepository.existsByNamespace(namespace)))).foreach((Function1 & Serializable)namespace -> {
            this.namespaceRepository.remove(namespace);
            return BoxedUnit.UNIT;
        });
    }

    public void cleanCache(List<Macro> macros, List<MacroProcessor> macroProcessors) {
        macros.foreach((Function1 & Serializable)m -> {
            this.macroCacheService.removeMacro((Tuple2<String, String>)new Tuple2((Object)m.namespace().name(), (Object)m.name()));
            return BoxedUnit.UNIT;
        });
        macroProcessors.foreach((Function1 & Serializable)p -> {
            this.macroCacheService.removeMacroProcessors(p.id());
            return BoxedUnit.UNIT;
        });
    }

    private void clean(int sourceId, Option<String> branchName) {
        List affectedMacros = CollectionConverters$.MODULE$.ListHasAsScala(this.macroRepository.findAllBySourceIdAndBranchName(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))).asScala().toList();
        List<StitchDefinition> definitions = this.stitchDefinitionRepository.getBySourceIdAndBranchName(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Set affectedNamespaces = definitions.map((Function1 & Serializable)x$2 -> x$2.namespace()).toSet();
        List affectedMacroProcessors = CollectionConverters$.MODULE$.ListHasAsScala(this.macroProcessorRepository.findByMacro_BranchNameAndSourceId((String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), sourceId)).asScala().toList();
        this.deleteProcessors(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.deleteRules(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.deleteMacros(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.deleteStitchDefinition(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.deleteStitchContent(sourceId, (String)branchName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.cleanNamespaces((Set<Namespace>)affectedNamespaces);
        this.cleanCache((List<Macro>)affectedMacros, (List<MacroProcessor>)affectedMacroProcessors);
    }

    @Override
    public void cleanForSource(int sourceId, Option<String> branchName) {
        this.debug((Function0<Object>)(Function0 & Serializable)() -> "Trying to clean data for source: " + sourceId);
        this.clean(sourceId, branchName);
        this.entityManager().flush();
    }

    @Override
    public void removeForSource(int sourceId) {
        this.debug((Function0<Object>)(Function0 & Serializable)() -> "Trying to clean data for source: " + sourceId);
        this.stitchDefinitionRepository.getDistinctBranchNamesForSourceId(sourceId).foreach((Function1 & Serializable)branchName -> {
            this.clean(sourceId, (Option<String>)Option$.MODULE$.apply((Object)branchName));
            return BoxedUnit.UNIT;
        });
        this.entityManager().flush();
    }

    public DefaultIndexCleaner(StitchDefinitionRepository stitchDefinitionRepository, RuleRepository ruleRepository, RuleConditionRepository ruleConditionRepository, MacroRepository macroRepository, MacroParameterRepository macroParameterRepository, RuleProcessorRepository ruleProcessorRepository, RuleProcessorParameterRepository ruleProcessorParameterRepository, MacroProcessorRepository macroProcessorRepository, MacroProcessorParameterRepository macroProcessorParameterRepository, CacheService macroCacheService, NamespaceRepository namespaceRepository, ContentRepository contentRepository) {
        this.stitchDefinitionRepository = stitchDefinitionRepository;
        this.ruleRepository = ruleRepository;
        this.ruleConditionRepository = ruleConditionRepository;
        this.macroRepository = macroRepository;
        this.macroParameterRepository = macroParameterRepository;
        this.ruleProcessorRepository = ruleProcessorRepository;
        this.ruleProcessorParameterRepository = ruleProcessorParameterRepository;
        this.macroProcessorRepository = macroProcessorRepository;
        this.macroProcessorParameterRepository = macroProcessorParameterRepository;
        this.macroCacheService = macroCacheService;
        this.namespaceRepository = namespaceRepository;
        this.contentRepository = contentRepository;
        Logging.$init$((Logging)this);
    }
}

