/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import ai.digital.deploy.sql.model.Report;
import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.StatusOverviewReportLine;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.util.Collection;
import org.joda.time.DateTime;

public class DeploymentsPercentageWidgetData
extends DashboardWidgetBase {
    public DeploymentsPercentageWidgetData(TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public Report getReport(DateTime beginDate, DateTime endDate) {
        Collection searchResult = this.taskArchive.statusOverview(beginDate, endDate);
        return this.transformResult(searchResult);
    }

    private Report transformResult(Collection<StatusOverviewReportLine> searchResult) {
        Report report = new Report();
        if (searchResult.isEmpty()) {
            return report;
        }
        ReportLine line = report.addLine();
        int total = searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.TOTAL.name())).map(StatusOverviewReportLine::amount).findFirst().orElse(0);
        line.addValue("perOfSuccessfulDeployments", (Object)searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.SUCCESS.name())).map(sr -> {
            line.addValue("noOfSuccessfulDeployments", (Object)Integer.toString(sr.amount()));
            return DeploymentsPercentageWidgetData.getFormattedPercentage(sr.amount(), total);
        }).findFirst().orElse(ZERO));
        line.addValue("perOfAbortedDeployments", (Object)searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.ABORTED.name())).map(sr -> {
            line.addValue("noOfAbortedDeployments", (Object)Integer.toString(sr.amount()));
            return DeploymentsPercentageWidgetData.getFormattedPercentage(sr.amount(), total);
        }).findFirst().orElse(ZERO));
        line.addValue("perOfFailedDeployments", (Object)searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.FAILED.name())).map(sr -> {
            line.addValue("noOfFailedDeployments", (Object)Integer.toString(sr.amount()));
            return DeploymentsPercentageWidgetData.getFormattedPercentage(sr.amount(), total);
        }).findFirst().orElse(ZERO));
        line.addValue("perOfRollbacks", (Object)searchResult.stream().filter(sr -> sr.executionState().equals(DeploymentResult.ROLLBACK.name())).map(sr -> {
            line.addValue("noOfRollbacks", (Object)Integer.toString(sr.amount()));
            return DeploymentsPercentageWidgetData.getFormattedPercentage(sr.amount(), total);
        }).findFirst().orElse(ZERO));
        return report;
    }
}

