/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.LicenseService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import org.springframework.web.filter.OncePerRequestFilter;

public class LicenseValidationFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(LicenseValidationFilter.class);
    public static final String WHITE_LISTED_PATHS = "whiteListedPaths";
    @Autowired
    private LicenseService licenseService;
    private HashSet<String> whiteList = new HashSet();

    protected void initFilterBean() {
        logger.trace("Added LicenseCheckFilter to the mix.");
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)((Object)this));
        String whiteListedPathsString = Optional.ofNullable(this.getFilterConfig().getInitParameter(WHITE_LISTED_PATHS)).orElse("");
        this.whiteList = new HashSet(Strings.split((String)whiteListedPathsString, (String)","));
    }

    public void afterPropertiesSet() {
    }

    public void setLicenseService(LicenseService licenseService) {
        Checks.checkNotNull((Object)licenseService, (String)"LicenseCheckFilter: Could not find license check service");
        this.licenseService = licenseService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        License license = this.licenseService.getLicense();
        String pathInfo = request.getPathInfo();
        if (this.whiteList.contains(pathInfo)) {
            logger.debug("Path {} is white listed", (Object)pathInfo);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (license.isDummyLicense() || !this.licenseIsValid()) {
            logger.debug("This license is invalid: {}", (Object)license);
            response.sendError(402, "License expired");
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean licenseIsValid() {
        try {
            this.licenseService.validate();
        }
        catch (LicenseViolationException e) {
            logger.debug("Invalid license:", (Throwable)e);
            return false;
        }
        return true;
    }

    public void destroy() {
    }
}

