/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.sql.results.spi.RowTransformer;

public class RowTransformerCheckingImpl<R>
implements RowTransformer<R> {
    private final Class<R> type;

    public RowTransformerCheckingImpl(Class<R> type) {
        this.type = type;
    }

    @Override
    public R transformRow(Object[] row) {
        Object result = row[0];
        if (result == null || this.type.isInstance(result)) {
            return (R)result;
        }
        throw new QueryTypeMismatchException("Result type is '" + this.type.getSimpleName() + "' but the query returned a '" + result.getClass().getSimpleName() + "'");
    }

    @Override
    public int determineNumberOfResultElements(int rawElementCount) {
        return 1;
    }
}

