/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.prevayler.Clock;
import org.prevayler.Prevayler;
import org.prevayler.foundation.monitor.Monitor;
import org.prevayler.foundation.monitor.SimpleMonitor;
import org.prevayler.foundation.network.OldNetworkImpl;
import org.prevayler.foundation.serialization.JavaSerializer;
import org.prevayler.foundation.serialization.Serializer;
import org.prevayler.foundation.serialization.XStreamSerializer;
import org.prevayler.implementation.PrevaylerDirectory;
import org.prevayler.implementation.PrevaylerImpl;
import org.prevayler.implementation.clock.MachineClock;
import org.prevayler.implementation.journal.Journal;
import org.prevayler.implementation.journal.PersistentJournal;
import org.prevayler.implementation.journal.TransientJournal;
import org.prevayler.implementation.publishing.CentralPublisher;
import org.prevayler.implementation.publishing.TransactionPublisher;
import org.prevayler.implementation.replication.ClientPublisher;
import org.prevayler.implementation.replication.ServerListener;
import org.prevayler.implementation.snapshot.GenericSnapshotManager;
import org.prevayler.implementation.snapshot.NullSnapshotManager;

public class PrevaylerFactory<P> {
    private P _prevalentSystem;
    private Clock _clock;
    private boolean _transactionDeepCopyMode = true;
    private boolean _transientMode;
    private String _prevalenceDirectory;
    private NullSnapshotManager<P> _nullSnapshotManager;
    private long _journalSizeThreshold;
    private long _journalAgeThreshold;
    private boolean _journalDiskSync = true;
    private int _serverPort = -1;
    private String _remoteServerIpAddress;
    private int _remoteServerPort;
    public static final int DEFAULT_REPLICATION_PORT = 8756;
    private Monitor _monitor;
    private Serializer _journalSerializer;
    private String _journalSuffix;
    private Map _snapshotSerializers = new HashMap();
    private String _primarySnapshotSuffix;

    public static <P> Prevayler<P> createPrevayler(P newPrevalentSystem, String prevalenceBase) throws Exception {
        PrevaylerFactory<P> factory = new PrevaylerFactory<P>();
        factory.configurePrevalentSystem(newPrevalentSystem);
        factory.configurePrevalenceDirectory(prevalenceBase);
        return factory.create();
    }

    public static <P> Prevayler<P> createPrevayler(P newPrevalentSystem) throws Exception {
        return PrevaylerFactory.createPrevayler(newPrevalentSystem, "PrevalenceBase");
    }

    public static <P> Prevayler<P> createCheckpointPrevayler(P newPrevalentSystem, String snapshotDirectory) {
        PrevaylerFactory<P> factory = new PrevaylerFactory<P>();
        factory.configurePrevalentSystem(newPrevalentSystem);
        factory.configurePrevalenceDirectory(snapshotDirectory);
        factory.configureTransientMode(true);
        try {
            return factory.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <P> Prevayler<P> createTransientPrevayler(P newPrevalentSystem) {
        PrevaylerFactory<P> factory = new PrevaylerFactory<P>();
        factory.configurePrevalentSystem(newPrevalentSystem);
        super.configureNullSnapshotManager(new NullSnapshotManager(newPrevalentSystem, "Transient Prevaylers are unable to take snapshots."));
        factory.configureTransientMode(true);
        try {
            return factory.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <P> Prevayler<P> createTransientPrevayler(P newPrevalentSystem, String snapshotDirectory) {
        return PrevaylerFactory.createCheckpointPrevayler(newPrevalentSystem, snapshotDirectory);
    }

    private Clock clock() {
        return this._clock != null ? this._clock : new MachineClock();
    }

    public void configurePrevalentSystem(P newPrevalentSystem) {
        this._prevalentSystem = newPrevalentSystem;
    }

    public void configurePrevalenceDirectory(String prevalenceDirectory) {
        this._prevalenceDirectory = prevalenceDirectory;
    }

    public void configureTransactionDeepCopy(boolean transactionDeepCopyMode) {
        this._transactionDeepCopyMode = transactionDeepCopyMode;
    }

    public void configureClock(Clock clock) {
        this._clock = clock;
    }

    public void configureMonitor(Monitor monitor) {
        this._monitor = monitor;
    }

    public void configureTransientMode(boolean transientMode) {
        this._transientMode = transientMode;
    }

    public void configureReplicationClient(String remoteServerIpAddress, int remoteServerPort) {
        this._remoteServerIpAddress = remoteServerIpAddress;
        this._remoteServerPort = remoteServerPort;
    }

    public void configureReplicationServer(int port) {
        this._serverPort = port;
    }

    private void configureNullSnapshotManager(NullSnapshotManager<P> snapshotManager) {
        this._nullSnapshotManager = snapshotManager;
    }

    public void configureJournalFileSizeThreshold(long sizeInBytes) {
        this._journalSizeThreshold = sizeInBytes;
    }

    public void configureJournalFileAgeThreshold(long ageInMilliseconds) {
        this._journalAgeThreshold = ageInMilliseconds;
    }

    public void configureJournalDiskSync(boolean journalDiskSync) {
        this._journalDiskSync = journalDiskSync;
    }

    public void configureJournalSerializer(JavaSerializer serializer) {
        this.configureJournalSerializer("journal", (Serializer)serializer);
    }

    public void configureJournalSerializer(XStreamSerializer serializer) {
        this.configureJournalSerializer("xstreamjournal", (Serializer)serializer);
    }

    public void configureJournalSerializer(String suffix, Serializer serializer) {
        PrevaylerDirectory.checkValidJournalSuffix((String)suffix);
        if (this._journalSerializer != null) {
            throw new IllegalStateException("Read the javadoc to this method.");
        }
        this._journalSerializer = serializer;
        this._journalSuffix = suffix;
    }

    public void configureSnapshotSerializer(JavaSerializer serializer) {
        this.configureSnapshotSerializer("snapshot", (Serializer)serializer);
    }

    public void configureSnapshotSerializer(XStreamSerializer serializer) {
        this.configureSnapshotSerializer("xstreamsnapshot", (Serializer)serializer);
    }

    public void configureSnapshotSerializer(String suffix, Serializer serializer) {
        PrevaylerDirectory.checkValidSnapshotSuffix((String)suffix);
        this._snapshotSerializers.put(suffix, serializer);
        if (this._primarySnapshotSuffix == null) {
            this._primarySnapshotSuffix = suffix;
        }
    }

    public Prevayler<P> create() throws Exception {
        GenericSnapshotManager<P> snapshotManager = this.snapshotManager();
        TransactionPublisher publisher = this.publisher(snapshotManager);
        if (this._serverPort != -1) {
            new ServerListener(publisher, new OldNetworkImpl(), this._serverPort);
        }
        return new PrevaylerImpl(snapshotManager, publisher, this.journalSerializer(), this._transactionDeepCopyMode);
    }

    private String prevalenceDirectory() {
        return this._prevalenceDirectory != null ? this._prevalenceDirectory : "Prevalence";
    }

    private P prevalentSystem() {
        if (this._prevalentSystem == null) {
            throw new IllegalStateException("The prevalent system must be configured.");
        }
        return this._prevalentSystem;
    }

    private TransactionPublisher publisher(GenericSnapshotManager<P> snapshotManager) throws IOException {
        if (this._remoteServerIpAddress != null) {
            return new ClientPublisher(new OldNetworkImpl(), this._remoteServerIpAddress, this._remoteServerPort);
        }
        return new CentralPublisher(this.clock(), this.journal());
    }

    private Journal journal() throws IOException {
        if (this._transientMode) {
            return new TransientJournal();
        }
        PrevaylerDirectory directory = new PrevaylerDirectory(this.prevalenceDirectory());
        return new PersistentJournal(directory, this._journalSizeThreshold, this._journalAgeThreshold, this._journalDiskSync, this.journalSuffix(), this.monitor());
    }

    private Serializer journalSerializer() {
        if (this._journalSerializer != null) {
            return this._journalSerializer;
        }
        return new JavaSerializer();
    }

    private String journalSuffix() {
        return this._journalSuffix != null ? this._journalSuffix : "journal";
    }

    private GenericSnapshotManager<P> snapshotManager() throws Exception {
        if (this._nullSnapshotManager != null) {
            return this._nullSnapshotManager;
        }
        PrevaylerDirectory directory = new PrevaylerDirectory(this.prevalenceDirectory());
        if (!this._snapshotSerializers.isEmpty()) {
            return new GenericSnapshotManager(this._snapshotSerializers, this._primarySnapshotSuffix, this.prevalentSystem(), directory, this.journalSerializer());
        }
        String snapshotSuffix = "snapshot";
        JavaSerializer snapshotSerializer = new JavaSerializer();
        return new GenericSnapshotManager(Collections.singletonMap(snapshotSuffix, snapshotSerializer), snapshotSuffix, this.prevalentSystem(), directory, this.journalSerializer());
    }

    private Monitor monitor() {
        return this._monitor != null ? this._monitor : new SimpleMonitor(System.err);
    }
}

