/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.mapping;

import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.context.KeyValueMappingContext;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.vault.repository.mapping.BasicVaultPersistentEntity;
import org.springframework.vault.repository.mapping.SimpleClassNameKeySpaceResolver;
import org.springframework.vault.repository.mapping.VaultPersistentEntity;
import org.springframework.vault.repository.mapping.VaultPersistentProperty;

public class VaultMappingContext
extends KeyValueMappingContext<VaultPersistentEntity<?>, VaultPersistentProperty> {
    @Nullable
    private KeySpaceResolver fallbackKeySpaceResolver;

    public KeySpaceResolver getFallbackKeySpaceResolver() {
        return this.fallbackKeySpaceResolver == null ? SimpleClassNameKeySpaceResolver.INSTANCE : this.fallbackKeySpaceResolver;
    }

    public void setFallbackKeySpaceResolver(KeySpaceResolver fallbackKeySpaceResolver) {
        this.fallbackKeySpaceResolver = fallbackKeySpaceResolver;
    }

    protected <T> VaultPersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new BasicVaultPersistentEntity<T>(typeInformation, this.fallbackKeySpaceResolver);
    }

    protected VaultPersistentProperty createPersistentProperty(Property property, VaultPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new VaultPersistentProperty(property, (PersistentEntity<?, VaultPersistentProperty>)owner, simpleTypeHolder);
    }
}

