/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.functions.CheckedBiFunction;
import io.github.resilience4j.core.functions.CheckedFunction;
import io.github.resilience4j.core.functions.CheckedSupplier;
import java.util.List;
import java.util.function.Predicate;

public class CheckedFunctionUtils {
    private CheckedFunctionUtils() {
    }

    public static <T> CheckedSupplier<T> recover(CheckedSupplier<T> supplier, CheckedFunction<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable throwable) {
                return exceptionHandler.apply(throwable);
            }
        };
    }

    public static <T, R> CheckedSupplier<R> andThen(CheckedSupplier<T> supplier, CheckedBiFunction<T, Throwable, R> handler) {
        return () -> {
            try {
                return handler.apply(supplier.get(), null);
            }
            catch (Throwable throwable) {
                return handler.apply(null, throwable);
            }
        };
    }

    public static <T> CheckedSupplier<T> recover(CheckedSupplier<T> supplier, Predicate<T> resultPredicate, CheckedFunction<T, T> resultHandler) {
        return () -> {
            Object result = supplier.get();
            if (resultPredicate.test(result)) {
                return resultHandler.apply(result);
            }
            return result;
        };
    }

    public static <T> CheckedSupplier<T> recover(CheckedSupplier<T> supplier, List<Class<? extends Throwable>> exceptionTypes, CheckedFunction<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                if (exceptionTypes.stream().anyMatch(exceptionType -> exceptionType.isAssignableFrom(exception.getClass()))) {
                    return exceptionHandler.apply(exception);
                }
                throw exception;
            }
        };
    }

    public static <X extends Throwable, T> CheckedSupplier<T> recover(CheckedSupplier<T> supplier, Class<X> exceptionType, CheckedFunction<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Throwable throwable) {
                if (exceptionType.isAssignableFrom(throwable.getClass())) {
                    return exceptionHandler.apply(throwable);
                }
                throw throwable;
            }
        };
    }
}

