/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.SparseBitSet;
import org.infinispan.protostream.schema.CommentContainer;
import org.infinispan.protostream.schema.Enum;
import org.infinispan.protostream.schema.EnumContainer;
import org.infinispan.protostream.schema.Field;
import org.infinispan.protostream.schema.FieldContainer;
import org.infinispan.protostream.schema.GenericContainer;
import org.infinispan.protostream.schema.Map;
import org.infinispan.protostream.schema.MessageContainer;
import org.infinispan.protostream.schema.OneOf;
import org.infinispan.protostream.schema.OptionContainer;
import org.infinispan.protostream.schema.ReservedContainer;
import org.infinispan.protostream.schema.ReservedNumbers;
import org.infinispan.protostream.schema.Schema;
import org.infinispan.protostream.schema.Type;

public class Message {
    private final String name;
    private final String fullName;
    private final Map<String, Enum> nestedEnums;
    private final Map<String, Message> nestedMessages;
    private final Map<String, Field> fields;
    private final List<OneOf> oneOfs;
    private final SparseBitSet reservedNumbers;
    private final Set<String> reservedNames;
    private final Map<String, Object> options;
    private final List<String> comments;

    Message(Builder builder) {
        this.name = builder.name;
        this.fullName = builder.getFullName();
        this.nestedEnums = builder.nestedEnums.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((Enum.Builder)e.getValue()).create()));
        this.nestedMessages = builder.nestedMessages.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((Builder)e.getValue()).create()));
        AtomicInteger autoNumber = new AtomicInteger(1);
        this.fields = builder.fields.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((Field.Builder)e.getValue()).create(autoNumber)));
        this.oneOfs = builder.oneOfs.values().stream().map(e -> e.create(autoNumber)).toList();
        this.reservedNumbers = builder.reservedNumbers;
        this.reservedNames = Set.copyOf(builder.reservedNames);
        this.options = Map.copyOf(builder.options);
        this.comments = List.copyOf(builder.comments);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Map<String, Enum> getNestedEnums() {
        return this.nestedEnums;
    }

    public Map<String, Message> getNestedMessages() {
        return this.nestedMessages;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public List<OneOf> getOneOfs() {
        return this.oneOfs;
    }

    public ReservedNumbers getReservedNumbers() {
        return this.reservedNumbers;
    }

    public Set<String> getReservedNames() {
        return this.reservedNames;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public static class Builder
    implements CommentContainer<Builder>,
    MessageContainer,
    FieldContainer,
    OptionContainer<Builder>,
    ReservedContainer<Builder>,
    EnumContainer {
        private final Schema.Builder schema;
        private final String name;
        private final Map<String, Enum.Builder> nestedEnums = new HashMap<String, Enum.Builder>();
        private final Map<String, Builder> nestedMessages = new HashMap<String, Builder>();
        private final Map<String, Field.Builder> fields = new HashMap<String, Field.Builder>();
        private final Map<String, OneOf.Builder> oneOfs = new HashMap<String, OneOf.Builder>();
        private final SparseBitSet reservedNumbers = new SparseBitSet();
        private final Set<String> reservedNames = new HashSet<String>();
        private final Map<String, Object> options = new HashMap<String, Object>();
        private final List<String> comments = new ArrayList<String>();
        private final GenericContainer parent;

        Builder(Schema.Builder schema, String name) {
            this.schema = schema;
            this.name = name;
            this.parent = schema;
        }

        Builder(Builder builder, String name) {
            this.schema = builder.schema;
            this.name = name;
            this.parent = builder;
        }

        @Override
        public Builder addMessage(String name) {
            Objects.requireNonNull(name, "name must not be null");
            return this.schema.addMessage(name);
        }

        @Override
        public Builder addNestedEnum(String name, Consumer<Enum.Builder> nested) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(nested, "nested must not be null");
            Enum.Builder e = new Enum.Builder(this, name);
            this.nestedEnums.put(name, e);
            nested.accept(e);
            return this;
        }

        @Override
        public Builder addNestedMessage(String name, Consumer<Builder> nested) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(nested, "nested must not be null");
            Builder message = new Builder(this, name);
            this.nestedMessages.put(name, message);
            nested.accept(message);
            return this;
        }

        @Override
        public Builder addOption(String name, Object value) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(value, "value must not be null");
            this.options.put(name, value);
            return this;
        }

        @Override
        public Builder addComment(String comment) {
            Objects.requireNonNull(comment, "comment must not be null");
            this.comments.add(comment.trim());
            return this;
        }

        @Override
        public Field.Builder addField(Type type, String name, int number) {
            Objects.requireNonNull(type, "type must not be null");
            Objects.requireNonNull(name, "name must not be null");
            this.checkDuplicate(name);
            Field.Builder field = new Field.Builder(this, type, name, number, false);
            this.fields.put(name, field);
            return field;
        }

        @Override
        public Field.Builder addRepeatedField(Type type, String name, int number) {
            Objects.requireNonNull(type, "type must not be null");
            Objects.requireNonNull(name, "name must not be null");
            this.checkDuplicate(name);
            Field.Builder field = new Field.Builder(this, type, name, number, true);
            this.fields.put(name, field);
            return field;
        }

        @Override
        public Map.Builder addMap(Type.Scalar keyType, Type valueType, String name, int number) {
            Objects.requireNonNull(keyType, "keyType must not be null");
            Objects.requireNonNull(valueType, "valueType must not be null");
            Objects.requireNonNull(name, "name must not be null");
            this.checkDuplicate(name);
            Map.Builder map = new Map.Builder((FieldContainer)this, (Type)keyType, valueType, name, number);
            this.fields.put(name, map);
            return map;
        }

        @Override
        public Builder addOneOf(String name, Consumer<OneOf.Builder> oneof) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(oneof, "oneof must not be null");
            this.checkDuplicate(name);
            OneOf.Builder builder = new OneOf.Builder(this, name);
            this.oneOfs.put(name, builder);
            oneof.accept(builder);
            return this;
        }

        @Override
        public Builder addReserved(int ... numbers) {
            Objects.requireNonNull(numbers, "number array must not be null");
            for (int number : numbers) {
                this.reservedNumbers.set(number);
            }
            return this;
        }

        @Override
        public Builder addReservedRange(int from, int to) {
            this.reservedNumbers.set((long)from, to + 1);
            return this;
        }

        @Override
        public Builder addReserved(String name) {
            Objects.requireNonNull(name, "name must not be null");
            this.reservedNames.add(name);
            return this;
        }

        @Override
        public Enum.Builder addEnum(String name) {
            return this.schema.addEnum(name);
        }

        Message create() {
            this.validate();
            return new Message(this);
        }

        private void validate() {
            Boolean autoGenerateNumbers = null;
            for (Field.Builder fb : this.fields.values()) {
                if (this.reservedNames.contains(fb.name)) {
                    throw Log.LOG.reservedName(fb.name, this.name);
                }
                if (fb.number == 0) {
                    if (Boolean.FALSE.equals(autoGenerateNumbers)) {
                        throw Log.LOG.cannotMixAutoGeneratedNumbers(this.name);
                    }
                    autoGenerateNumbers = Boolean.TRUE;
                    continue;
                }
                if (this.reservedNumbers.get(fb.number)) {
                    throw Log.LOG.reservedNumber(fb.number, fb.name, this.name);
                }
                if (Boolean.TRUE.equals(autoGenerateNumbers)) {
                    throw Log.LOG.cannotMixAutoGeneratedNumbers(this.name);
                }
                autoGenerateNumbers = Boolean.FALSE;
            }
            for (OneOf.Builder ob : this.oneOfs.values()) {
                for (OneOf.FieldBuilder fb : ob.getFields().values()) {
                    if (this.reservedNames.contains(fb.builder.name)) {
                        throw Log.LOG.reservedName(fb.builder.name, ob.getFullName());
                    }
                    if (!this.reservedNumbers.get(fb.builder.number)) continue;
                    throw Log.LOG.reservedNumber(fb.builder.number, fb.builder.name, ob.getFullName());
                }
            }
            if (Boolean.TRUE.equals(autoGenerateNumbers) && !this.reservedNumbers.isEmpty()) {
                throw Log.LOG.cannotMixAutoGeneratedNumbers(this.name);
            }
        }

        @Override
        public Schema build() {
            return this.schema.build();
        }

        @Override
        public String getFullName() {
            return this.parent.getFullName() + "." + this.name;
        }

        private void checkDuplicate(String name) {
            if (this.fields.containsKey(name) || this.oneOfs.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate field name " + name);
            }
        }
    }
}

