/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import org.dbunit.DatabaseTestCase;
import org.dbunit.IDatabaseTester;
import org.dbunit.PropertiesBasedJdbcDatabaseTester;
import org.dbunit.database.IDatabaseConnection;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBTestCase
extends DatabaseTestCase {
    private static final Logger logger = LoggerFactory.getLogger(DBTestCase.class);

    public DBTestCase() {
    }

    public DBTestCase(String name) {
        super(name);
    }

    @Override
    protected final IDatabaseConnection getConnection() throws Exception {
        logger.debug("getConnection() - start");
        IDatabaseTester databaseTester = this.getDatabaseTester();
        Assertions.assertNotNull((Object)databaseTester, (String)"DatabaseTester is not set");
        IDatabaseConnection connection = databaseTester.getConnection();
        this.setUpDatabaseConfig(connection.getConfig());
        return connection;
    }

    @Override
    protected IDatabaseTester newDatabaseTester() throws Exception {
        return new PropertiesBasedJdbcDatabaseTester();
    }
}

