/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import org.dbunit.DefaultDatabaseTester;
import org.dbunit.DefaultOperationListener;
import org.dbunit.IDatabaseTester;
import org.dbunit.IOperationListener;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseTestCase
implements InvocationInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseTestCase.class);
    private IDatabaseTester tester;
    private IOperationListener operationListener;
    private final String name;

    protected DatabaseTestCase() {
        this.name = null;
    }

    protected DatabaseTestCase(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected abstract IDatabaseConnection getConnection() throws Exception;

    protected abstract IDataSet getDataSet() throws Exception;

    protected IDatabaseTester newDatabaseTester() throws Exception {
        logger.debug("newDatabaseTester() - start");
        IDatabaseConnection connection = this.getConnection();
        this.getOperationListener().connectionRetrieved(connection);
        DefaultDatabaseTester tester = new DefaultDatabaseTester(connection);
        return tester;
    }

    protected void setUpDatabaseConfig(DatabaseConfig config) {
    }

    protected IDatabaseTester getDatabaseTester() throws Exception {
        if (this.tester == null) {
            this.tester = this.newDatabaseTester();
        }
        return this.tester;
    }

    @Deprecated
    protected void closeConnection(IDatabaseConnection connection) throws Exception {
        logger.debug("closeConnection(connection={}) - start", (Object)connection);
        Assertions.assertNotNull((Object)this.getDatabaseTester(), (String)"DatabaseTester is not set");
        this.getDatabaseTester().closeConnection(connection);
    }

    protected DatabaseOperation getSetUpOperation() throws Exception {
        return DatabaseOperation.CLEAN_INSERT;
    }

    protected DatabaseOperation getTearDownOperation() throws Exception {
        return DatabaseOperation.NONE;
    }

    protected void setUp() throws Exception {
        logger.debug("setUp() - start");
        IDatabaseTester databaseTester = this.getDatabaseTester();
        Assertions.assertNotNull((Object)databaseTester, (String)"DatabaseTester is not set");
        databaseTester.setSetUpOperation(this.getSetUpOperation());
        databaseTester.setDataSet(this.getDataSet());
        databaseTester.setOperationListener(this.getOperationListener());
        databaseTester.onSetup();
    }

    protected void tearDown() throws Exception {
        logger.debug("tearDown() - start");
        try {
            IDatabaseTester databaseTester = this.getDatabaseTester();
            Assertions.assertNotNull((Object)databaseTester, (String)"DatabaseTester is not set");
            databaseTester.setTearDownOperation(this.getTearDownOperation());
            databaseTester.setDataSet(this.getDataSet());
            databaseTester.setOperationListener(this.getOperationListener());
            databaseTester.onTearDown();
        }
        finally {
            this.tester = null;
        }
    }

    protected IOperationListener getOperationListener() {
        logger.debug("getOperationListener() - start");
        if (this.operationListener == null) {
            this.operationListener = new DefaultOperationListener(){

                @Override
                public void connectionRetrieved(IDatabaseConnection connection) {
                    super.connectionRetrieved(connection);
                    DatabaseTestCase.this.setUpDatabaseConfig(connection.getConfig());
                }
            };
        }
        return this.operationListener;
    }
}

