/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion.comparer.value.verifier;

import java.util.Map;
import org.dbunit.VerifyTableDefinition;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.assertion.comparer.value.verifier.VerifyTableDefinitionVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVerifyTableDefinitionVerifier
implements VerifyTableDefinitionVerifier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void verify(VerifyTableDefinition verifyTableDefinition) {
        String tableName = verifyTableDefinition.getTableName();
        String[] columnExclusionFilters = verifyTableDefinition.getColumnExclusionFilters();
        Map<String, ValueComparer> columnValueComparers = verifyTableDefinition.getColumnValueComparers();
        this.verify(tableName, columnExclusionFilters, columnValueComparers);
    }

    public void verify(String tableName, String[] columnExclusionFilters, Map<String, ValueComparer> columnValueComparers) {
        boolean hasColumnExclusionFilters = this.hasColumnExclusionFilters(columnExclusionFilters);
        boolean hasColumnValueComparers = this.hasColumnValueComparers(columnValueComparers);
        if (hasColumnExclusionFilters && hasColumnValueComparers) {
            this.doVerify(tableName, columnExclusionFilters, columnValueComparers);
        }
    }

    protected void doVerify(String tableName, String[] columnExclusionFilters, Map<String, ValueComparer> columnValueComparers) {
        for (String columnName : columnExclusionFilters) {
            this.log.trace("doVerify: columnName={}", (Object)columnName);
            this.failIfColumnValueComparersHaveExcludedColumn(tableName, columnName, columnValueComparers);
        }
    }

    protected void failIfColumnValueComparersHaveExcludedColumn(String tableName, String columnName, Map<String, ValueComparer> columnValueComparers) {
        ValueComparer valueComparer = columnValueComparers.get(columnName);
        if (valueComparer != null) {
            String msg = "Test setup conflict: table=" + tableName + ", columnName=" + columnName + ", has a VerifyTableDefinition column exclusion and a specific column ValueComparer=" + valueComparer + "; to test the column, remove the exclusion; to ignore the column, remove the ValueComparer";
            this.log.error("failIfColumnValueComparersHaveExcludedColumn: {}", (Object)msg);
            throw new IllegalStateException(msg);
        }
        this.log.trace("failIfColumnValueComparersHaveExcludedColumn:config ok as no valueComparer found for excluded columnName={}", (Object)columnName);
    }

    protected boolean hasColumnExclusionFilters(String[] columnExclusionFilters) {
        boolean isMissing;
        boolean bl = isMissing = columnExclusionFilters == null || columnExclusionFilters.length == 0;
        if (isMissing) {
            this.log.debug("hasColumnExclusionFilters: no columnExclusionFilters specified");
        }
        return !isMissing;
    }

    protected boolean hasColumnValueComparers(Map<String, ValueComparer> columnValueComparers) {
        boolean isMissing;
        boolean bl = isMissing = columnValueComparers == null || columnValueComparers.isEmpty();
        if (isMissing) {
            this.log.debug("hasColumnValueComparers: no columnValueComparers specified");
        }
        return !isMissing;
    }
}

