/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.OrderedTableNameMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSet
implements IDataSet {
    protected OrderedTableNameMap _orderedTableNameMap;
    private boolean _caseSensitiveTableNames = false;
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataSet.class);

    public AbstractDataSet() {
    }

    public AbstractDataSet(boolean caseSensitiveTableNames) {
        this._caseSensitiveTableNames = caseSensitiveTableNames;
    }

    @Override
    public boolean isCaseSensitiveTableNames() {
        return this._caseSensitiveTableNames;
    }

    protected OrderedTableNameMap createTableNameMap() {
        return new OrderedTableNameMap(this._caseSensitiveTableNames);
    }

    protected void initialize() throws DataSetException {
        logger.debug("initialize() - start");
        if (this._orderedTableNameMap != null) {
            logger.debug("The table name map has already been initialized.");
            return;
        }
        this._orderedTableNameMap = this.createTableNameMap();
        ITableIterator iterator = this.createIterator(false);
        while (iterator.next()) {
            ITable table = iterator.getTable();
            this._orderedTableNameMap.add(table.getTableMetaData().getTableName(), table);
        }
    }

    protected abstract ITableIterator createIterator(boolean var1) throws DataSetException;

    @Override
    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        this.initialize();
        return this._orderedTableNameMap.getTableNames();
    }

    @Override
    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        return this.getTable(tableName).getTableMetaData();
    }

    @Override
    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        this.initialize();
        ITable found = (ITable)this._orderedTableNameMap.get(tableName);
        if (found != null) {
            return found;
        }
        throw new NoSuchTableException(tableName);
    }

    @Override
    public ITable[] getTables() throws DataSetException {
        logger.debug("getTables() - start");
        this.initialize();
        return this._orderedTableNameMap.orderedValues().toArray(new ITable[0]);
    }

    @Override
    public ITableIterator iterator() throws DataSetException {
        logger.debug("iterator() - start");
        return this.createIterator(false);
    }

    @Override
    public ITableIterator reverseIterator() throws DataSetException {
        logger.debug("reverseIterator() - start");
        return this.createIterator(true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractDataSet[");
        sb.append("_orderedTableNameMap=").append(this._orderedTableNameMap);
        sb.append("]");
        return sb.toString();
    }
}

