/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.StringDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClobDataType
extends StringDataType {
    private static final Logger logger = LoggerFactory.getLogger(ClobDataType.class);

    public ClobDataType() {
        super("CLOB", 2005);
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)column, (Object)resultSet);
        Clob rawValue = resultSet.getClob(column);
        Object value = resultSet.wasNull() ? null : this.typeCast(rawValue);
        logger.debug("getSqlValue: column={}, value={}", (Object)column, value);
        return value;
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, column, statement});
        statement.setObject(column, this.typeCast(value), this.getSqlType());
    }
}

