/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.yaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.DuplicateKeyException;

public class YamlProducer
implements IDataSetProducer {
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private InputStream _inputStream;
    private Yaml _yaml;

    public YamlProducer(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public YamlProducer(InputStream inputStream) {
        this._inputStream = inputStream;
        LoaderOptions options = new LoaderOptions();
        options.setAllowDuplicateKeys(false);
        this._yaml = new Yaml(options);
    }

    @Override
    public void setConsumer(IDataSetConsumer consumer) {
        this._consumer = consumer;
    }

    @Override
    public void produce() throws DataSetException {
        LinkedHashMap dataset;
        this._consumer.startDataSet();
        try {
            dataset = (LinkedHashMap)this._yaml.load(this._inputStream);
        }
        catch (DuplicateKeyException e) {
            String problem = e.getProblem();
            String duplicateTable = problem.replace("found duplicate key ", "");
            throw new AmbiguousTableNameException(duplicateTable, e);
        }
        for (String tableName : dataset.keySet()) {
            List rows = (List)dataset.get(tableName);
            ITableMetaData meta = this.getMetaData(tableName, rows);
            this._consumer.startTable(meta);
            if (rows != null) {
                for (Map row : rows) {
                    this._consumer.row(this.getRow(meta, row));
                }
            }
            this._consumer.endTable();
        }
    }

    private ITableMetaData getMetaData(String tableName, List<Map<String, Object>> rows) {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        if (rows != null) {
            for (Map<String, Object> row : rows) {
                for (Map.Entry<String, Object> column : row.entrySet()) {
                    columns.add(column.getKey());
                }
            }
            ArrayList<Column> list = new ArrayList<Column>(columns.size());
            for (String s : columns) {
                list.add(new Column(s, DataType.UNKNOWN));
            }
            return new DefaultTableMetaData(tableName, list.toArray(new Column[list.size()]));
        }
        return new DefaultTableMetaData(tableName, new Column[0]);
    }

    private Object[] getRow(ITableMetaData meta, Map<String, Object> row) throws DataSetException {
        Object[] result = new Object[meta.getColumns().length];
        for (int i = 0; i < meta.getColumns().length; ++i) {
            result[i] = row.get(meta.getColumns()[i].getColumnName());
        }
        return result;
    }
}

