/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.ClobDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleClobDataType
extends ClobDataType {
    private static final Logger logger = LoggerFactory.getLogger(OracleClobDataType.class);

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)column, (Object)resultSet);
        return this.typeCast(resultSet.getClob(column));
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, column, statement});
        statement.setObject(column, this.getClob(value, statement.getConnection()));
    }

    protected Object getClob(Object value, Connection connection) throws TypeCastException {
        logger.debug("getClob(value={}, connection={}) - start", value, (Object)connection);
        Writer tempClobWriter = null;
        try {
            Clob tempClob = connection.createClob();
            tempClobWriter = tempClob.setCharacterStream(1L);
            tempClobWriter.write((String)this.typeCast(value));
            tempClobWriter.flush();
            Clob clob = tempClob;
            this.closeQuietly(tempClobWriter);
            return clob;
        }
        catch (IOException | SQLException e) {
            try {
                throw new TypeCastException(value, this, e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(tempClobWriter);
                throw throwable;
            }
        }
    }

    private void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

