/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.postgresql;

import java.util.Arrays;
import java.util.Collection;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.ext.postgresql.CitextType;
import org.dbunit.ext.postgresql.GenericEnumType;
import org.dbunit.ext.postgresql.GeometryType;
import org.dbunit.ext.postgresql.InetType;
import org.dbunit.ext.postgresql.IntervalType;
import org.dbunit.ext.postgresql.PostgreSQLOidDataType;
import org.dbunit.ext.postgresql.UuidType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlDataTypeFactory
extends DefaultDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(PostgresqlDataTypeFactory.class);
    private static final Collection DATABASE_PRODUCTS = Arrays.asList("PostgreSQL");

    @Override
    public Collection getValidDbProducts() {
        return DATABASE_PRODUCTS;
    }

    public static Collection getDatabaseProducts() {
        return DATABASE_PRODUCTS;
    }

    @Override
    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        logger.debug("createDataType(sqlType={}, sqlTypeName={})", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        if (sqlType == 1111) {
            if ("uuid".equals(sqlTypeName)) {
                return new UuidType();
            }
            if ("interval".equals(sqlTypeName)) {
                return new IntervalType();
            }
            if ("inet".equals(sqlTypeName)) {
                return new InetType();
            }
            if ("geometry".equals(sqlTypeName)) {
                return new GeometryType();
            }
            if ("citext".equals(sqlTypeName)) {
                return new CitextType();
            }
            if (this.isEnumType(sqlTypeName)) {
                logger.debug("Custom enum type used for sqlTypeName {} (sqlType '{}')", (Object)sqlTypeName, (Object)sqlType);
                return new GenericEnumType(sqlTypeName);
            }
        } else if (sqlType == -5 && "oid".equals(sqlTypeName)) {
            return new PostgreSQLOidDataType();
        }
        return super.createDataType(sqlType, sqlTypeName);
    }

    public boolean isEnumType(String sqlTypeName) {
        return false;
    }
}

