/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.HashSet;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IBatchStatement;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.operation.AbstractOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAllOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger(DeleteAllOperation.class);

    DeleteAllOperation() {
    }

    protected String getDeleteAllCommand() {
        return "delete from ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        logger.debug("execute(connection={}, dataSet={}) - start", (Object)connection, (Object)dataSet);
        IDataSet databaseDataSet = connection.createDataSet();
        DatabaseConfig databaseConfig = connection.getConfig();
        IStatementFactory statementFactory = (IStatementFactory)databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
        try (IBatchStatement statement = statementFactory.createBatchStatement(connection);){
            String tableName;
            int count = 0;
            ArrayDeque<String> tableNames = new ArrayDeque<String>();
            HashSet<String> tablesSeen = new HashSet<String>();
            ITableIterator iterator = dataSet.iterator();
            while (iterator.next()) {
                tableName = iterator.getTableMetaData().getTableName();
                if (tablesSeen.contains(tableName)) continue;
                tableNames.push(tableName);
                tablesSeen.add(tableName);
            }
            while (!tableNames.isEmpty()) {
                tableName = (String)tableNames.pop();
                ITableMetaData databaseMetaData = databaseDataSet.getTableMetaData(tableName);
                tableName = databaseMetaData.getTableName();
                StringBuilder sqlBuffer = new StringBuilder(128);
                sqlBuffer.append(this.getDeleteAllCommand());
                sqlBuffer.append(this.getQualifiedName(connection.getSchema(), tableName, connection));
                String sql = sqlBuffer.toString();
                statement.addBatch(sql);
                if (logger.isDebugEnabled()) {
                    logger.debug("Added SQL: {}", (Object)sql);
                }
                ++count;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
            }
        }
    }
}

