/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.util.BitSet;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoPrimaryKeyException;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.OperationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteOperation
extends AbstractBatchOperation {
    private static final Logger logger = LoggerFactory.getLogger(DeleteOperation.class);

    DeleteOperation() {
        this._reverseRowOrder = true;
    }

    @Override
    protected ITableIterator iterator(IDataSet dataSet) throws DatabaseUnitException {
        logger.debug("iterator(dataSet={}) - start", (Object)dataSet);
        return dataSet.reverseIterator();
    }

    @Override
    public OperationData getOperationData(ITableMetaData metaData, BitSet ignoreMapping, IDatabaseConnection connection) throws DataSetException {
        Column[] primaryKeys;
        if (logger.isDebugEnabled()) {
            logger.debug("getOperationData(metaData={}, ignoreMapping={}, connection={}) - start", new Object[]{metaData, ignoreMapping, connection});
        }
        if ((primaryKeys = metaData.getPrimaryKeys()).length == 0) {
            throw new NoPrimaryKeyException(metaData.getTableName());
        }
        StringBuilder sqlBuffer = new StringBuilder(128);
        sqlBuffer.append("delete from ");
        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
        sqlBuffer.append(" where ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            String columnName = this.getQualifiedName(null, primaryKeys[i].getColumnName(), connection);
            sqlBuffer.append(columnName);
            sqlBuffer.append(" = ?");
            if (i + 1 >= primaryKeys.length) continue;
            sqlBuffer.append(" and ");
        }
        return new OperationData(sqlBuffer.toString(), primaryKeys);
    }
}

