/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.search;

import org.dbunit.util.search.IEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Edge
implements IEdge {
    private static final Logger logger = LoggerFactory.getLogger(Edge.class);
    private final Comparable<String> nodeFrom;
    private final Comparable<String> nodeTo;

    public Edge(Comparable<String> nodeFrom, Comparable<String> nodeTo) {
        if (nodeFrom == null) {
            throw new IllegalArgumentException("node from cannot be null");
        }
        if (nodeTo == null) {
            throw new IllegalArgumentException("node to cannot be null");
        }
        this.nodeFrom = nodeFrom;
        this.nodeTo = nodeTo;
    }

    @Override
    public Object getFrom() {
        return this.nodeFrom;
    }

    @Override
    public Object getTo() {
        return this.nodeTo;
    }

    public String toString() {
        return this.nodeFrom + "->" + this.nodeTo;
    }

    @Override
    public int compareTo(Object o) {
        logger.debug("compareTo(o={}) - start", o);
        Edge otherEdge = (Edge)o;
        int result = this.nodeFrom.compareTo((String)otherEdge.getFrom());
        if (result == 0) {
            result = this.nodeTo.compareTo((String)otherEdge.getTo());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeFrom == null ? 0 : this.nodeFrom.hashCode());
        result = 31 * result + (this.nodeTo == null ? 0 : this.nodeTo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.nodeFrom == null ? other.nodeFrom != null : !this.nodeFrom.equals(other.nodeFrom)) {
            return false;
        }
        return !(this.nodeTo == null ? other.nodeTo != null : !this.nodeTo.equals(other.nodeTo));
    }
}

