/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xebialabs.ascode.service.spec.InterpreterContext;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.writer.DefinitionWriter;
import com.xebialabs.deployit.ascode.service.DefinitionInterpreterService;
import com.xebialabs.deployit.ascode.service.generator.DefinitionGeneratorService;
import com.xebialabs.deployit.ascode.yaml.parser.XLDDefinitionParser;
import com.xebialabs.deployit.ascode.yaml.sugar.XLDSugar;
import com.xebialabs.deployit.ascode.yaml.writer.XLDDefinitionWriter;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.engine.api.XLDAsCodeService;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.javaapi.CollectionConverters;

@Controller
public class XLDAsCodeServiceImpl
implements XLDAsCodeService {
    private static final String AS_CODE_APPLY_PREFIX = "as-code-apply";
    private static final String AS_CODE_GENERATE_PREFIX = "as-code-generate";
    private static final Logger logger = LoggerFactory.getLogger(XLDAsCodeServiceImpl.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final DefinitionInterpreterService asCodeInterpretationService;
    private final DefinitionGeneratorService generatorService;
    private final XLDDefinitionParser parser;

    @Autowired
    public XLDAsCodeServiceImpl(DefinitionInterpreterService asCodeInterpretationService, DefinitionGeneratorService generatorService, XLDDefinitionParser parser) {
        this.asCodeInterpretationService = asCodeInterpretationService;
        this.generatorService = generatorService;
        this.parser = parser;
        logger.debug("XLDAsCodeServiceImpl bean created successfully");
    }

    @Workdir(prefix="as-code-apply", clean=Workdir.Clean.ONLY_ON_EXCEPTION)
    public XLDAsCodeResult apply(String yamlContent) {
        logger.debug("XLDAsCodeServiceImpl.apply() called with YAML content length: {}", (Object)(yamlContent != null ? yamlContent.length() : 0));
        try {
            String currentUser = System.getProperty("user.name");
            String javaVersion = System.getProperty("java.version");
            String processId = String.valueOf(ProcessHandle.current().pid());
            String workingDir = System.getProperty("user.dir");
            logger.info("=== MASTER NODE EXECUTION INFO ===");
            logger.info("XLDAsCodeServiceImpl.apply() - User: {}, PID: {}, Java: {}", new Object[]{currentUser, processId, javaVersion});
            logger.info("Working Directory: {}", (Object)workingDir);
            logger.info("Thread: {}", (Object)Thread.currentThread().getName());
            logger.info("==================================");
        }
        catch (Exception e) {
            logger.error("Could not retrieve master node execution info: {}", (Object)e.getMessage());
        }
        logger.debug("Applying DevOps-as-Code YAML via XLDAsCodeService");
        try {
            Definition definition = this.parseYamlContent(yamlContent);
            AsCodeResponse response = this.asCodeInterpretationService.interpret(new InterpreterContext(definition, Option.empty()));
            logger.debug("DevOps-as-Code apply successful");
            if (response != null && logger.isDebugEnabled()) {
                if (response.changes().isDefined()) {
                    AsCodeResponse.Changes changes = (AsCodeResponse.Changes)response.changes().get();
                    logger.debug("Changes detected: {}", (Object)changes);
                } else {
                    logger.debug("No changes detected in response");
                }
                if (response.errors().isDefined()) {
                    logger.warn("Errors in response: {}", response.errors().get());
                }
            }
            String jsonContent = this.serializeAsCodeResponse(response);
            return new XLDAsCodeResult(true, "DevOps-as-Code YAML applied successfully", jsonContent, null);
        }
        catch (Exception e) {
            logger.error("Failed to apply DevOps-as-Code YAML: {}", (Object)e.getMessage(), (Object)e);
            return new XLDAsCodeResult(false, "Failed to apply YAML: " + e.getMessage(), null, this.getStackTrace(e));
        }
    }

    @Workdir(prefix="as-code-apply", clean=Workdir.Clean.ONLY_ON_EXCEPTION)
    public XLDAsCodeResult applyWithScm(String yamlContent, String scmType, String scmCommit, String scmAuthor, String scmDate, String scmMessage, String scmRemote, String scmFileName) {
        logger.debug("XLDAsCodeServiceImpl.applyWithScm() called with YAML content length: {}, SCM commit: {}", (Object)(yamlContent != null ? yamlContent.length() : 0), (Object)(scmCommit != null ? scmCommit : "null"));
        if (yamlContent == null || yamlContent.isEmpty()) {
            return new XLDAsCodeResult(false, "YAML content cannot be null or empty", null, null);
        }
        logger.debug("Applying DevOps-as-Code YAML via XLDAsCodeService with SCM traceability");
        try {
            Option scmOption;
            Definition definition = this.parseYamlContent(yamlContent);
            if (scmCommit != null && !scmCommit.isEmpty()) {
                DateTime dateTime = null;
                if (scmDate != null && !scmDate.isEmpty()) {
                    try {
                        dateTime = DateTime.parse((String)scmDate);
                    }
                    catch (Exception e) {
                        logger.debug("Could not parse SCM date '{}': {}", (Object)scmDate, (Object)e.getMessage());
                    }
                }
                SCMTraceabilityData scmData = new SCMTraceabilityData(scmType != null ? scmType : "git", scmCommit, scmAuthor != null ? scmAuthor : "", dateTime, scmMessage != null ? scmMessage : "", scmRemote != null ? scmRemote : "", scmFileName != null ? scmFileName : "");
                scmOption = Option.apply((Object)scmData);
                logger.debug("SCM Traceability - Commit: {}, Author: {}, Remote: {}", new Object[]{scmCommit, scmAuthor, scmRemote});
            } else {
                scmOption = Option.empty();
            }
            AsCodeResponse response = this.asCodeInterpretationService.interpret(new InterpreterContext(definition, scmOption));
            logger.debug("DevOps-as-Code apply with SCM traceability successful");
            if (response != null && logger.isDebugEnabled()) {
                if (response.changes().isDefined()) {
                    AsCodeResponse.Changes changes = (AsCodeResponse.Changes)response.changes().get();
                    logger.debug("Changes detected: {}", (Object)changes);
                } else {
                    logger.debug("No changes detected in response");
                }
                if (response.errors().isDefined()) {
                    logger.warn("Errors in response: {}", response.errors().get());
                }
            }
            String jsonContent = this.serializeAsCodeResponse(response);
            return new XLDAsCodeResult(true, "DevOps-as-Code YAML applied successfully with SCM traceability", jsonContent, null);
        }
        catch (Exception e) {
            logger.error("Failed to apply DevOps-as-Code YAML with SCM traceability: {}", (Object)e.getMessage(), (Object)e);
            return new XLDAsCodeResult(false, "Failed to apply YAML: " + e.getMessage(), null, this.getStackTrace(e));
        }
    }

    @Workdir(prefix="as-code-generate", clean=Workdir.Clean.ONLY_ON_EXCEPTION)
    public XLDAsCodeResult generate(String path, boolean globalPermissions, boolean roles, boolean users, boolean includeSecrets, boolean includeDefaults) {
        logger.debug("Generating DevOps-as-Code YAML via XLDAsCodeService for path: {}", (Object)path);
        try {
            DefinitionGeneratorService.GeneratorConfig config = new DefinitionGeneratorService.GeneratorConfig((Option<String>)Option.apply((Object)path).filter(p -> p != null && !p.isEmpty()), globalPermissions, roles, users, includeSecrets);
            List<Definition> definitions = this.generatorService.generate(config);
            DefinitionWriter.WriterConfig writerConfig = new DefinitionWriter.WriterConfig(definitions, includeSecrets, includeDefaults);
            logger.debug("DevOps-as-Code generation successful");
            ByteArrayOutputStream zipOutputStream = new ByteArrayOutputStream();
            XLDDefinitionWriter.write(zipOutputStream, writerConfig, XLDSugar.defaultConfig());
            String generatedContent = this.extractYamlFromZip(zipOutputStream.toByteArray());
            return new XLDAsCodeResult(true, "DevOps-as-Code YAML generated successfully", generatedContent, null);
        }
        catch (Exception e) {
            logger.error("Failed to generate DevOps-as-Code YAML: {}", (Object)e.getMessage(), (Object)e);
            return new XLDAsCodeResult(false, "Failed to generate YAML: " + e.getMessage(), null, this.getStackTrace(e));
        }
    }

    private Definition parseYamlContent(String yamlContent) {
        try {
            return this.parser.parse(new ByteArrayInputStream(yamlContent.getBytes()), XLDSugar.defaultConfig());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse YAML content: " + e.getMessage(), e);
        }
    }

    private String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private String extractYamlFromZip(byte[] zipBytes) throws Exception {
        try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(zipBytes));){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                if ("index.yaml".equals(entry.getName())) {
                    int len;
                    ByteArrayOutputStream yamlOut = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((len = zipIn.read(buffer)) > 0) {
                        yamlOut.write(buffer, 0, len);
                    }
                    String string = yamlOut.toString("UTF-8");
                    return string;
                }
                zipIn.closeEntry();
            }
        }
        throw new IllegalStateException("index.yaml not found in generated ZIP");
    }

    private String serializeAsCodeResponse(AsCodeResponse response) {
        if (response == null) {
            return "{}";
        }
        try {
            ObjectNode root = objectMapper.createObjectNode();
            if (response.changes().isDefined()) {
                AsCodeResponse.Changes changes = (AsCodeResponse.Changes)response.changes().get();
                ObjectNode changesNode = objectMapper.createObjectNode();
                ArrayNode idsArray = objectMapper.createArrayNode();
                for (AsCodeResponse.ChangedIds changedIds : CollectionConverters.asJava((Seq)changes.ids())) {
                    Object id2;
                    ObjectNode idNode = objectMapper.createObjectNode();
                    idNode.put("kind", changedIds.kind());
                    ArrayNode createdArray = objectMapper.createArrayNode();
                    for (Object id2 : CollectionConverters.asJava((Seq)changedIds.created())) {
                        createdArray.add((String)id2);
                    }
                    idNode.set("created", (JsonNode)createdArray);
                    ArrayNode updatedArray = objectMapper.createArrayNode();
                    id2 = CollectionConverters.asJava((Seq)changedIds.updated()).iterator();
                    while (id2.hasNext()) {
                        String id3 = (String)id2.next();
                        updatedArray.add(id3);
                    }
                    idNode.set("updated", (JsonNode)updatedArray);
                    ArrayNode deletedArray = objectMapper.createArrayNode();
                    for (String id4 : CollectionConverters.asJava((Seq)changedIds.deleted())) {
                        deletedArray.add(id4);
                    }
                    idNode.set("deleted", (JsonNode)deletedArray);
                    idsArray.add((JsonNode)idNode);
                }
                changesNode.set("ids", (JsonNode)idsArray);
                root.set("changes", (JsonNode)changesNode);
            }
            if (response.errors().isDefined()) {
                ObjectNode errorNode;
                AsCodeResponse.Errors errors = (AsCodeResponse.Errors)response.errors().get();
                ObjectNode errorsNode = objectMapper.createObjectNode();
                if (!CollectionConverters.asJava((Seq)errors.validation()).isEmpty()) {
                    ArrayNode validationArray = objectMapper.createArrayNode();
                    for (AsCodeResponse.CiValidationError error : CollectionConverters.asJava((Seq)errors.validation())) {
                        errorNode = objectMapper.createObjectNode();
                        errorNode.put("ciId", error.ciId());
                        errorNode.put("propertyName", error.propertyName());
                        errorNode.put("message", error.message());
                        validationArray.add((JsonNode)errorNode);
                    }
                    errorsNode.set("validation", (JsonNode)validationArray);
                }
                if (!CollectionConverters.asJava((Seq)errors.permission()).isEmpty()) {
                    ArrayNode permissionArray = objectMapper.createArrayNode();
                    for (AsCodeResponse.CiValidationError error : CollectionConverters.asJava((Seq)errors.permission())) {
                        errorNode = objectMapper.createObjectNode();
                        errorNode.put("ciId", error.ciId());
                        errorNode.put("permission", error.permission());
                        permissionArray.add((JsonNode)errorNode);
                    }
                    errorsNode.set("permission", (JsonNode)permissionArray);
                }
                if (errors.document().isDefined()) {
                    AsCodeResponse.DocumentFieldError docError = (AsCodeResponse.DocumentFieldError)errors.document().get();
                    ObjectNode docNode = objectMapper.createObjectNode();
                    docNode.put("field", docError.field());
                    docNode.put("problem", docError.problem());
                    errorsNode.set("document", (JsonNode)docNode);
                }
                if (errors.generic().isDefined()) {
                    errorsNode.put("generic", (String)errors.generic().get());
                }
                root.set("errors", (JsonNode)errorsNode);
            }
            return objectMapper.writeValueAsString((Object)root);
        }
        catch (Exception e) {
            logger.error("Failed to serialize AsCodeResponse to JSON, falling back to toString: {}", (Object)e.getMessage());
            return response.toString();
        }
    }
}

