/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.ToOneFkSecondPass;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Value;

public class OneToOneSecondPass
implements SecondPass {
    private final MetadataBuildingContext buildingContext;
    private final OneToOne oneToOne;
    private final PropertyBinder binder;
    private final Property property;
    private final String mappedBy;
    private final String ownerEntity;
    private final PropertyHolder propertyHolder;
    private final PropertyData inferredData;
    private final NotFoundAction notFoundAction;
    private final AnnotatedJoinColumns joinColumns;
    private final boolean annotatedEntity;

    public OneToOneSecondPass(PropertyBinder binder, Property property, OneToOne oneToOne, String mappedBy, String ownerEntity, PropertyHolder propertyHolder, PropertyData inferredData, boolean annotatedEntity, NotFoundAction notFoundAction, AnnotatedJoinColumns columns, MetadataBuildingContext buildingContext) {
        this.binder = binder;
        this.property = property;
        this.oneToOne = oneToOne;
        this.ownerEntity = ownerEntity;
        this.mappedBy = mappedBy;
        this.propertyHolder = propertyHolder;
        this.buildingContext = buildingContext;
        this.notFoundAction = notFoundAction;
        this.inferredData = inferredData;
        this.annotatedEntity = annotatedEntity;
        this.joinColumns = columns;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        if (this.mappedBy == null) {
            this.bindOwned(persistentClasses, this.oneToOne, this.inferredData.getPropertyName());
        } else {
            this.bindUnowned(persistentClasses, this.oneToOne);
        }
        this.binder.callAttributeBindersInSecondPass(this.property);
        this.oneToOne.sortProperties();
    }

    private void bindUnowned(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne) {
        oneToOne.setMappedByProperty(this.mappedBy);
        String targetEntityName = oneToOne.getReferencedEntityName();
        PersistentClass targetEntity = persistentClasses.get(targetEntityName);
        if (targetEntity == null) {
            String problem = this.annotatedEntity ? " which does not belong to the same persistence unit" : " which is not an '@Entity' type";
            throw new MappingException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' targets the type '" + targetEntityName + "'" + problem);
        }
        Property targetProperty = this.targetProperty(oneToOne, targetEntity);
        Value targetPropertyValue = targetProperty.getValue();
        if (targetPropertyValue instanceof ManyToOne) {
            this.bindTargetManyToOne(persistentClasses, oneToOne, targetEntity, targetProperty);
        } else if (!(targetPropertyValue instanceof OneToOne)) {
            throw new AnnotationException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is 'mappedBy' a property named '" + this.mappedBy + "' of the target entity type '" + targetEntityName + "' which is not a '@OneToOne' or '@ManyToOne' association");
        }
        BinderHelper.checkMappedByType(this.mappedBy, targetProperty.getValue(), oneToOne.getPropertyName(), this.propertyHolder, persistentClasses);
    }

    private void bindTargetManyToOne(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne, PersistentClass targetEntity, Property targetProperty) {
        Join otherSideJoin = null;
        for (Join otherSideJoinValue : targetEntity.getJoins()) {
            if (!otherSideJoinValue.containsProperty(targetProperty)) continue;
            otherSideJoin = otherSideJoinValue;
            break;
        }
        if (otherSideJoin != null) {
            Join mappedByJoin = this.buildJoinFromMappedBySide(persistentClasses.get(this.ownerEntity), targetProperty, otherSideJoin);
            ManyToOne manyToOne = new ManyToOne(this.buildingContext, mappedByJoin.getTable());
            manyToOne.setNotFoundAction(this.notFoundAction);
            manyToOne.setOnDeleteAction(oneToOne.getOnDeleteAction());
            manyToOne.setFetchMode(oneToOne.getFetchMode());
            manyToOne.setLazy(oneToOne.isLazy());
            manyToOne.setReferencedEntityName(oneToOne.getReferencedEntityName());
            manyToOne.setReferencedPropertyName(this.mappedBy);
            manyToOne.setUnwrapProxy(oneToOne.isUnwrapProxy());
            manyToOne.markAsLogicalOneToOne();
            this.property.setValue(manyToOne);
            for (Column column : otherSideJoin.getKey().getColumns()) {
                Column copy = column.clone();
                copy.setValue(manyToOne);
                manyToOne.addColumn(copy);
            }
            this.propertyHolder.movePropertyToJoin(this.property, mappedByJoin, this.inferredData.getDeclaringClass());
        }
        oneToOne.setReferencedPropertyName(this.mappedBy);
        KeyValue targetEntityIdentifier = targetEntity.getIdentifier();
        boolean referenceToPrimaryKey = this.mappedBy == null || targetEntityIdentifier instanceof Component && ((Component)targetEntityIdentifier).matchesAllProperties(this.mappedBy);
        oneToOne.setReferenceToPrimaryKey(referenceToPrimaryKey);
        String propertyRef = oneToOne.getReferencedPropertyName();
        if (propertyRef != null) {
            this.buildingContext.getMetadataCollector().addUniquePropertyReference(oneToOne.getReferencedEntityName(), propertyRef);
        }
    }

    private Property targetProperty(OneToOne oneToOne, PersistentClass targetEntity) {
        try {
            Property targetProperty = BinderHelper.findPropertyByName(targetEntity, this.mappedBy);
            if (targetProperty != null) {
                return targetProperty;
            }
        }
        catch (MappingException mappingException) {
            // empty catch block
        }
        throw new AnnotationException("Association '" + BinderHelper.getPath(this.propertyHolder, this.inferredData) + "' is 'mappedBy' a property named '" + this.mappedBy + "' which does not exist in the target entity type '" + oneToOne.getReferencedEntityName() + "'");
    }

    private void bindOwned(Map<String, PersistentClass> persistentClasses, OneToOne oneToOne, String propertyName) {
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass(oneToOne, this.joinColumns, true, this.annotatedEntity, this.propertyHolder.getPersistentClass(), StringHelper.qualify(this.propertyHolder.getPath(), propertyName), this.buildingContext);
        secondPass.doSecondPass(persistentClasses);
    }

    private Join buildJoinFromMappedBySide(PersistentClass persistentClass, Property otherSideProperty, Join originalJoin) {
        SortableValue value;
        Join join = new Join();
        join.setPersistentClass(persistentClass);
        join.setTable(originalJoin.getTable());
        join.setInverse(true);
        DependantValue key = new DependantValue(this.buildingContext, join.getTable(), persistentClass.getIdentifier());
        if (this.notFoundAction != null) {
            join.disableForeignKeyCreation();
        }
        join.setKey(key);
        join.setOptional(true);
        key.setOnDeleteAction(null);
        for (Column column : otherSideProperty.getValue().getColumns()) {
            Column copy = column.clone();
            copy.setValue(key);
            key.addColumn(copy);
        }
        if (otherSideProperty.getValue() instanceof SortableValue && !(value = (SortableValue)((Object)otherSideProperty.getValue())).isSorted()) {
            key.sortProperties();
        }
        persistentClass.addJoin(join);
        return join;
    }
}

