/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.UnsavedValueStrategy;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreLogging;
import org.jboss.logging.Logger;

public class VersionValue
implements UnsavedValueStrategy {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = CoreLogging.logger(VersionValue.class);
    private final @Nullable @UnknownKeyFor @Initialized Object value;
    public static final @UnknownKeyFor @NonNull @Initialized VersionValue NULL = new VersionValue(){

        @Override
        public Boolean isUnsaved(@Nullable Object version) {
            LOG.trace((Object)"Version unsaved-value strategy NULL");
            return version == null;
        }

        @Override
        public @Nullable Object getDefaultValue(Object currentValue) {
            return null;
        }

        @Override
        public String toString() {
            return "VERSION_SAVE_NULL";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized VersionValue UNDEFINED = new VersionValue(){

        @Override
        public @Nullable Boolean isUnsaved(@Nullable Object version) {
            LOG.trace((Object)"Version unsaved-value strategy UNDEFINED");
            return version == null ? Boolean.TRUE : null;
        }

        @Override
        public Object getDefaultValue(Object currentValue) {
            return currentValue;
        }

        @Override
        public String toString() {
            return "VERSION_UNDEFINED";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized VersionValue NEGATIVE = new VersionValue(){

        @Override
        public Boolean isUnsaved(@Nullable Object version) throws MappingException {
            LOG.trace((Object)"Version unsaved-value strategy NEGATIVE");
            if (version == null) {
                return Boolean.TRUE;
            }
            if (version instanceof Number) {
                return ((Number)version).longValue() < 0L;
            }
            throw new MappingException("unsaved-value NEGATIVE may only be used with short, int and long types");
        }

        @Override
        public Object getDefaultValue(Object currentValue) {
            return IdentifierGeneratorHelper.getIntegralDataTypeHolder(currentValue.getClass()).initialize(-1L).makeValue();
        }

        @Override
        public String toString() {
            return "VERSION_NEGATIVE";
        }
    };

    protected VersionValue() {
        this.value = null;
    }

    public VersionValue(@UnknownKeyFor @NonNull @Initialized Object value) {
        this.value = value;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Boolean isUnsaved(@Nullable @UnknownKeyFor @Initialized Object version) throws @UnknownKeyFor @NonNull @Initialized MappingException {
        LOG.tracev("Version unsaved-value: {0}", this.value);
        return version == null || version.equals(this.value);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Object getDefaultValue(@Nullable @UnknownKeyFor @Initialized Object currentValue) {
        return this.value;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "version unsaved-value: " + String.valueOf(this.value);
    }
}

