/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.internal;

import java.time.temporal.Temporal;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JavaTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.internal.GetObjectExtractor;
import org.hibernate.type.descriptor.jdbc.internal.SetObjectBinder;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractJavaTimeJdbcType<T extends Temporal>
implements JavaTimeJdbcType {
    private final Class<T> javaTimeType;

    public AbstractJavaTimeJdbcType(Class<T> javaTimeType) {
        this.javaTimeType = javaTimeType;
    }

    public Class<T> getPreferredJavaTypeClass(WrapperOptions options) {
        return this.javaTimeType;
    }

    public <X> JavaType<X> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().getDescriptor(this.javaTimeType);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new SetObjectBinder<X>(javaType, this, this.javaTimeType, this.getDdlTypeCode());
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new GetObjectExtractor<X>(javaType, this, this.javaTimeType);
    }
}

