/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class SessionXAPrepareMessage
extends PacketImpl {
    private Xid xid;

    public SessionXAPrepareMessage(Xid xid) {
        super((byte)54);
        this.xid = xid;
    }

    public SessionXAPrepareMessage() {
        super((byte)54);
    }

    public Xid getXid() {
        return this.xid;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.xid == null ? 0 : this.xid.hashCode());
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", xid=" + String.valueOf(this.xid));
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAPrepareMessage)) {
            return false;
        }
        SessionXAPrepareMessage other = (SessionXAPrepareMessage)obj;
        return !(this.xid == null ? other.xid != null : !this.xid.equals(other.xid));
    }
}

